package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface NamespaceFluent<T extends NamespaceFluent<T>> extends Fluent<T>{


    public Namespace.ApiVersion getApiVersion();    public T withApiVersion( Namespace.ApiVersion apiVersion);    public String getKind();    public T withKind( String kind);    public ObjectMeta getMetadata();    public T withMetadata( ObjectMeta metadata);    public MetadataNested<T> withNewMetadata();    public MetadataNested<T> withNewMetadataLike( ObjectMeta item);    public MetadataNested<T> editMetadata();    public NamespaceSpec getSpec();    public T withSpec( NamespaceSpec spec);    public SpecNested<T> withNewSpec();    public SpecNested<T> withNewSpecLike( NamespaceSpec item);    public SpecNested<T> editSpec();    public NamespaceStatus getStatus();    public T withStatus( NamespaceStatus status);    public StatusNested<T> withNewStatus();    public StatusNested<T> withNewStatusLike( NamespaceStatus item);    public StatusNested<T> editStatus();    public T withNewStatus( String phase);    public T addToAdditionalProperties( String key,  Object value);    public T removeFromAdditionalProperties( String key);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface MetadataNested<N> extends Nested<N>, ObjectMetaFluent<MetadataNested<N>>{
            public N and();            public N endMetadata();        
}

    public interface SpecNested<N> extends Nested<N>, NamespaceSpecFluent<SpecNested<N>>{
            public N endSpec();            public N and();        
}

    public interface StatusNested<N> extends Nested<N>, NamespaceStatusFluent<StatusNested<N>>{
            public N and();            public N endStatus();        
}


}
