package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class NodeSpecFluentImpl<T extends NodeSpecFluent<T>> extends BaseFluent<T> implements NodeSpecFluent<T>{

     String externalID;     String podCIDR;     String providerID;     Boolean unschedulable;     Map<String, Object> additionalProperties = new HashMap();

    public String getExternalID(){
    return this.externalID;
    }
    public T withExternalID( String externalID){
    this.externalID=externalID; return (T) this;
    }
    public String getPodCIDR(){
    return this.podCIDR;
    }
    public T withPodCIDR( String podCIDR){
    this.podCIDR=podCIDR; return (T) this;
    }
    public String getProviderID(){
    return this.providerID;
    }
    public T withProviderID( String providerID){
    this.providerID=providerID; return (T) this;
    }
    public Boolean isUnschedulable(){
    return this.unschedulable;
    }
    public T withUnschedulable( Boolean unschedulable){
    this.unschedulable=unschedulable; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
NodeSpecFluentImpl that = (NodeSpecFluentImpl) o;
if (externalID != null ? !externalID.equals(that.externalID) :that.externalID != null) return false;
if (podCIDR != null ? !podCIDR.equals(that.podCIDR) :that.podCIDR != null) return false;
if (providerID != null ? !providerID.equals(that.providerID) :that.providerID != null) return false;
if (unschedulable != null ? !unschedulable.equals(that.unschedulable) :that.unschedulable != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }



}
