package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface ObjectMetaFluent<T extends ObjectMetaFluent<T>> extends Fluent<T>{


    public T addToAnnotations( String key,  String value);    public T removeFromAnnotations( String key);    public Map<String, String> getAnnotations();    public T withAnnotations( Map<String, String> annotations);    public String getCreationTimestamp();    public T withCreationTimestamp( String creationTimestamp);    public String getDeletionTimestamp();    public T withDeletionTimestamp( String deletionTimestamp);    public String getGenerateName();    public T withGenerateName( String generateName);    public Long getGeneration();    public T withGeneration( Long generation);    public T addToLabels( String key,  String value);    public T removeFromLabels( String key);    public Map<String, String> getLabels();    public T withLabels( Map<String, String> labels);    public String getName();    public T withName( String name);    public String getNamespace();    public T withNamespace( String namespace);    public String getResourceVersion();    public T withResourceVersion( String resourceVersion);    public String getSelfLink();    public T withSelfLink( String selfLink);    public String getUid();    public T withUid( String uid);    public T addToAdditionalProperties( String key,  Object value);    public T removeFromAdditionalProperties( String key);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);

}
