package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.Map;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;

public interface ClusterPolicyFluent<T extends ClusterPolicyFluent<T>> extends Fluent<T>{


    public ClusterPolicy.ApiVersion getApiVersion();    public T withApiVersion( ClusterPolicy.ApiVersion apiVersion);    public String getKind();    public T withKind( String kind);    public String getLastModified();    public T withLastModified( String lastModified);    public ObjectMeta getMetadata();    public T withMetadata( ObjectMeta metadata);    public MetadataNested<T> withNewMetadata();    public MetadataNested<T> withNewMetadataLike( ObjectMeta item);    public MetadataNested<T> editMetadata();    public T addToRoles( NamedClusterRole ...items);    public T removeFromRoles( NamedClusterRole ...items);    public List<NamedClusterRole> getRoles();    public T withRoles( List<NamedClusterRole> roles);    public T withRoles( NamedClusterRole ...roles);    public RolesNested<T> addNewRole();    public RolesNested<T> addNewRoleLike( NamedClusterRole item);    public T addToAdditionalProperties( String key,  Object value);    public T removeFromAdditionalProperties( String key);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface MetadataNested<N> extends Nested<N>, ObjectMetaFluent<MetadataNested<N>>{
            public N and();            public N endMetadata();        
}

    public interface RolesNested<N> extends Nested<N>, NamedClusterRoleFluent<RolesNested<N>>{
            public N endRole();            public N and();        
}


}
