package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public class ClusterFluentImpl<T extends ClusterFluent<T>> extends BaseFluent<T> implements ClusterFluent<T>{

     String apiVersion;     String certificateAuthority;     String certificateAuthorityData;     List<VisitableBuilder<NamedExtension, ?>> extensions = new ArrayList();     Boolean insecureSkipTlsVerify;     String server;     Map<String, Object> additionalProperties = new HashMap();

    public String getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( String apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public String getCertificateAuthority(){
    return this.certificateAuthority;
    }
    public T withCertificateAuthority( String certificateAuthority){
    this.certificateAuthority=certificateAuthority; return (T) this;
    }
    public String getCertificateAuthorityData(){
    return this.certificateAuthorityData;
    }
    public T withCertificateAuthorityData( String certificateAuthorityData){
    this.certificateAuthorityData=certificateAuthorityData; return (T) this;
    }
    public T addToExtensions( NamedExtension ...items){
    for (NamedExtension item : items) {NamedExtensionBuilder builder = new NamedExtensionBuilder(item);_visitables.add(builder);this.extensions.add(builder);} return (T)this;
    }
    public T removeFromExtensions( NamedExtension ...items){
    for (NamedExtension item : items) {NamedExtensionBuilder builder = new NamedExtensionBuilder(item);_visitables.remove(builder);this.extensions.remove(builder);} return (T)this;
    }
    public List<NamedExtension> getExtensions(){
    return build(extensions);
    }
    public T withExtensions( List<NamedExtension> extensions){
    this.extensions.clear();if (extensions != null) {for (NamedExtension item : extensions){this.addToExtensions(item);}} return (T) this;
    }
    public T withExtensions( NamedExtension ...extensions){
    this.extensions.clear(); if (extensions != null) {for (NamedExtension item :extensions){ this.addToExtensions(item);}} return (T) this;
    }
    public ExtensionsNested<T> addNewExtension(){
    return new ExtensionsNestedImpl<T>();
    }
    public ExtensionsNested<T> addNewExtensionLike( NamedExtension item){
    return new ExtensionsNestedImpl<T>(item);
    }
    public Boolean isInsecureSkipTlsVerify(){
    return this.insecureSkipTlsVerify;
    }
    public T withInsecureSkipTlsVerify( Boolean insecureSkipTlsVerify){
    this.insecureSkipTlsVerify=insecureSkipTlsVerify; return (T) this;
    }
    public String getServer(){
    return this.server;
    }
    public T withServer( String server){
    this.server=server; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ClusterFluentImpl that = (ClusterFluentImpl) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (certificateAuthority != null ? !certificateAuthority.equals(that.certificateAuthority) :that.certificateAuthority != null) return false;
if (certificateAuthorityData != null ? !certificateAuthorityData.equals(that.certificateAuthorityData) :that.certificateAuthorityData != null) return false;
if (extensions != null ? !extensions.equals(that.extensions) :that.extensions != null) return false;
if (insecureSkipTlsVerify != null ? !insecureSkipTlsVerify.equals(that.insecureSkipTlsVerify) :that.insecureSkipTlsVerify != null) return false;
if (server != null ? !server.equals(that.server) :that.server != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class ExtensionsNestedImpl<N> extends NamedExtensionFluentImpl<ExtensionsNested<N>> implements ExtensionsNested<N>{

        private final NamedExtensionBuilder builder;
    
             ExtensionsNestedImpl (){
        this.builder = new NamedExtensionBuilder(this);
        }
             ExtensionsNestedImpl ( NamedExtension item){
        this.builder = new NamedExtensionBuilder(this, item);
        }
    
            public N and(){
            return (N) ClusterFluentImpl.this.addToExtensions(builder.build());
        }
            public N endExtension(){
            return and();
        }
    
}


}
