package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;

public class ObjectReferenceFluentImpl<T extends ObjectReferenceFluent<T>> extends BaseFluent<T> implements ObjectReferenceFluent<T>{

     String apiVersion;     String fieldPath;     String kind;     String name;     String namespace;     String resourceVersion;     String uid;     Map<String, Object> additionalProperties = new HashMap();

    public String getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( String apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public String getFieldPath(){
    return this.fieldPath;
    }
    public T withFieldPath( String fieldPath){
    this.fieldPath=fieldPath; return (T) this;
    }
    public String getKind(){
    return this.kind;
    }
    public T withKind( String kind){
    this.kind=kind; return (T) this;
    }
    public String getName(){
    return this.name;
    }
    public T withName( String name){
    this.name=name; return (T) this;
    }
    public String getNamespace(){
    return this.namespace;
    }
    public T withNamespace( String namespace){
    this.namespace=namespace; return (T) this;
    }
    public String getResourceVersion(){
    return this.resourceVersion;
    }
    public T withResourceVersion( String resourceVersion){
    this.resourceVersion=resourceVersion; return (T) this;
    }
    public String getUid(){
    return this.uid;
    }
    public T withUid( String uid){
    this.uid=uid; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ObjectReferenceFluentImpl that = (ObjectReferenceFluentImpl) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (fieldPath != null ? !fieldPath.equals(that.fieldPath) :that.fieldPath != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (name != null ? !name.equals(that.name) :that.name != null) return false;
if (namespace != null ? !namespace.equals(that.namespace) :that.namespace != null) return false;
if (resourceVersion != null ? !resourceVersion.equals(that.resourceVersion) :that.resourceVersion != null) return false;
if (uid != null ? !uid.equals(that.uid) :that.uid != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }



}
