package io.fabric8.openshift.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface RouteSpecFluent<T extends RouteSpecFluent<T>> extends Fluent<T>{


    public String getHost();    public T withHost( String host);    public String getPath();    public T withPath( String path);    public TLSConfig getTls();    public T withTls( TLSConfig tls);    public TlsNested<T> withNewTls();    public TlsNested<T> withNewTlsLike( TLSConfig item);    public TlsNested<T> editTls();    public T withNewTls( String caCertificate,  String certificate,  String destinationCACertificate,  String key,  String termination);    public ObjectReference getTo();    public T withTo( ObjectReference to);    public ToNested<T> withNewTo();    public ToNested<T> withNewToLike( ObjectReference item);    public ToNested<T> editTo();    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface TlsNested<N> extends Nested<N>, TLSConfigFluent<TlsNested<N>>{
            public N endTls();            public N and();        
}

    public interface ToNested<N> extends Nested<N>, ObjectReferenceFluent<ToNested<N>>{
            public N and();            public N endTo();        
}


}
