package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class ContainerPortFluentImpl<T extends ContainerPortFluent<T>> extends BaseFluent<T> implements ContainerPortFluent<T>{

     Integer containerPort;     String hostIP;     Integer hostPort;     String name;     String protocol;     Map<String, Object> additionalProperties = new HashMap();

    public Integer getContainerPort(){
    return this.containerPort;
    }
    public T withContainerPort( Integer containerPort){
    this.containerPort=containerPort; return (T) this;
    }
    public String getHostIP(){
    return this.hostIP;
    }
    public T withHostIP( String hostIP){
    this.hostIP=hostIP; return (T) this;
    }
    public Integer getHostPort(){
    return this.hostPort;
    }
    public T withHostPort( Integer hostPort){
    this.hostPort=hostPort; return (T) this;
    }
    public String getName(){
    return this.name;
    }
    public T withName( String name){
    this.name=name; return (T) this;
    }
    public String getProtocol(){
    return this.protocol;
    }
    public T withProtocol( String protocol){
    this.protocol=protocol; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ContainerPortFluentImpl that = (ContainerPortFluentImpl) o;
if (containerPort != null ? !containerPort.equals(that.containerPort) :that.containerPort != null) return false;
if (hostIP != null ? !hostIP.equals(that.hostIP) :that.hostIP != null) return false;
if (hostPort != null ? !hostPort.equals(that.hostPort) :that.hostPort != null) return false;
if (name != null ? !name.equals(that.name) :that.name != null) return false;
if (protocol != null ? !protocol.equals(that.protocol) :that.protocol != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }



}
