package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;

public class NodeSystemInfoFluentImpl<T extends NodeSystemInfoFluent<T>> extends BaseFluent<T> implements NodeSystemInfoFluent<T>{

     String bootID;     String containerRuntimeVersion;     String kernelVersion;     String kubeProxyVersion;     String kubeletVersion;     String machineID;     String osImage;     String systemUUID;     Map<String, Object> additionalProperties = new HashMap();

    public String getBootID(){
    return this.bootID;
    }
    public T withBootID( String bootID){
    this.bootID=bootID; return (T) this;
    }
    public String getContainerRuntimeVersion(){
    return this.containerRuntimeVersion;
    }
    public T withContainerRuntimeVersion( String containerRuntimeVersion){
    this.containerRuntimeVersion=containerRuntimeVersion; return (T) this;
    }
    public String getKernelVersion(){
    return this.kernelVersion;
    }
    public T withKernelVersion( String kernelVersion){
    this.kernelVersion=kernelVersion; return (T) this;
    }
    public String getKubeProxyVersion(){
    return this.kubeProxyVersion;
    }
    public T withKubeProxyVersion( String kubeProxyVersion){
    this.kubeProxyVersion=kubeProxyVersion; return (T) this;
    }
    public String getKubeletVersion(){
    return this.kubeletVersion;
    }
    public T withKubeletVersion( String kubeletVersion){
    this.kubeletVersion=kubeletVersion; return (T) this;
    }
    public String getMachineID(){
    return this.machineID;
    }
    public T withMachineID( String machineID){
    this.machineID=machineID; return (T) this;
    }
    public String getOsImage(){
    return this.osImage;
    }
    public T withOsImage( String osImage){
    this.osImage=osImage; return (T) this;
    }
    public String getSystemUUID(){
    return this.systemUUID;
    }
    public T withSystemUUID( String systemUUID){
    this.systemUUID=systemUUID; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
NodeSystemInfoFluentImpl that = (NodeSystemInfoFluentImpl) o;
if (bootID != null ? !bootID.equals(that.bootID) :that.bootID != null) return false;
if (containerRuntimeVersion != null ? !containerRuntimeVersion.equals(that.containerRuntimeVersion) :that.containerRuntimeVersion != null) return false;
if (kernelVersion != null ? !kernelVersion.equals(that.kernelVersion) :that.kernelVersion != null) return false;
if (kubeProxyVersion != null ? !kubeProxyVersion.equals(that.kubeProxyVersion) :that.kubeProxyVersion != null) return false;
if (kubeletVersion != null ? !kubeletVersion.equals(that.kubeletVersion) :that.kubeletVersion != null) return false;
if (machineID != null ? !machineID.equals(that.machineID) :that.machineID != null) return false;
if (osImage != null ? !osImage.equals(that.osImage) :that.osImage != null) return false;
if (systemUUID != null ? !systemUUID.equals(that.systemUUID) :that.systemUUID != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }



}
