package io.fabric8.openshift.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class BuildSourceFluentImpl<T extends BuildSourceFluent<T>> extends BaseFluent<T> implements BuildSourceFluent<T>{

     String contextDir;     VisitableBuilder<GitBuildSource, ?> git;     VisitableBuilder<LocalObjectReference, ?> sourceSecret;     String type;     Map<String, Object> additionalProperties = new HashMap();

    public String getContextDir(){
    return this.contextDir;
    }
    public T withContextDir( String contextDir){
    this.contextDir=contextDir; return (T) this;
    }
    public GitBuildSource getGit(){
    return this.git!=null?this.git.build():null;
    }
    public T withGit( GitBuildSource git){
    if (git!=null){ this.git= new GitBuildSourceBuilder(git); _visitables.add(this.git);} return (T) this;
    }
    public GitNested<T> withNewGit(){
    return new GitNestedImpl<T>();
    }
    public GitNested<T> withNewGitLike( GitBuildSource item){
    return new GitNestedImpl<T>(item);
    }
    public GitNested<T> editGit(){
    return withNewGitLike(getGit());
    }
    public T withNewGit( String httpProxy,  String httpsProxy,  String ref,  String uri){
    return withGit(new GitBuildSource(httpProxy, httpsProxy, ref, uri));
    }
    public LocalObjectReference getSourceSecret(){
    return this.sourceSecret!=null?this.sourceSecret.build():null;
    }
    public T withSourceSecret( LocalObjectReference sourceSecret){
    if (sourceSecret!=null){ this.sourceSecret= new LocalObjectReferenceBuilder(sourceSecret); _visitables.add(this.sourceSecret);} return (T) this;
    }
    public SourceSecretNested<T> withNewSourceSecret(){
    return new SourceSecretNestedImpl<T>();
    }
    public SourceSecretNested<T> withNewSourceSecretLike( LocalObjectReference item){
    return new SourceSecretNestedImpl<T>(item);
    }
    public SourceSecretNested<T> editSourceSecret(){
    return withNewSourceSecretLike(getSourceSecret());
    }
    public T withNewSourceSecret( String name){
    return withSourceSecret(new LocalObjectReference(name));
    }
    public String getType(){
    return this.type;
    }
    public T withType( String type){
    this.type=type; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
BuildSourceFluentImpl that = (BuildSourceFluentImpl) o;
if (contextDir != null ? !contextDir.equals(that.contextDir) :that.contextDir != null) return false;
if (git != null ? !git.equals(that.git) :that.git != null) return false;
if (sourceSecret != null ? !sourceSecret.equals(that.sourceSecret) :that.sourceSecret != null) return false;
if (type != null ? !type.equals(that.type) :that.type != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class GitNestedImpl<N> extends GitBuildSourceFluentImpl<GitNested<N>> implements GitNested<N>{

        private final GitBuildSourceBuilder builder;
    
             GitNestedImpl (){
        this.builder = new GitBuildSourceBuilder(this);
        }
             GitNestedImpl ( GitBuildSource item){
        this.builder = new GitBuildSourceBuilder(this, item);
        }
    
            public N and(){
            return (N) BuildSourceFluentImpl.this.withGit(builder.build());
        }
            public N endGit(){
            return and();
        }
    
}
    public class SourceSecretNestedImpl<N> extends LocalObjectReferenceFluentImpl<SourceSecretNested<N>> implements SourceSecretNested<N>{

        private final LocalObjectReferenceBuilder builder;
    
             SourceSecretNestedImpl (){
        this.builder = new LocalObjectReferenceBuilder(this);
        }
             SourceSecretNestedImpl ( LocalObjectReference item){
        this.builder = new LocalObjectReferenceBuilder(this, item);
        }
    
            public N and(){
            return (N) BuildSourceFluentImpl.this.withSourceSecret(builder.build());
        }
            public N endSourceSecret(){
            return and();
        }
    
}


}
