package io.fabric8.openshift.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class BuildStrategyFluentImpl<T extends BuildStrategyFluent<T>> extends BaseFluent<T> implements BuildStrategyFluent<T>{

     VisitableBuilder<CustomBuildStrategy, ?> customStrategy;     VisitableBuilder<DockerBuildStrategy, ?> dockerStrategy;     VisitableBuilder<SourceBuildStrategy, ?> sourceStrategy;     String type;     Map<String, Object> additionalProperties = new HashMap();

    public CustomBuildStrategy getCustomStrategy(){
    return this.customStrategy!=null?this.customStrategy.build():null;
    }
    public T withCustomStrategy( CustomBuildStrategy customStrategy){
    if (customStrategy!=null){ this.customStrategy= new CustomBuildStrategyBuilder(customStrategy); _visitables.add(this.customStrategy);} return (T) this;
    }
    public CustomStrategyNested<T> withNewCustomStrategy(){
    return new CustomStrategyNestedImpl<T>();
    }
    public CustomStrategyNested<T> withNewCustomStrategyLike( CustomBuildStrategy item){
    return new CustomStrategyNestedImpl<T>(item);
    }
    public CustomStrategyNested<T> editCustomStrategy(){
    return withNewCustomStrategyLike(getCustomStrategy());
    }
    public DockerBuildStrategy getDockerStrategy(){
    return this.dockerStrategy!=null?this.dockerStrategy.build():null;
    }
    public T withDockerStrategy( DockerBuildStrategy dockerStrategy){
    if (dockerStrategy!=null){ this.dockerStrategy= new DockerBuildStrategyBuilder(dockerStrategy); _visitables.add(this.dockerStrategy);} return (T) this;
    }
    public DockerStrategyNested<T> withNewDockerStrategy(){
    return new DockerStrategyNestedImpl<T>();
    }
    public DockerStrategyNested<T> withNewDockerStrategyLike( DockerBuildStrategy item){
    return new DockerStrategyNestedImpl<T>(item);
    }
    public DockerStrategyNested<T> editDockerStrategy(){
    return withNewDockerStrategyLike(getDockerStrategy());
    }
    public SourceBuildStrategy getSourceStrategy(){
    return this.sourceStrategy!=null?this.sourceStrategy.build():null;
    }
    public T withSourceStrategy( SourceBuildStrategy sourceStrategy){
    if (sourceStrategy!=null){ this.sourceStrategy= new SourceBuildStrategyBuilder(sourceStrategy); _visitables.add(this.sourceStrategy);} return (T) this;
    }
    public SourceStrategyNested<T> withNewSourceStrategy(){
    return new SourceStrategyNestedImpl<T>();
    }
    public SourceStrategyNested<T> withNewSourceStrategyLike( SourceBuildStrategy item){
    return new SourceStrategyNestedImpl<T>(item);
    }
    public SourceStrategyNested<T> editSourceStrategy(){
    return withNewSourceStrategyLike(getSourceStrategy());
    }
    public String getType(){
    return this.type;
    }
    public T withType( String type){
    this.type=type; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
BuildStrategyFluentImpl that = (BuildStrategyFluentImpl) o;
if (customStrategy != null ? !customStrategy.equals(that.customStrategy) :that.customStrategy != null) return false;
if (dockerStrategy != null ? !dockerStrategy.equals(that.dockerStrategy) :that.dockerStrategy != null) return false;
if (sourceStrategy != null ? !sourceStrategy.equals(that.sourceStrategy) :that.sourceStrategy != null) return false;
if (type != null ? !type.equals(that.type) :that.type != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class CustomStrategyNestedImpl<N> extends CustomBuildStrategyFluentImpl<CustomStrategyNested<N>> implements CustomStrategyNested<N>{

        private final CustomBuildStrategyBuilder builder;
    
             CustomStrategyNestedImpl (){
        this.builder = new CustomBuildStrategyBuilder(this);
        }
             CustomStrategyNestedImpl ( CustomBuildStrategy item){
        this.builder = new CustomBuildStrategyBuilder(this, item);
        }
    
            public N endCustomStrategy(){
            return and();
        }
            public N and(){
            return (N) BuildStrategyFluentImpl.this.withCustomStrategy(builder.build());
        }
    
}
    public class DockerStrategyNestedImpl<N> extends DockerBuildStrategyFluentImpl<DockerStrategyNested<N>> implements DockerStrategyNested<N>{

        private final DockerBuildStrategyBuilder builder;
    
             DockerStrategyNestedImpl (){
        this.builder = new DockerBuildStrategyBuilder(this);
        }
             DockerStrategyNestedImpl ( DockerBuildStrategy item){
        this.builder = new DockerBuildStrategyBuilder(this, item);
        }
    
            public N and(){
            return (N) BuildStrategyFluentImpl.this.withDockerStrategy(builder.build());
        }
            public N endDockerStrategy(){
            return and();
        }
    
}
    public class SourceStrategyNestedImpl<N> extends SourceBuildStrategyFluentImpl<SourceStrategyNested<N>> implements SourceStrategyNested<N>{

        private final SourceBuildStrategyBuilder builder;
    
             SourceStrategyNestedImpl (){
        this.builder = new SourceBuildStrategyBuilder(this);
        }
             SourceStrategyNestedImpl ( SourceBuildStrategy item){
        this.builder = new SourceBuildStrategyBuilder(this, item);
        }
    
            public N and(){
            return (N) BuildStrategyFluentImpl.this.withSourceStrategy(builder.build());
        }
            public N endSourceStrategy(){
            return and();
        }
    
}


}
