/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EditableNamespaceSpec;
import io.fabric8.kubernetes.api.model.NamespaceSpec;
import io.fabric8.kubernetes.api.model.NamespaceSpecFluent;
import io.fabric8.kubernetes.api.model.NamespaceSpecFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class NamespaceSpecBuilder
extends NamespaceSpecFluentImpl<NamespaceSpecBuilder>
implements VisitableBuilder<NamespaceSpec, NamespaceSpecBuilder> {
    NamespaceSpecFluent<?> fluent;

    public NamespaceSpecBuilder() {
        this(new NamespaceSpec());
    }

    public NamespaceSpecBuilder(NamespaceSpecFluent<?> fluent) {
        this(fluent, new NamespaceSpec());
    }

    public NamespaceSpecBuilder(NamespaceSpecFluent<?> fluent, NamespaceSpec instance) {
        this.fluent = fluent;
        fluent.withFinalizers(instance.getFinalizers());
    }

    public NamespaceSpecBuilder(NamespaceSpec instance) {
        this.fluent = this;
        this.withFinalizers(instance.getFinalizers());
    }

    @Override
    public EditableNamespaceSpec build() {
        EditableNamespaceSpec buildable = new EditableNamespaceSpec(this.fluent.getFinalizers());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NamespaceSpecBuilder that = (NamespaceSpecBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

