/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.Node;
import io.fabric8.kubernetes.api.model.NodeFluent;
import io.fabric8.kubernetes.api.model.NodeSpec;
import io.fabric8.kubernetes.api.model.NodeSpecBuilder;
import io.fabric8.kubernetes.api.model.NodeSpecFluentImpl;
import io.fabric8.kubernetes.api.model.NodeStatus;
import io.fabric8.kubernetes.api.model.NodeStatusBuilder;
import io.fabric8.kubernetes.api.model.NodeStatusFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import java.util.HashMap;
import java.util.Map;

public class NodeFluentImpl<T extends NodeFluent<T>>
extends BaseFluent<T>
implements NodeFluent<T> {
    Node.ApiVersion apiVersion;
    String kind;
    VisitableBuilder<ObjectMeta, ?> metadata;
    VisitableBuilder<NodeSpec, ?> spec;
    VisitableBuilder<NodeStatus, ?> status;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @Override
    public Node.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public T withApiVersion(Node.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        return (T)this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public T withKind(String kind) {
        this.kind = kind;
        return (T)this;
    }

    @Override
    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    @Override
    public T withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)this;
    }

    @Override
    public NodeFluent.MetadataNested<T> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public NodeFluent.MetadataNested<T> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public NodeFluent.MetadataNested<T> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public NodeSpec getSpec() {
        return this.spec != null ? (NodeSpec)this.spec.build() : null;
    }

    @Override
    public T withSpec(NodeSpec spec) {
        if (spec != null) {
            this.spec = new NodeSpecBuilder(spec);
            this._visitables.add(this.spec);
        }
        return (T)this;
    }

    @Override
    public NodeFluent.SpecNested<T> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public NodeFluent.SpecNested<T> withNewSpecLike(NodeSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public NodeFluent.SpecNested<T> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public T withNewSpec(String externalID, String podCIDR, String providerID, Boolean unschedulable) {
        return this.withSpec(new NodeSpec(externalID, podCIDR, providerID, unschedulable));
    }

    @Override
    public NodeStatus getStatus() {
        return this.status != null ? (NodeStatus)this.status.build() : null;
    }

    @Override
    public T withStatus(NodeStatus status) {
        if (status != null) {
            this.status = new NodeStatusBuilder(status);
            this._visitables.add(this.status);
        }
        return (T)this;
    }

    @Override
    public NodeFluent.StatusNested<T> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public NodeFluent.StatusNested<T> withNewStatusLike(NodeStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public NodeFluent.StatusNested<T> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeFluentImpl that = (NodeFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals((Object)that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        if (this.status != null ? !this.status.equals(that.status) : that.status != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class StatusNestedImpl<N>
    extends NodeStatusFluentImpl<NodeFluent.StatusNested<N>>
    implements NodeFluent.StatusNested<N> {
        private final NodeStatusBuilder builder;

        StatusNestedImpl() {
            this.builder = new NodeStatusBuilder(this);
        }

        StatusNestedImpl(NodeStatus item) {
            this.builder = new NodeStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NodeFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNestedImpl<N>
    extends NodeSpecFluentImpl<NodeFluent.SpecNested<N>>
    implements NodeFluent.SpecNested<N> {
        private final NodeSpecBuilder builder;

        SpecNestedImpl() {
            this.builder = new NodeSpecBuilder(this);
        }

        SpecNestedImpl(NodeSpec item) {
            this.builder = new NodeSpecBuilder(this, item);
        }

        @Override
        public N endSpec() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)NodeFluentImpl.this.withSpec(this.builder.build());
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<NodeFluent.MetadataNested<N>>
    implements NodeFluent.MetadataNested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NodeFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

