package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluentImpl;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class BuildSpecFluentImpl<T extends BuildSpecFluent<T>> extends BaseFluent<T> implements BuildSpecFluent<T>{

     VisitableBuilder<BuildOutput, ?> output;     VisitableBuilder<ResourceRequirements, ?> resources;     VisitableBuilder<SourceRevision, ?> revision;     String serviceAccount;     VisitableBuilder<BuildSource, ?> source;     VisitableBuilder<BuildStrategy, ?> strategy;     Map<String, Object> additionalProperties = new HashMap();
public BuildSpecFluentImpl(){
    
}
public BuildSpecFluentImpl( BuildSpec instance ){
    this.withOutput(instance.getOutput()); this.withResources(instance.getResources()); this.withRevision(instance.getRevision()); this.withServiceAccount(instance.getServiceAccount()); this.withSource(instance.getSource()); this.withStrategy(instance.getStrategy()); 
}

    public BuildOutput getOutput(){
    return this.output!=null?this.output.build():null;
    }
    public T withOutput( BuildOutput output){
    if (output!=null){ this.output= new BuildOutputBuilder(output); _visitables.add(this.output);} return (T) this;
    }
    public OutputNested<T> withNewOutput(){
    return new OutputNestedImpl<T>();
    }
    public OutputNested<T> withNewOutputLike( BuildOutput item){
    return new OutputNestedImpl<T>(item);
    }
    public OutputNested<T> editOutput(){
    return withNewOutputLike(getOutput());
    }
    public ResourceRequirements getResources(){
    return this.resources!=null?this.resources.build():null;
    }
    public T withResources( ResourceRequirements resources){
    if (resources!=null){ this.resources= new ResourceRequirementsBuilder(resources); _visitables.add(this.resources);} return (T) this;
    }
    public ResourcesNested<T> withNewResources(){
    return new ResourcesNestedImpl<T>();
    }
    public ResourcesNested<T> withNewResourcesLike( ResourceRequirements item){
    return new ResourcesNestedImpl<T>(item);
    }
    public ResourcesNested<T> editResources(){
    return withNewResourcesLike(getResources());
    }
    public SourceRevision getRevision(){
    return this.revision!=null?this.revision.build():null;
    }
    public T withRevision( SourceRevision revision){
    if (revision!=null){ this.revision= new SourceRevisionBuilder(revision); _visitables.add(this.revision);} return (T) this;
    }
    public RevisionNested<T> withNewRevision(){
    return new RevisionNestedImpl<T>();
    }
    public RevisionNested<T> withNewRevisionLike( SourceRevision item){
    return new RevisionNestedImpl<T>(item);
    }
    public RevisionNested<T> editRevision(){
    return withNewRevisionLike(getRevision());
    }
    public String getServiceAccount(){
    return this.serviceAccount;
    }
    public T withServiceAccount( String serviceAccount){
    this.serviceAccount=serviceAccount; return (T) this;
    }
    public BuildSource getSource(){
    return this.source!=null?this.source.build():null;
    }
    public T withSource( BuildSource source){
    if (source!=null){ this.source= new BuildSourceBuilder(source); _visitables.add(this.source);} return (T) this;
    }
    public SourceNested<T> withNewSource(){
    return new SourceNestedImpl<T>();
    }
    public SourceNested<T> withNewSourceLike( BuildSource item){
    return new SourceNestedImpl<T>(item);
    }
    public SourceNested<T> editSource(){
    return withNewSourceLike(getSource());
    }
    public BuildStrategy getStrategy(){
    return this.strategy!=null?this.strategy.build():null;
    }
    public T withStrategy( BuildStrategy strategy){
    if (strategy!=null){ this.strategy= new BuildStrategyBuilder(strategy); _visitables.add(this.strategy);} return (T) this;
    }
    public StrategyNested<T> withNewStrategy(){
    return new StrategyNestedImpl<T>();
    }
    public StrategyNested<T> withNewStrategyLike( BuildStrategy item){
    return new StrategyNestedImpl<T>(item);
    }
    public StrategyNested<T> editStrategy(){
    return withNewStrategyLike(getStrategy());
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
BuildSpecFluentImpl that = (BuildSpecFluentImpl) o;
if (output != null ? !output.equals(that.output) :that.output != null) return false;
if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
if (revision != null ? !revision.equals(that.revision) :that.revision != null) return false;
if (serviceAccount != null ? !serviceAccount.equals(that.serviceAccount) :that.serviceAccount != null) return false;
if (source != null ? !source.equals(that.source) :that.source != null) return false;
if (strategy != null ? !strategy.equals(that.strategy) :that.strategy != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class OutputNestedImpl<N> extends BuildOutputFluentImpl<OutputNested<N>> implements OutputNested<N>{

        private final BuildOutputBuilder builder;
    
             OutputNestedImpl (){
        this.builder = new BuildOutputBuilder(this);
        }
             OutputNestedImpl ( BuildOutput item){
        this.builder = new BuildOutputBuilder(this, item);
        }
    
            public N endOutput(){
            return and();
        }
            public N and(){
            return (N) BuildSpecFluentImpl.this.withOutput(builder.build());
        }
    
}
    public class ResourcesNestedImpl<N> extends ResourceRequirementsFluentImpl<ResourcesNested<N>> implements ResourcesNested<N>{

        private final ResourceRequirementsBuilder builder;
    
             ResourcesNestedImpl (){
        this.builder = new ResourceRequirementsBuilder(this);
        }
             ResourcesNestedImpl ( ResourceRequirements item){
        this.builder = new ResourceRequirementsBuilder(this, item);
        }
    
            public N and(){
            return (N) BuildSpecFluentImpl.this.withResources(builder.build());
        }
            public N endResources(){
            return and();
        }
    
}
    public class RevisionNestedImpl<N> extends SourceRevisionFluentImpl<RevisionNested<N>> implements RevisionNested<N>{

        private final SourceRevisionBuilder builder;
    
             RevisionNestedImpl ( SourceRevision item){
        this.builder = new SourceRevisionBuilder(this, item);
        }
             RevisionNestedImpl (){
        this.builder = new SourceRevisionBuilder(this);
        }
    
            public N endRevision(){
            return and();
        }
            public N and(){
            return (N) BuildSpecFluentImpl.this.withRevision(builder.build());
        }
    
}
    public class SourceNestedImpl<N> extends BuildSourceFluentImpl<SourceNested<N>> implements SourceNested<N>{

        private final BuildSourceBuilder builder;
    
             SourceNestedImpl (){
        this.builder = new BuildSourceBuilder(this);
        }
             SourceNestedImpl ( BuildSource item){
        this.builder = new BuildSourceBuilder(this, item);
        }
    
            public N and(){
            return (N) BuildSpecFluentImpl.this.withSource(builder.build());
        }
            public N endSource(){
            return and();
        }
    
}
    public class StrategyNestedImpl<N> extends BuildStrategyFluentImpl<StrategyNested<N>> implements StrategyNested<N>{

        private final BuildStrategyBuilder builder;
    
             StrategyNestedImpl (){
        this.builder = new BuildStrategyBuilder(this);
        }
             StrategyNestedImpl ( BuildStrategy item){
        this.builder = new BuildStrategyBuilder(this, item);
        }
    
            public N endStrategy(){
            return and();
        }
            public N and(){
            return (N) BuildSpecFluentImpl.this.withStrategy(builder.build());
        }
    
}


}
