package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.HasMetadata;
import java.util.ArrayList;
import java.util.Map;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ResourceQuotaFluent;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.NodeFluent;
import io.fabric8.kubernetes.api.model.ResourceQuotaBuilder;
import io.fabric8.kubernetes.api.model.EventFluentImpl;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.EndpointsBuilder;
import io.fabric8.kubernetes.api.model.ServiceAccountFluent;
import io.fabric8.kubernetes.api.model.PersistentVolumeBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.PersistentVolume;
import io.fabric8.kubernetes.api.model.Event;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.api.model.PodFluentImpl;
import io.fabric8.kubernetes.api.model.EndpointsFluent;
import io.fabric8.kubernetes.api.model.SecurityContextConstraintsFluent;
import io.fabric8.kubernetes.api.model.SecurityContextConstraintsBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.SecurityContextConstraintsFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentImpl;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ResourceQuota;
import io.fabric8.kubernetes.api.model.SecretFluentImpl;
import io.fabric8.kubernetes.api.model.ResourceQuotaFluentImpl;
import io.fabric8.kubernetes.api.model.ServiceAccountBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeFluent;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluent;
import io.fabric8.kubernetes.api.model.SecretBuilder;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.EventFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.SecretFluent;
import io.fabric8.kubernetes.api.model.SecurityContextConstraints;
import io.fabric8.kubernetes.api.model.EventBuilder;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.NodeFluentImpl;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.ServiceAccountFluentImpl;
import io.fabric8.kubernetes.api.model.EndpointsFluentImpl;
import io.fabric8.kubernetes.api.model.NodeBuilder;
import io.fabric8.kubernetes.api.model.Node;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluentImpl;
import io.fabric8.kubernetes.api.model.ReplicationControllerBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.NamespaceFluentImpl;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.PersistentVolumeFluentImpl;
import io.fabric8.kubernetes.api.model.ServiceFluentImpl;

public class TemplateFluentImpl<T extends TemplateFluent<T>> extends BaseFluent<T> implements TemplateFluent<T>{

     Template.ApiVersion apiVersion;     String kind;     Map<String, String> labels = new HashMap();     VisitableBuilder<ObjectMeta, ?> metadata;     List<HasMetadata> objects = new ArrayList();     List<VisitableBuilder<Policy, ?>> policyObjects = new ArrayList();     List<VisitableBuilder<Template, ?>> templateObjects = new ArrayList();     List<VisitableBuilder<Project, ?>> projectObjects = new ArrayList();     List<VisitableBuilder<OAuthAuthorizeToken, ?>> oAuthAuthorizeTokenObjects = new ArrayList();     List<VisitableBuilder<RoleBinding, ?>> roleBindingObjects = new ArrayList();     List<VisitableBuilder<BuildConfig, ?>> buildConfigObjects = new ArrayList();     List<VisitableBuilder<Secret, ?>> secretObjects = new ArrayList();     List<VisitableBuilder<ReplicationController, ?>> replicationControllerObjects = new ArrayList();     List<VisitableBuilder<User, ?>> userObjects = new ArrayList();     List<VisitableBuilder<Image, ?>> imageObjects = new ArrayList();     List<VisitableBuilder<Endpoints, ?>> endpointsObjects = new ArrayList();     List<VisitableBuilder<ClusterRole, ?>> clusterRoleObjects = new ArrayList();     List<VisitableBuilder<Route, ?>> routeObjects = new ArrayList();     List<VisitableBuilder<Role, ?>> roleObjects = new ArrayList();     List<VisitableBuilder<SecurityContextConstraints, ?>> securityContextConstraintsObjects = new ArrayList();     List<VisitableBuilder<Node, ?>> nodeObjects = new ArrayList();     List<VisitableBuilder<OAuthClientAuthorization, ?>> oAuthClientAuthorizationObjects = new ArrayList();     List<VisitableBuilder<OAuthAccessToken, ?>> oAuthAccessTokenObjects = new ArrayList();     List<VisitableBuilder<ServiceAccount, ?>> serviceAccountObjects = new ArrayList();     List<VisitableBuilder<ImageStream, ?>> imageStreamObjects = new ArrayList();     List<VisitableBuilder<BuildRequest, ?>> buildRequestObjects = new ArrayList();     List<VisitableBuilder<Service, ?>> serviceObjects = new ArrayList();     List<VisitableBuilder<Build, ?>> buildObjects = new ArrayList();     List<VisitableBuilder<DeploymentConfig, ?>> deploymentConfigObjects = new ArrayList();     List<VisitableBuilder<ClusterRoleBinding, ?>> clusterRoleBindingObjects = new ArrayList();     List<VisitableBuilder<Group, ?>> groupObjects = new ArrayList();     List<VisitableBuilder<PersistentVolumeClaim, ?>> persistentVolumeClaimObjects = new ArrayList();     List<VisitableBuilder<Pod, ?>> podObjects = new ArrayList();     List<VisitableBuilder<PolicyBinding, ?>> policyBindingObjects = new ArrayList();     List<VisitableBuilder<OAuthClient, ?>> oAuthClientObjects = new ArrayList();     List<VisitableBuilder<PersistentVolume, ?>> persistentVolumeObjects = new ArrayList();     List<VisitableBuilder<Event, ?>> eventObjects = new ArrayList();     List<VisitableBuilder<ResourceQuota, ?>> resourceQuotaObjects = new ArrayList();     List<VisitableBuilder<ClusterPolicy, ?>> clusterPolicyObjects = new ArrayList();     List<VisitableBuilder<ClusterPolicyBinding, ?>> clusterPolicyBindingObjects = new ArrayList();     List<VisitableBuilder<Namespace, ?>> namespaceObjects = new ArrayList();     List<VisitableBuilder<Identity, ?>> identityObjects = new ArrayList();     List<VisitableBuilder<Parameter, ?>> parameters = new ArrayList();     Map<String, Object> additionalProperties = new HashMap();
public TemplateFluentImpl(){
    
}
public TemplateFluentImpl( Template instance ){
    this.withApiVersion(instance.getApiVersion()); this.withKind(instance.getKind()); this.withLabels(instance.getLabels()); this.withMetadata(instance.getMetadata()); this.withObjects(instance.getObjects()); this.withParameters(instance.getParameters()); 
}

    public Template.ApiVersion getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( Template.ApiVersion apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public String getKind(){
    return this.kind;
    }
    public T withKind( String kind){
    this.kind=kind; return (T) this;
    }
    public T addToLabels( String key,  String value){
    if(key != null && value != null) {this.labels.put(key, value);} return (T)this;
    }
    public T addToLabels( Map<String, String> map){
    if(map != null) { this.labels.putAll(map);} return (T)this;
    }
    public T removeFromLabels( String key){
    if(key != null) {this.labels.remove(key);} return (T)this;
    }
    public T removeFromLabels( Map<String, String> map){
    if(map != null) { for(Object key : map.keySet()) {this.labels.remove(key);}} return (T)this;
    }
    public Map<String, String> getLabels(){
    return this.labels;
    }
    public T withLabels( Map<String, String> labels){
    this.labels.clear();if (labels != null) {this.labels.putAll(labels);} return (T) this;
    }
    public ObjectMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public T withMetadata( ObjectMeta metadata){
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (T) this;
    }
    public MetadataNested<T> withNewMetadata(){
    return new MetadataNestedImpl<T>();
    }
    public MetadataNested<T> withNewMetadataLike( ObjectMeta item){
    return new MetadataNestedImpl<T>(item);
    }
    public MetadataNested<T> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public T addToObjects( HasMetadata ...items){
    for (HasMetadata item : items) {if (item instanceof Policy){addToPolicyObjects((Policy)item);}
 else if (item instanceof Template){addToTemplateObjects((Template)item);}
 else if (item instanceof Project){addToProjectObjects((Project)item);}
 else if (item instanceof OAuthAuthorizeToken){addToOAuthAuthorizeTokenObjects((OAuthAuthorizeToken)item);}
 else if (item instanceof RoleBinding){addToRoleBindingObjects((RoleBinding)item);}
 else if (item instanceof BuildConfig){addToBuildConfigObjects((BuildConfig)item);}
 else if (item instanceof Secret){addToSecretObjects((Secret)item);}
 else if (item instanceof ReplicationController){addToReplicationControllerObjects((ReplicationController)item);}
 else if (item instanceof User){addToUserObjects((User)item);}
 else if (item instanceof Image){addToImageObjects((Image)item);}
 else if (item instanceof Endpoints){addToEndpointsObjects((Endpoints)item);}
 else if (item instanceof ClusterRole){addToClusterRoleObjects((ClusterRole)item);}
 else if (item instanceof Route){addToRouteObjects((Route)item);}
 else if (item instanceof Role){addToRoleObjects((Role)item);}
 else if (item instanceof SecurityContextConstraints){addToSecurityContextConstraintsObjects((SecurityContextConstraints)item);}
 else if (item instanceof Node){addToNodeObjects((Node)item);}
 else if (item instanceof OAuthClientAuthorization){addToOAuthClientAuthorizationObjects((OAuthClientAuthorization)item);}
 else if (item instanceof OAuthAccessToken){addToOAuthAccessTokenObjects((OAuthAccessToken)item);}
 else if (item instanceof ServiceAccount){addToServiceAccountObjects((ServiceAccount)item);}
 else if (item instanceof ImageStream){addToImageStreamObjects((ImageStream)item);}
 else if (item instanceof BuildRequest){addToBuildRequestObjects((BuildRequest)item);}
 else if (item instanceof Service){addToServiceObjects((Service)item);}
 else if (item instanceof Build){addToBuildObjects((Build)item);}
 else if (item instanceof DeploymentConfig){addToDeploymentConfigObjects((DeploymentConfig)item);}
 else if (item instanceof ClusterRoleBinding){addToClusterRoleBindingObjects((ClusterRoleBinding)item);}
 else if (item instanceof Group){addToGroupObjects((Group)item);}
 else if (item instanceof PersistentVolumeClaim){addToPersistentVolumeClaimObjects((PersistentVolumeClaim)item);}
 else if (item instanceof Pod){addToPodObjects((Pod)item);}
 else if (item instanceof PolicyBinding){addToPolicyBindingObjects((PolicyBinding)item);}
 else if (item instanceof OAuthClient){addToOAuthClientObjects((OAuthClient)item);}
 else if (item instanceof PersistentVolume){addToPersistentVolumeObjects((PersistentVolume)item);}
 else if (item instanceof Event){addToEventObjects((Event)item);}
 else if (item instanceof ResourceQuota){addToResourceQuotaObjects((ResourceQuota)item);}
 else if (item instanceof ClusterPolicy){addToClusterPolicyObjects((ClusterPolicy)item);}
 else if (item instanceof ClusterPolicyBinding){addToClusterPolicyBindingObjects((ClusterPolicyBinding)item);}
 else if (item instanceof Namespace){addToNamespaceObjects((Namespace)item);}
 else if (item instanceof Identity){addToIdentityObjects((Identity)item);}
} return (T)this;
    }
    public T removeFromObjects( HasMetadata ...items){
    for (HasMetadata item : items) {if (item instanceof Policy){removeFromPolicyObjects((Policy)item);}
 else if (item instanceof Template){removeFromTemplateObjects((Template)item);}
 else if (item instanceof Project){removeFromProjectObjects((Project)item);}
 else if (item instanceof OAuthAuthorizeToken){removeFromOAuthAuthorizeTokenObjects((OAuthAuthorizeToken)item);}
 else if (item instanceof RoleBinding){removeFromRoleBindingObjects((RoleBinding)item);}
 else if (item instanceof BuildConfig){removeFromBuildConfigObjects((BuildConfig)item);}
 else if (item instanceof Secret){removeFromSecretObjects((Secret)item);}
 else if (item instanceof ReplicationController){removeFromReplicationControllerObjects((ReplicationController)item);}
 else if (item instanceof User){removeFromUserObjects((User)item);}
 else if (item instanceof Image){removeFromImageObjects((Image)item);}
 else if (item instanceof Endpoints){removeFromEndpointsObjects((Endpoints)item);}
 else if (item instanceof ClusterRole){removeFromClusterRoleObjects((ClusterRole)item);}
 else if (item instanceof Route){removeFromRouteObjects((Route)item);}
 else if (item instanceof Role){removeFromRoleObjects((Role)item);}
 else if (item instanceof SecurityContextConstraints){removeFromSecurityContextConstraintsObjects((SecurityContextConstraints)item);}
 else if (item instanceof Node){removeFromNodeObjects((Node)item);}
 else if (item instanceof OAuthClientAuthorization){removeFromOAuthClientAuthorizationObjects((OAuthClientAuthorization)item);}
 else if (item instanceof OAuthAccessToken){removeFromOAuthAccessTokenObjects((OAuthAccessToken)item);}
 else if (item instanceof ServiceAccount){removeFromServiceAccountObjects((ServiceAccount)item);}
 else if (item instanceof ImageStream){removeFromImageStreamObjects((ImageStream)item);}
 else if (item instanceof BuildRequest){removeFromBuildRequestObjects((BuildRequest)item);}
 else if (item instanceof Service){removeFromServiceObjects((Service)item);}
 else if (item instanceof Build){removeFromBuildObjects((Build)item);}
 else if (item instanceof DeploymentConfig){removeFromDeploymentConfigObjects((DeploymentConfig)item);}
 else if (item instanceof ClusterRoleBinding){removeFromClusterRoleBindingObjects((ClusterRoleBinding)item);}
 else if (item instanceof Group){removeFromGroupObjects((Group)item);}
 else if (item instanceof PersistentVolumeClaim){removeFromPersistentVolumeClaimObjects((PersistentVolumeClaim)item);}
 else if (item instanceof Pod){removeFromPodObjects((Pod)item);}
 else if (item instanceof PolicyBinding){removeFromPolicyBindingObjects((PolicyBinding)item);}
 else if (item instanceof OAuthClient){removeFromOAuthClientObjects((OAuthClient)item);}
 else if (item instanceof PersistentVolume){removeFromPersistentVolumeObjects((PersistentVolume)item);}
 else if (item instanceof Event){removeFromEventObjects((Event)item);}
 else if (item instanceof ResourceQuota){removeFromResourceQuotaObjects((ResourceQuota)item);}
 else if (item instanceof ClusterPolicy){removeFromClusterPolicyObjects((ClusterPolicy)item);}
 else if (item instanceof ClusterPolicyBinding){removeFromClusterPolicyBindingObjects((ClusterPolicyBinding)item);}
 else if (item instanceof Namespace){removeFromNamespaceObjects((Namespace)item);}
 else if (item instanceof Identity){removeFromIdentityObjects((Identity)item);}
} return (T)this;
    }
    public List<HasMetadata> getObjects(){
    return aggregate(build(buildConfigObjects), build(buildObjects), build(buildRequestObjects), build(clusterPolicyBindingObjects), build(clusterPolicyObjects), build(clusterRoleBindingObjects), build(clusterRoleObjects), build(deploymentConfigObjects), build(endpointsObjects), build(eventObjects), build(groupObjects), build(identityObjects), build(imageObjects), build(imageStreamObjects), build(namespaceObjects), build(nodeObjects), build(oAuthAccessTokenObjects), build(oAuthAuthorizeTokenObjects), build(oAuthClientAuthorizationObjects), build(oAuthClientObjects), build(persistentVolumeClaimObjects), build(persistentVolumeObjects), build(podObjects), build(policyBindingObjects), build(policyObjects), build(projectObjects), build(replicationControllerObjects), build(resourceQuotaObjects), build(roleBindingObjects), build(roleObjects), build(routeObjects), build(secretObjects), build(securityContextConstraintsObjects), build(serviceAccountObjects), build(serviceObjects), build(templateObjects), build(userObjects));
    }
    public T withObjects( List<HasMetadata> objects){
    this.objects.clear();if (objects != null) {for (HasMetadata item : objects){this.addToObjects(item);}} return (T) this;
    }
    public T withObjects( HasMetadata ...objects){
    this.objects.clear(); if (objects != null) {for (HasMetadata item :objects){ this.addToObjects(item);}} return (T) this;
    }
    public T addToPolicyObjects( Policy ...items){
    for (Policy item : items) {PolicyBuilder builder = new PolicyBuilder(item);_visitables.add(builder);this.policyObjects.add(builder);} return (T)this;
    }
    public T removeFromPolicyObjects( Policy ...items){
    for (Policy item : items) {PolicyBuilder builder = new PolicyBuilder(item);_visitables.remove(builder);this.policyObjects.remove(builder);} return (T)this;
    }
    public PolicyObjectsNested<T> addNewPolicyObject(){
    return new PolicyObjectsNestedImpl<T>();
    }
    public PolicyObjectsNested<T> addNewPolicyObjectLike( Policy item){
    return new PolicyObjectsNestedImpl<T>(item);
    }
    public T addToTemplateObjects( Template ...items){
    for (Template item : items) {TemplateBuilder builder = new TemplateBuilder(item);_visitables.add(builder);this.templateObjects.add(builder);} return (T)this;
    }
    public T removeFromTemplateObjects( Template ...items){
    for (Template item : items) {TemplateBuilder builder = new TemplateBuilder(item);_visitables.remove(builder);this.templateObjects.remove(builder);} return (T)this;
    }
    public TemplateObjectsNested<T> addNewTemplateObject(){
    return new TemplateObjectsNestedImpl<T>();
    }
    public TemplateObjectsNested<T> addNewTemplateObjectLike( Template item){
    return new TemplateObjectsNestedImpl<T>(item);
    }
    public T addToProjectObjects( Project ...items){
    for (Project item : items) {ProjectBuilder builder = new ProjectBuilder(item);_visitables.add(builder);this.projectObjects.add(builder);} return (T)this;
    }
    public T removeFromProjectObjects( Project ...items){
    for (Project item : items) {ProjectBuilder builder = new ProjectBuilder(item);_visitables.remove(builder);this.projectObjects.remove(builder);} return (T)this;
    }
    public ProjectObjectsNested<T> addNewProjectObject(){
    return new ProjectObjectsNestedImpl<T>();
    }
    public ProjectObjectsNested<T> addNewProjectObjectLike( Project item){
    return new ProjectObjectsNestedImpl<T>(item);
    }
    public T addToOAuthAuthorizeTokenObjects( OAuthAuthorizeToken ...items){
    for (OAuthAuthorizeToken item : items) {OAuthAuthorizeTokenBuilder builder = new OAuthAuthorizeTokenBuilder(item);_visitables.add(builder);this.oAuthAuthorizeTokenObjects.add(builder);} return (T)this;
    }
    public T removeFromOAuthAuthorizeTokenObjects( OAuthAuthorizeToken ...items){
    for (OAuthAuthorizeToken item : items) {OAuthAuthorizeTokenBuilder builder = new OAuthAuthorizeTokenBuilder(item);_visitables.remove(builder);this.oAuthAuthorizeTokenObjects.remove(builder);} return (T)this;
    }
    public OAuthAuthorizeTokenObjectsNested<T> addNewOAuthAuthorizeTokenObject(){
    return new OAuthAuthorizeTokenObjectsNestedImpl<T>();
    }
    public OAuthAuthorizeTokenObjectsNested<T> addNewOAuthAuthorizeTokenObjectLike( OAuthAuthorizeToken item){
    return new OAuthAuthorizeTokenObjectsNestedImpl<T>(item);
    }
    public T addToRoleBindingObjects( RoleBinding ...items){
    for (RoleBinding item : items) {RoleBindingBuilder builder = new RoleBindingBuilder(item);_visitables.add(builder);this.roleBindingObjects.add(builder);} return (T)this;
    }
    public T removeFromRoleBindingObjects( RoleBinding ...items){
    for (RoleBinding item : items) {RoleBindingBuilder builder = new RoleBindingBuilder(item);_visitables.remove(builder);this.roleBindingObjects.remove(builder);} return (T)this;
    }
    public RoleBindingObjectsNested<T> addNewRoleBindingObject(){
    return new RoleBindingObjectsNestedImpl<T>();
    }
    public RoleBindingObjectsNested<T> addNewRoleBindingObjectLike( RoleBinding item){
    return new RoleBindingObjectsNestedImpl<T>(item);
    }
    public T addToBuildConfigObjects( BuildConfig ...items){
    for (BuildConfig item : items) {BuildConfigBuilder builder = new BuildConfigBuilder(item);_visitables.add(builder);this.buildConfigObjects.add(builder);} return (T)this;
    }
    public T removeFromBuildConfigObjects( BuildConfig ...items){
    for (BuildConfig item : items) {BuildConfigBuilder builder = new BuildConfigBuilder(item);_visitables.remove(builder);this.buildConfigObjects.remove(builder);} return (T)this;
    }
    public BuildConfigObjectsNested<T> addNewBuildConfigObject(){
    return new BuildConfigObjectsNestedImpl<T>();
    }
    public BuildConfigObjectsNested<T> addNewBuildConfigObjectLike( BuildConfig item){
    return new BuildConfigObjectsNestedImpl<T>(item);
    }
    public T addToSecretObjects( Secret ...items){
    for (Secret item : items) {SecretBuilder builder = new SecretBuilder(item);_visitables.add(builder);this.secretObjects.add(builder);} return (T)this;
    }
    public T removeFromSecretObjects( Secret ...items){
    for (Secret item : items) {SecretBuilder builder = new SecretBuilder(item);_visitables.remove(builder);this.secretObjects.remove(builder);} return (T)this;
    }
    public SecretObjectsNested<T> addNewSecretObject(){
    return new SecretObjectsNestedImpl<T>();
    }
    public SecretObjectsNested<T> addNewSecretObjectLike( Secret item){
    return new SecretObjectsNestedImpl<T>(item);
    }
    public T addToReplicationControllerObjects( ReplicationController ...items){
    for (ReplicationController item : items) {ReplicationControllerBuilder builder = new ReplicationControllerBuilder(item);_visitables.add(builder);this.replicationControllerObjects.add(builder);} return (T)this;
    }
    public T removeFromReplicationControllerObjects( ReplicationController ...items){
    for (ReplicationController item : items) {ReplicationControllerBuilder builder = new ReplicationControllerBuilder(item);_visitables.remove(builder);this.replicationControllerObjects.remove(builder);} return (T)this;
    }
    public ReplicationControllerObjectsNested<T> addNewReplicationControllerObject(){
    return new ReplicationControllerObjectsNestedImpl<T>();
    }
    public ReplicationControllerObjectsNested<T> addNewReplicationControllerObjectLike( ReplicationController item){
    return new ReplicationControllerObjectsNestedImpl<T>(item);
    }
    public T addToUserObjects( User ...items){
    for (User item : items) {UserBuilder builder = new UserBuilder(item);_visitables.add(builder);this.userObjects.add(builder);} return (T)this;
    }
    public T removeFromUserObjects( User ...items){
    for (User item : items) {UserBuilder builder = new UserBuilder(item);_visitables.remove(builder);this.userObjects.remove(builder);} return (T)this;
    }
    public UserObjectsNested<T> addNewUserObject(){
    return new UserObjectsNestedImpl<T>();
    }
    public UserObjectsNested<T> addNewUserObjectLike( User item){
    return new UserObjectsNestedImpl<T>(item);
    }
    public T addToImageObjects( Image ...items){
    for (Image item : items) {ImageBuilder builder = new ImageBuilder(item);_visitables.add(builder);this.imageObjects.add(builder);} return (T)this;
    }
    public T removeFromImageObjects( Image ...items){
    for (Image item : items) {ImageBuilder builder = new ImageBuilder(item);_visitables.remove(builder);this.imageObjects.remove(builder);} return (T)this;
    }
    public ImageObjectsNested<T> addNewImageObject(){
    return new ImageObjectsNestedImpl<T>();
    }
    public ImageObjectsNested<T> addNewImageObjectLike( Image item){
    return new ImageObjectsNestedImpl<T>(item);
    }
    public T addToEndpointsObjects( Endpoints ...items){
    for (Endpoints item : items) {EndpointsBuilder builder = new EndpointsBuilder(item);_visitables.add(builder);this.endpointsObjects.add(builder);} return (T)this;
    }
    public T removeFromEndpointsObjects( Endpoints ...items){
    for (Endpoints item : items) {EndpointsBuilder builder = new EndpointsBuilder(item);_visitables.remove(builder);this.endpointsObjects.remove(builder);} return (T)this;
    }
    public EndpointsObjectsNested<T> addNewEndpointsObject(){
    return new EndpointsObjectsNestedImpl<T>();
    }
    public EndpointsObjectsNested<T> addNewEndpointsObjectLike( Endpoints item){
    return new EndpointsObjectsNestedImpl<T>(item);
    }
    public T addToClusterRoleObjects( ClusterRole ...items){
    for (ClusterRole item : items) {ClusterRoleBuilder builder = new ClusterRoleBuilder(item);_visitables.add(builder);this.clusterRoleObjects.add(builder);} return (T)this;
    }
    public T removeFromClusterRoleObjects( ClusterRole ...items){
    for (ClusterRole item : items) {ClusterRoleBuilder builder = new ClusterRoleBuilder(item);_visitables.remove(builder);this.clusterRoleObjects.remove(builder);} return (T)this;
    }
    public ClusterRoleObjectsNested<T> addNewClusterRoleObject(){
    return new ClusterRoleObjectsNestedImpl<T>();
    }
    public ClusterRoleObjectsNested<T> addNewClusterRoleObjectLike( ClusterRole item){
    return new ClusterRoleObjectsNestedImpl<T>(item);
    }
    public T addToRouteObjects( Route ...items){
    for (Route item : items) {RouteBuilder builder = new RouteBuilder(item);_visitables.add(builder);this.routeObjects.add(builder);} return (T)this;
    }
    public T removeFromRouteObjects( Route ...items){
    for (Route item : items) {RouteBuilder builder = new RouteBuilder(item);_visitables.remove(builder);this.routeObjects.remove(builder);} return (T)this;
    }
    public RouteObjectsNested<T> addNewRouteObject(){
    return new RouteObjectsNestedImpl<T>();
    }
    public RouteObjectsNested<T> addNewRouteObjectLike( Route item){
    return new RouteObjectsNestedImpl<T>(item);
    }
    public T addToRoleObjects( Role ...items){
    for (Role item : items) {RoleBuilder builder = new RoleBuilder(item);_visitables.add(builder);this.roleObjects.add(builder);} return (T)this;
    }
    public T removeFromRoleObjects( Role ...items){
    for (Role item : items) {RoleBuilder builder = new RoleBuilder(item);_visitables.remove(builder);this.roleObjects.remove(builder);} return (T)this;
    }
    public RoleObjectsNested<T> addNewRoleObject(){
    return new RoleObjectsNestedImpl<T>();
    }
    public RoleObjectsNested<T> addNewRoleObjectLike( Role item){
    return new RoleObjectsNestedImpl<T>(item);
    }
    public T addToSecurityContextConstraintsObjects( SecurityContextConstraints ...items){
    for (SecurityContextConstraints item : items) {SecurityContextConstraintsBuilder builder = new SecurityContextConstraintsBuilder(item);_visitables.add(builder);this.securityContextConstraintsObjects.add(builder);} return (T)this;
    }
    public T removeFromSecurityContextConstraintsObjects( SecurityContextConstraints ...items){
    for (SecurityContextConstraints item : items) {SecurityContextConstraintsBuilder builder = new SecurityContextConstraintsBuilder(item);_visitables.remove(builder);this.securityContextConstraintsObjects.remove(builder);} return (T)this;
    }
    public SecurityContextConstraintsObjectsNested<T> addNewSecurityContextConstraintsObject(){
    return new SecurityContextConstraintsObjectsNestedImpl<T>();
    }
    public SecurityContextConstraintsObjectsNested<T> addNewSecurityContextConstraintsObjectLike( SecurityContextConstraints item){
    return new SecurityContextConstraintsObjectsNestedImpl<T>(item);
    }
    public T addToNodeObjects( Node ...items){
    for (Node item : items) {NodeBuilder builder = new NodeBuilder(item);_visitables.add(builder);this.nodeObjects.add(builder);} return (T)this;
    }
    public T removeFromNodeObjects( Node ...items){
    for (Node item : items) {NodeBuilder builder = new NodeBuilder(item);_visitables.remove(builder);this.nodeObjects.remove(builder);} return (T)this;
    }
    public NodeObjectsNested<T> addNewNodeObject(){
    return new NodeObjectsNestedImpl<T>();
    }
    public NodeObjectsNested<T> addNewNodeObjectLike( Node item){
    return new NodeObjectsNestedImpl<T>(item);
    }
    public T addToOAuthClientAuthorizationObjects( OAuthClientAuthorization ...items){
    for (OAuthClientAuthorization item : items) {OAuthClientAuthorizationBuilder builder = new OAuthClientAuthorizationBuilder(item);_visitables.add(builder);this.oAuthClientAuthorizationObjects.add(builder);} return (T)this;
    }
    public T removeFromOAuthClientAuthorizationObjects( OAuthClientAuthorization ...items){
    for (OAuthClientAuthorization item : items) {OAuthClientAuthorizationBuilder builder = new OAuthClientAuthorizationBuilder(item);_visitables.remove(builder);this.oAuthClientAuthorizationObjects.remove(builder);} return (T)this;
    }
    public OAuthClientAuthorizationObjectsNested<T> addNewOAuthClientAuthorizationObject(){
    return new OAuthClientAuthorizationObjectsNestedImpl<T>();
    }
    public OAuthClientAuthorizationObjectsNested<T> addNewOAuthClientAuthorizationObjectLike( OAuthClientAuthorization item){
    return new OAuthClientAuthorizationObjectsNestedImpl<T>(item);
    }
    public T addToOAuthAccessTokenObjects( OAuthAccessToken ...items){
    for (OAuthAccessToken item : items) {OAuthAccessTokenBuilder builder = new OAuthAccessTokenBuilder(item);_visitables.add(builder);this.oAuthAccessTokenObjects.add(builder);} return (T)this;
    }
    public T removeFromOAuthAccessTokenObjects( OAuthAccessToken ...items){
    for (OAuthAccessToken item : items) {OAuthAccessTokenBuilder builder = new OAuthAccessTokenBuilder(item);_visitables.remove(builder);this.oAuthAccessTokenObjects.remove(builder);} return (T)this;
    }
    public OAuthAccessTokenObjectsNested<T> addNewOAuthAccessTokenObject(){
    return new OAuthAccessTokenObjectsNestedImpl<T>();
    }
    public OAuthAccessTokenObjectsNested<T> addNewOAuthAccessTokenObjectLike( OAuthAccessToken item){
    return new OAuthAccessTokenObjectsNestedImpl<T>(item);
    }
    public T addToServiceAccountObjects( ServiceAccount ...items){
    for (ServiceAccount item : items) {ServiceAccountBuilder builder = new ServiceAccountBuilder(item);_visitables.add(builder);this.serviceAccountObjects.add(builder);} return (T)this;
    }
    public T removeFromServiceAccountObjects( ServiceAccount ...items){
    for (ServiceAccount item : items) {ServiceAccountBuilder builder = new ServiceAccountBuilder(item);_visitables.remove(builder);this.serviceAccountObjects.remove(builder);} return (T)this;
    }
    public ServiceAccountObjectsNested<T> addNewServiceAccountObject(){
    return new ServiceAccountObjectsNestedImpl<T>();
    }
    public ServiceAccountObjectsNested<T> addNewServiceAccountObjectLike( ServiceAccount item){
    return new ServiceAccountObjectsNestedImpl<T>(item);
    }
    public T addToImageStreamObjects( ImageStream ...items){
    for (ImageStream item : items) {ImageStreamBuilder builder = new ImageStreamBuilder(item);_visitables.add(builder);this.imageStreamObjects.add(builder);} return (T)this;
    }
    public T removeFromImageStreamObjects( ImageStream ...items){
    for (ImageStream item : items) {ImageStreamBuilder builder = new ImageStreamBuilder(item);_visitables.remove(builder);this.imageStreamObjects.remove(builder);} return (T)this;
    }
    public ImageStreamObjectsNested<T> addNewImageStreamObject(){
    return new ImageStreamObjectsNestedImpl<T>();
    }
    public ImageStreamObjectsNested<T> addNewImageStreamObjectLike( ImageStream item){
    return new ImageStreamObjectsNestedImpl<T>(item);
    }
    public T addToBuildRequestObjects( BuildRequest ...items){
    for (BuildRequest item : items) {BuildRequestBuilder builder = new BuildRequestBuilder(item);_visitables.add(builder);this.buildRequestObjects.add(builder);} return (T)this;
    }
    public T removeFromBuildRequestObjects( BuildRequest ...items){
    for (BuildRequest item : items) {BuildRequestBuilder builder = new BuildRequestBuilder(item);_visitables.remove(builder);this.buildRequestObjects.remove(builder);} return (T)this;
    }
    public BuildRequestObjectsNested<T> addNewBuildRequestObject(){
    return new BuildRequestObjectsNestedImpl<T>();
    }
    public BuildRequestObjectsNested<T> addNewBuildRequestObjectLike( BuildRequest item){
    return new BuildRequestObjectsNestedImpl<T>(item);
    }
    public T addToServiceObjects( Service ...items){
    for (Service item : items) {ServiceBuilder builder = new ServiceBuilder(item);_visitables.add(builder);this.serviceObjects.add(builder);} return (T)this;
    }
    public T removeFromServiceObjects( Service ...items){
    for (Service item : items) {ServiceBuilder builder = new ServiceBuilder(item);_visitables.remove(builder);this.serviceObjects.remove(builder);} return (T)this;
    }
    public ServiceObjectsNested<T> addNewServiceObject(){
    return new ServiceObjectsNestedImpl<T>();
    }
    public ServiceObjectsNested<T> addNewServiceObjectLike( Service item){
    return new ServiceObjectsNestedImpl<T>(item);
    }
    public T addToBuildObjects( Build ...items){
    for (Build item : items) {BuildBuilder builder = new BuildBuilder(item);_visitables.add(builder);this.buildObjects.add(builder);} return (T)this;
    }
    public T removeFromBuildObjects( Build ...items){
    for (Build item : items) {BuildBuilder builder = new BuildBuilder(item);_visitables.remove(builder);this.buildObjects.remove(builder);} return (T)this;
    }
    public BuildObjectsNested<T> addNewBuildObject(){
    return new BuildObjectsNestedImpl<T>();
    }
    public BuildObjectsNested<T> addNewBuildObjectLike( Build item){
    return new BuildObjectsNestedImpl<T>(item);
    }
    public T addToDeploymentConfigObjects( DeploymentConfig ...items){
    for (DeploymentConfig item : items) {DeploymentConfigBuilder builder = new DeploymentConfigBuilder(item);_visitables.add(builder);this.deploymentConfigObjects.add(builder);} return (T)this;
    }
    public T removeFromDeploymentConfigObjects( DeploymentConfig ...items){
    for (DeploymentConfig item : items) {DeploymentConfigBuilder builder = new DeploymentConfigBuilder(item);_visitables.remove(builder);this.deploymentConfigObjects.remove(builder);} return (T)this;
    }
    public DeploymentConfigObjectsNested<T> addNewDeploymentConfigObject(){
    return new DeploymentConfigObjectsNestedImpl<T>();
    }
    public DeploymentConfigObjectsNested<T> addNewDeploymentConfigObjectLike( DeploymentConfig item){
    return new DeploymentConfigObjectsNestedImpl<T>(item);
    }
    public T addToClusterRoleBindingObjects( ClusterRoleBinding ...items){
    for (ClusterRoleBinding item : items) {ClusterRoleBindingBuilder builder = new ClusterRoleBindingBuilder(item);_visitables.add(builder);this.clusterRoleBindingObjects.add(builder);} return (T)this;
    }
    public T removeFromClusterRoleBindingObjects( ClusterRoleBinding ...items){
    for (ClusterRoleBinding item : items) {ClusterRoleBindingBuilder builder = new ClusterRoleBindingBuilder(item);_visitables.remove(builder);this.clusterRoleBindingObjects.remove(builder);} return (T)this;
    }
    public ClusterRoleBindingObjectsNested<T> addNewClusterRoleBindingObject(){
    return new ClusterRoleBindingObjectsNestedImpl<T>();
    }
    public ClusterRoleBindingObjectsNested<T> addNewClusterRoleBindingObjectLike( ClusterRoleBinding item){
    return new ClusterRoleBindingObjectsNestedImpl<T>(item);
    }
    public T addToGroupObjects( Group ...items){
    for (Group item : items) {GroupBuilder builder = new GroupBuilder(item);_visitables.add(builder);this.groupObjects.add(builder);} return (T)this;
    }
    public T removeFromGroupObjects( Group ...items){
    for (Group item : items) {GroupBuilder builder = new GroupBuilder(item);_visitables.remove(builder);this.groupObjects.remove(builder);} return (T)this;
    }
    public GroupObjectsNested<T> addNewGroupObject(){
    return new GroupObjectsNestedImpl<T>();
    }
    public GroupObjectsNested<T> addNewGroupObjectLike( Group item){
    return new GroupObjectsNestedImpl<T>(item);
    }
    public T addToPersistentVolumeClaimObjects( PersistentVolumeClaim ...items){
    for (PersistentVolumeClaim item : items) {PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.add(builder);this.persistentVolumeClaimObjects.add(builder);} return (T)this;
    }
    public T removeFromPersistentVolumeClaimObjects( PersistentVolumeClaim ...items){
    for (PersistentVolumeClaim item : items) {PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.remove(builder);this.persistentVolumeClaimObjects.remove(builder);} return (T)this;
    }
    public PersistentVolumeClaimObjectsNested<T> addNewPersistentVolumeClaimObject(){
    return new PersistentVolumeClaimObjectsNestedImpl<T>();
    }
    public PersistentVolumeClaimObjectsNested<T> addNewPersistentVolumeClaimObjectLike( PersistentVolumeClaim item){
    return new PersistentVolumeClaimObjectsNestedImpl<T>(item);
    }
    public T addToPodObjects( Pod ...items){
    for (Pod item : items) {PodBuilder builder = new PodBuilder(item);_visitables.add(builder);this.podObjects.add(builder);} return (T)this;
    }
    public T removeFromPodObjects( Pod ...items){
    for (Pod item : items) {PodBuilder builder = new PodBuilder(item);_visitables.remove(builder);this.podObjects.remove(builder);} return (T)this;
    }
    public PodObjectsNested<T> addNewPodObject(){
    return new PodObjectsNestedImpl<T>();
    }
    public PodObjectsNested<T> addNewPodObjectLike( Pod item){
    return new PodObjectsNestedImpl<T>(item);
    }
    public T addToPolicyBindingObjects( PolicyBinding ...items){
    for (PolicyBinding item : items) {PolicyBindingBuilder builder = new PolicyBindingBuilder(item);_visitables.add(builder);this.policyBindingObjects.add(builder);} return (T)this;
    }
    public T removeFromPolicyBindingObjects( PolicyBinding ...items){
    for (PolicyBinding item : items) {PolicyBindingBuilder builder = new PolicyBindingBuilder(item);_visitables.remove(builder);this.policyBindingObjects.remove(builder);} return (T)this;
    }
    public PolicyBindingObjectsNested<T> addNewPolicyBindingObject(){
    return new PolicyBindingObjectsNestedImpl<T>();
    }
    public PolicyBindingObjectsNested<T> addNewPolicyBindingObjectLike( PolicyBinding item){
    return new PolicyBindingObjectsNestedImpl<T>(item);
    }
    public T addToOAuthClientObjects( OAuthClient ...items){
    for (OAuthClient item : items) {OAuthClientBuilder builder = new OAuthClientBuilder(item);_visitables.add(builder);this.oAuthClientObjects.add(builder);} return (T)this;
    }
    public T removeFromOAuthClientObjects( OAuthClient ...items){
    for (OAuthClient item : items) {OAuthClientBuilder builder = new OAuthClientBuilder(item);_visitables.remove(builder);this.oAuthClientObjects.remove(builder);} return (T)this;
    }
    public OAuthClientObjectsNested<T> addNewOAuthClientObject(){
    return new OAuthClientObjectsNestedImpl<T>();
    }
    public OAuthClientObjectsNested<T> addNewOAuthClientObjectLike( OAuthClient item){
    return new OAuthClientObjectsNestedImpl<T>(item);
    }
    public T addToPersistentVolumeObjects( PersistentVolume ...items){
    for (PersistentVolume item : items) {PersistentVolumeBuilder builder = new PersistentVolumeBuilder(item);_visitables.add(builder);this.persistentVolumeObjects.add(builder);} return (T)this;
    }
    public T removeFromPersistentVolumeObjects( PersistentVolume ...items){
    for (PersistentVolume item : items) {PersistentVolumeBuilder builder = new PersistentVolumeBuilder(item);_visitables.remove(builder);this.persistentVolumeObjects.remove(builder);} return (T)this;
    }
    public PersistentVolumeObjectsNested<T> addNewPersistentVolumeObject(){
    return new PersistentVolumeObjectsNestedImpl<T>();
    }
    public PersistentVolumeObjectsNested<T> addNewPersistentVolumeObjectLike( PersistentVolume item){
    return new PersistentVolumeObjectsNestedImpl<T>(item);
    }
    public T addToEventObjects( Event ...items){
    for (Event item : items) {EventBuilder builder = new EventBuilder(item);_visitables.add(builder);this.eventObjects.add(builder);} return (T)this;
    }
    public T removeFromEventObjects( Event ...items){
    for (Event item : items) {EventBuilder builder = new EventBuilder(item);_visitables.remove(builder);this.eventObjects.remove(builder);} return (T)this;
    }
    public EventObjectsNested<T> addNewEventObject(){
    return new EventObjectsNestedImpl<T>();
    }
    public EventObjectsNested<T> addNewEventObjectLike( Event item){
    return new EventObjectsNestedImpl<T>(item);
    }
    public T addToResourceQuotaObjects( ResourceQuota ...items){
    for (ResourceQuota item : items) {ResourceQuotaBuilder builder = new ResourceQuotaBuilder(item);_visitables.add(builder);this.resourceQuotaObjects.add(builder);} return (T)this;
    }
    public T removeFromResourceQuotaObjects( ResourceQuota ...items){
    for (ResourceQuota item : items) {ResourceQuotaBuilder builder = new ResourceQuotaBuilder(item);_visitables.remove(builder);this.resourceQuotaObjects.remove(builder);} return (T)this;
    }
    public ResourceQuotaObjectsNested<T> addNewResourceQuotaObject(){
    return new ResourceQuotaObjectsNestedImpl<T>();
    }
    public ResourceQuotaObjectsNested<T> addNewResourceQuotaObjectLike( ResourceQuota item){
    return new ResourceQuotaObjectsNestedImpl<T>(item);
    }
    public T addToClusterPolicyObjects( ClusterPolicy ...items){
    for (ClusterPolicy item : items) {ClusterPolicyBuilder builder = new ClusterPolicyBuilder(item);_visitables.add(builder);this.clusterPolicyObjects.add(builder);} return (T)this;
    }
    public T removeFromClusterPolicyObjects( ClusterPolicy ...items){
    for (ClusterPolicy item : items) {ClusterPolicyBuilder builder = new ClusterPolicyBuilder(item);_visitables.remove(builder);this.clusterPolicyObjects.remove(builder);} return (T)this;
    }
    public ClusterPolicyObjectsNested<T> addNewClusterPolicyObject(){
    return new ClusterPolicyObjectsNestedImpl<T>();
    }
    public ClusterPolicyObjectsNested<T> addNewClusterPolicyObjectLike( ClusterPolicy item){
    return new ClusterPolicyObjectsNestedImpl<T>(item);
    }
    public T addToClusterPolicyBindingObjects( ClusterPolicyBinding ...items){
    for (ClusterPolicyBinding item : items) {ClusterPolicyBindingBuilder builder = new ClusterPolicyBindingBuilder(item);_visitables.add(builder);this.clusterPolicyBindingObjects.add(builder);} return (T)this;
    }
    public T removeFromClusterPolicyBindingObjects( ClusterPolicyBinding ...items){
    for (ClusterPolicyBinding item : items) {ClusterPolicyBindingBuilder builder = new ClusterPolicyBindingBuilder(item);_visitables.remove(builder);this.clusterPolicyBindingObjects.remove(builder);} return (T)this;
    }
    public ClusterPolicyBindingObjectsNested<T> addNewClusterPolicyBindingObject(){
    return new ClusterPolicyBindingObjectsNestedImpl<T>();
    }
    public ClusterPolicyBindingObjectsNested<T> addNewClusterPolicyBindingObjectLike( ClusterPolicyBinding item){
    return new ClusterPolicyBindingObjectsNestedImpl<T>(item);
    }
    public T addToNamespaceObjects( Namespace ...items){
    for (Namespace item : items) {NamespaceBuilder builder = new NamespaceBuilder(item);_visitables.add(builder);this.namespaceObjects.add(builder);} return (T)this;
    }
    public T removeFromNamespaceObjects( Namespace ...items){
    for (Namespace item : items) {NamespaceBuilder builder = new NamespaceBuilder(item);_visitables.remove(builder);this.namespaceObjects.remove(builder);} return (T)this;
    }
    public NamespaceObjectsNested<T> addNewNamespaceObject(){
    return new NamespaceObjectsNestedImpl<T>();
    }
    public NamespaceObjectsNested<T> addNewNamespaceObjectLike( Namespace item){
    return new NamespaceObjectsNestedImpl<T>(item);
    }
    public T addToIdentityObjects( Identity ...items){
    for (Identity item : items) {IdentityBuilder builder = new IdentityBuilder(item);_visitables.add(builder);this.identityObjects.add(builder);} return (T)this;
    }
    public T removeFromIdentityObjects( Identity ...items){
    for (Identity item : items) {IdentityBuilder builder = new IdentityBuilder(item);_visitables.remove(builder);this.identityObjects.remove(builder);} return (T)this;
    }
    public IdentityObjectsNested<T> addNewIdentityObject(){
    return new IdentityObjectsNestedImpl<T>();
    }
    public IdentityObjectsNested<T> addNewIdentityObjectLike( Identity item){
    return new IdentityObjectsNestedImpl<T>(item);
    }
    public T addToParameters( Parameter ...items){
    for (Parameter item : items) {ParameterBuilder builder = new ParameterBuilder(item);_visitables.add(builder);this.parameters.add(builder);} return (T)this;
    }
    public T removeFromParameters( Parameter ...items){
    for (Parameter item : items) {ParameterBuilder builder = new ParameterBuilder(item);_visitables.remove(builder);this.parameters.remove(builder);} return (T)this;
    }
    public List<Parameter> getParameters(){
    return build(parameters);
    }
    public T withParameters( List<Parameter> parameters){
    this.parameters.clear();if (parameters != null) {for (Parameter item : parameters){this.addToParameters(item);}} return (T) this;
    }
    public T withParameters( Parameter ...parameters){
    this.parameters.clear(); if (parameters != null) {for (Parameter item :parameters){ this.addToParameters(item);}} return (T) this;
    }
    public ParametersNested<T> addNewParameter(){
    return new ParametersNestedImpl<T>();
    }
    public ParametersNested<T> addNewParameterLike( Parameter item){
    return new ParametersNestedImpl<T>(item);
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
TemplateFluentImpl that = (TemplateFluentImpl) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (labels != null ? !labels.equals(that.labels) :that.labels != null) return false;
if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
if (objects != null ? !objects.equals(that.objects) :that.objects != null) return false;
if (policyObjects != null ? !policyObjects.equals(that.policyObjects) :that.policyObjects != null) return false;
if (templateObjects != null ? !templateObjects.equals(that.templateObjects) :that.templateObjects != null) return false;
if (projectObjects != null ? !projectObjects.equals(that.projectObjects) :that.projectObjects != null) return false;
if (oAuthAuthorizeTokenObjects != null ? !oAuthAuthorizeTokenObjects.equals(that.oAuthAuthorizeTokenObjects) :that.oAuthAuthorizeTokenObjects != null) return false;
if (roleBindingObjects != null ? !roleBindingObjects.equals(that.roleBindingObjects) :that.roleBindingObjects != null) return false;
if (buildConfigObjects != null ? !buildConfigObjects.equals(that.buildConfigObjects) :that.buildConfigObjects != null) return false;
if (secretObjects != null ? !secretObjects.equals(that.secretObjects) :that.secretObjects != null) return false;
if (replicationControllerObjects != null ? !replicationControllerObjects.equals(that.replicationControllerObjects) :that.replicationControllerObjects != null) return false;
if (userObjects != null ? !userObjects.equals(that.userObjects) :that.userObjects != null) return false;
if (imageObjects != null ? !imageObjects.equals(that.imageObjects) :that.imageObjects != null) return false;
if (endpointsObjects != null ? !endpointsObjects.equals(that.endpointsObjects) :that.endpointsObjects != null) return false;
if (clusterRoleObjects != null ? !clusterRoleObjects.equals(that.clusterRoleObjects) :that.clusterRoleObjects != null) return false;
if (routeObjects != null ? !routeObjects.equals(that.routeObjects) :that.routeObjects != null) return false;
if (roleObjects != null ? !roleObjects.equals(that.roleObjects) :that.roleObjects != null) return false;
if (securityContextConstraintsObjects != null ? !securityContextConstraintsObjects.equals(that.securityContextConstraintsObjects) :that.securityContextConstraintsObjects != null) return false;
if (nodeObjects != null ? !nodeObjects.equals(that.nodeObjects) :that.nodeObjects != null) return false;
if (oAuthClientAuthorizationObjects != null ? !oAuthClientAuthorizationObjects.equals(that.oAuthClientAuthorizationObjects) :that.oAuthClientAuthorizationObjects != null) return false;
if (oAuthAccessTokenObjects != null ? !oAuthAccessTokenObjects.equals(that.oAuthAccessTokenObjects) :that.oAuthAccessTokenObjects != null) return false;
if (serviceAccountObjects != null ? !serviceAccountObjects.equals(that.serviceAccountObjects) :that.serviceAccountObjects != null) return false;
if (imageStreamObjects != null ? !imageStreamObjects.equals(that.imageStreamObjects) :that.imageStreamObjects != null) return false;
if (buildRequestObjects != null ? !buildRequestObjects.equals(that.buildRequestObjects) :that.buildRequestObjects != null) return false;
if (serviceObjects != null ? !serviceObjects.equals(that.serviceObjects) :that.serviceObjects != null) return false;
if (buildObjects != null ? !buildObjects.equals(that.buildObjects) :that.buildObjects != null) return false;
if (deploymentConfigObjects != null ? !deploymentConfigObjects.equals(that.deploymentConfigObjects) :that.deploymentConfigObjects != null) return false;
if (clusterRoleBindingObjects != null ? !clusterRoleBindingObjects.equals(that.clusterRoleBindingObjects) :that.clusterRoleBindingObjects != null) return false;
if (groupObjects != null ? !groupObjects.equals(that.groupObjects) :that.groupObjects != null) return false;
if (persistentVolumeClaimObjects != null ? !persistentVolumeClaimObjects.equals(that.persistentVolumeClaimObjects) :that.persistentVolumeClaimObjects != null) return false;
if (podObjects != null ? !podObjects.equals(that.podObjects) :that.podObjects != null) return false;
if (policyBindingObjects != null ? !policyBindingObjects.equals(that.policyBindingObjects) :that.policyBindingObjects != null) return false;
if (oAuthClientObjects != null ? !oAuthClientObjects.equals(that.oAuthClientObjects) :that.oAuthClientObjects != null) return false;
if (persistentVolumeObjects != null ? !persistentVolumeObjects.equals(that.persistentVolumeObjects) :that.persistentVolumeObjects != null) return false;
if (eventObjects != null ? !eventObjects.equals(that.eventObjects) :that.eventObjects != null) return false;
if (resourceQuotaObjects != null ? !resourceQuotaObjects.equals(that.resourceQuotaObjects) :that.resourceQuotaObjects != null) return false;
if (clusterPolicyObjects != null ? !clusterPolicyObjects.equals(that.clusterPolicyObjects) :that.clusterPolicyObjects != null) return false;
if (clusterPolicyBindingObjects != null ? !clusterPolicyBindingObjects.equals(that.clusterPolicyBindingObjects) :that.clusterPolicyBindingObjects != null) return false;
if (namespaceObjects != null ? !namespaceObjects.equals(that.namespaceObjects) :that.namespaceObjects != null) return false;
if (identityObjects != null ? !identityObjects.equals(that.identityObjects) :that.identityObjects != null) return false;
if (parameters != null ? !parameters.equals(that.parameters) :that.parameters != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<MetadataNested<N>> implements MetadataNested<N>{

        private final ObjectMetaBuilder builder;
    
             MetadataNestedImpl (){
        this.builder = new ObjectMetaBuilder(this);
        }
             MetadataNestedImpl ( ObjectMeta item){
        this.builder = new ObjectMetaBuilder(this, item);
        }
    
            public N and(){
            return (N) TemplateFluentImpl.this.withMetadata(builder.build());
        }
            public N endMetadata(){
            return and();
        }
    
}
    public class PolicyObjectsNestedImpl<N> extends PolicyFluentImpl<PolicyObjectsNested<N>> implements PolicyObjectsNested<N>{

        private final PolicyBuilder builder;
    
             PolicyObjectsNestedImpl (){
        this.builder = new PolicyBuilder(this);
        }
             PolicyObjectsNestedImpl ( Policy item){
        this.builder = new PolicyBuilder(this, item);
        }
    
            public N and(){
            return (N) TemplateFluentImpl.this.addToPolicyObjects(builder.build());
        }
            public N endPolicyObject(){
            return and();
        }
    
}
    public class TemplateObjectsNestedImpl<N> extends TemplateFluentImpl<TemplateObjectsNested<N>> implements TemplateObjectsNested<N>{

        private final TemplateBuilder builder;
    
             TemplateObjectsNestedImpl ( Template item){
        this.builder = new TemplateBuilder(this, item);
        }
             TemplateObjectsNestedImpl (){
        this.builder = new TemplateBuilder(this);
        }
    
            public N endTemplateObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluentImpl.this.addToTemplateObjects(builder.build());
        }
    
}
    public class ProjectObjectsNestedImpl<N> extends ProjectFluentImpl<ProjectObjectsNested<N>> implements ProjectObjectsNested<N>{

        private final ProjectBuilder builder;
    
             ProjectObjectsNestedImpl ( Project item){
        this.builder = new ProjectBuilder(this, item);
        }
             ProjectObjectsNestedImpl (){
        this.builder = new ProjectBuilder(this);
        }
    
            public N and(){
            return (N) TemplateFluentImpl.this.addToProjectObjects(builder.build());
        }
            public N endProjectObject(){
            return and();
        }
    
}
    public class OAuthAuthorizeTokenObjectsNestedImpl<N> extends OAuthAuthorizeTokenFluentImpl<OAuthAuthorizeTokenObjectsNested<N>> implements OAuthAuthorizeTokenObjectsNested<N>{

        private final OAuthAuthorizeTokenBuilder builder;
    
             OAuthAuthorizeTokenObjectsNestedImpl (){
        this.builder = new OAuthAuthorizeTokenBuilder(this);
        }
             OAuthAuthorizeTokenObjectsNestedImpl ( OAuthAuthorizeToken item){
        this.builder = new OAuthAuthorizeTokenBuilder(this, item);
        }
    
            public N and(){
            return (N) TemplateFluentImpl.this.addToOAuthAuthorizeTokenObjects(builder.build());
        }
            public N endOAuthAuthorizeTokenObject(){
            return and();
        }
    
}
    public class RoleBindingObjectsNestedImpl<N> extends RoleBindingFluentImpl<RoleBindingObjectsNested<N>> implements RoleBindingObjectsNested<N>{

        private final RoleBindingBuilder builder;
    
             RoleBindingObjectsNestedImpl (){
        this.builder = new RoleBindingBuilder(this);
        }
             RoleBindingObjectsNestedImpl ( RoleBinding item){
        this.builder = new RoleBindingBuilder(this, item);
        }
    
            public N and(){
            return (N) TemplateFluentImpl.this.addToRoleBindingObjects(builder.build());
        }
            public N endRoleBindingObject(){
            return and();
        }
    
}
    public class BuildConfigObjectsNestedImpl<N> extends BuildConfigFluentImpl<BuildConfigObjectsNested<N>> implements BuildConfigObjectsNested<N>{

        private final BuildConfigBuilder builder;
    
             BuildConfigObjectsNestedImpl (){
        this.builder = new BuildConfigBuilder(this);
        }
             BuildConfigObjectsNestedImpl ( BuildConfig item){
        this.builder = new BuildConfigBuilder(this, item);
        }
    
            public N and(){
            return (N) TemplateFluentImpl.this.addToBuildConfigObjects(builder.build());
        }
            public N endBuildConfigObject(){
            return and();
        }
    
}
    public class SecretObjectsNestedImpl<N> extends SecretFluentImpl<SecretObjectsNested<N>> implements SecretObjectsNested<N>{

        private final SecretBuilder builder;
    
             SecretObjectsNestedImpl (){
        this.builder = new SecretBuilder(this);
        }
             SecretObjectsNestedImpl ( Secret item){
        this.builder = new SecretBuilder(this, item);
        }
    
            public N endSecretObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluentImpl.this.addToSecretObjects(builder.build());
        }
    
}
    public class ReplicationControllerObjectsNestedImpl<N> extends ReplicationControllerFluentImpl<ReplicationControllerObjectsNested<N>> implements ReplicationControllerObjectsNested<N>{

        private final ReplicationControllerBuilder builder;
    
             ReplicationControllerObjectsNestedImpl (){
        this.builder = new ReplicationControllerBuilder(this);
        }
             ReplicationControllerObjectsNestedImpl ( ReplicationController item){
        this.builder = new ReplicationControllerBuilder(this, item);
        }
    
            public N endReplicationControllerObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluentImpl.this.addToReplicationControllerObjects(builder.build());
        }
    
}
    public class UserObjectsNestedImpl<N> extends UserFluentImpl<UserObjectsNested<N>> implements UserObjectsNested<N>{

        private final UserBuilder builder;
    
             UserObjectsNestedImpl (){
        this.builder = new UserBuilder(this);
        }
             UserObjectsNestedImpl ( User item){
        this.builder = new UserBuilder(this, item);
        }
    
            public N and(){
            return (N) TemplateFluentImpl.this.addToUserObjects(builder.build());
        }
            public N endUserObject(){
            return and();
        }
    
}
    public class ImageObjectsNestedImpl<N> extends ImageFluentImpl<ImageObjectsNested<N>> implements ImageObjectsNested<N>{

        private final ImageBuilder builder;
    
             ImageObjectsNestedImpl (){
        this.builder = new ImageBuilder(this);
        }
             ImageObjectsNestedImpl ( Image item){
        this.builder = new ImageBuilder(this, item);
        }
    
            public N endImageObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluentImpl.this.addToImageObjects(builder.build());
        }
    
}
    public class EndpointsObjectsNestedImpl<N> extends EndpointsFluentImpl<EndpointsObjectsNested<N>> implements EndpointsObjectsNested<N>{

        private final EndpointsBuilder builder;
    
             EndpointsObjectsNestedImpl (){
        this.builder = new EndpointsBuilder(this);
        }
             EndpointsObjectsNestedImpl ( Endpoints item){
        this.builder = new EndpointsBuilder(this, item);
        }
    
            public N and(){
            return (N) TemplateFluentImpl.this.addToEndpointsObjects(builder.build());
        }
            public N endEndpointsObject(){
            return and();
        }
    
}
    public class ClusterRoleObjectsNestedImpl<N> extends ClusterRoleFluentImpl<ClusterRoleObjectsNested<N>> implements ClusterRoleObjectsNested<N>{

        private final ClusterRoleBuilder builder;
    
             ClusterRoleObjectsNestedImpl (){
        this.builder = new ClusterRoleBuilder(this);
        }
             ClusterRoleObjectsNestedImpl ( ClusterRole item){
        this.builder = new ClusterRoleBuilder(this, item);
        }
    
            public N endClusterRoleObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluentImpl.this.addToClusterRoleObjects(builder.build());
        }
    
}
    public class RouteObjectsNestedImpl<N> extends RouteFluentImpl<RouteObjectsNested<N>> implements RouteObjectsNested<N>{

        private final RouteBuilder builder;
    
             RouteObjectsNestedImpl (){
        this.builder = new RouteBuilder(this);
        }
             RouteObjectsNestedImpl ( Route item){
        this.builder = new RouteBuilder(this, item);
        }
    
            public N endRouteObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluentImpl.this.addToRouteObjects(builder.build());
        }
    
}
    public class RoleObjectsNestedImpl<N> extends RoleFluentImpl<RoleObjectsNested<N>> implements RoleObjectsNested<N>{

        private final RoleBuilder builder;
    
             RoleObjectsNestedImpl (){
        this.builder = new RoleBuilder(this);
        }
             RoleObjectsNestedImpl ( Role item){
        this.builder = new RoleBuilder(this, item);
        }
    
            public N and(){
            return (N) TemplateFluentImpl.this.addToRoleObjects(builder.build());
        }
            public N endRoleObject(){
            return and();
        }
    
}
    public class SecurityContextConstraintsObjectsNestedImpl<N> extends SecurityContextConstraintsFluentImpl<SecurityContextConstraintsObjectsNested<N>> implements SecurityContextConstraintsObjectsNested<N>{

        private final SecurityContextConstraintsBuilder builder;
    
             SecurityContextConstraintsObjectsNestedImpl (){
        this.builder = new SecurityContextConstraintsBuilder(this);
        }
             SecurityContextConstraintsObjectsNestedImpl ( SecurityContextConstraints item){
        this.builder = new SecurityContextConstraintsBuilder(this, item);
        }
    
            public N and(){
            return (N) TemplateFluentImpl.this.addToSecurityContextConstraintsObjects(builder.build());
        }
            public N endSecurityContextConstraintsObject(){
            return and();
        }
    
}
    public class NodeObjectsNestedImpl<N> extends NodeFluentImpl<NodeObjectsNested<N>> implements NodeObjectsNested<N>{

        private final NodeBuilder builder;
    
             NodeObjectsNestedImpl ( Node item){
        this.builder = new NodeBuilder(this, item);
        }
             NodeObjectsNestedImpl (){
        this.builder = new NodeBuilder(this);
        }
    
            public N endNodeObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluentImpl.this.addToNodeObjects(builder.build());
        }
    
}
    public class OAuthClientAuthorizationObjectsNestedImpl<N> extends OAuthClientAuthorizationFluentImpl<OAuthClientAuthorizationObjectsNested<N>> implements OAuthClientAuthorizationObjectsNested<N>{

        private final OAuthClientAuthorizationBuilder builder;
    
             OAuthClientAuthorizationObjectsNestedImpl (){
        this.builder = new OAuthClientAuthorizationBuilder(this);
        }
             OAuthClientAuthorizationObjectsNestedImpl ( OAuthClientAuthorization item){
        this.builder = new OAuthClientAuthorizationBuilder(this, item);
        }
    
            public N endOAuthClientAuthorizationObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluentImpl.this.addToOAuthClientAuthorizationObjects(builder.build());
        }
    
}
    public class OAuthAccessTokenObjectsNestedImpl<N> extends OAuthAccessTokenFluentImpl<OAuthAccessTokenObjectsNested<N>> implements OAuthAccessTokenObjectsNested<N>{

        private final OAuthAccessTokenBuilder builder;
    
             OAuthAccessTokenObjectsNestedImpl (){
        this.builder = new OAuthAccessTokenBuilder(this);
        }
             OAuthAccessTokenObjectsNestedImpl ( OAuthAccessToken item){
        this.builder = new OAuthAccessTokenBuilder(this, item);
        }
    
            public N endOAuthAccessTokenObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluentImpl.this.addToOAuthAccessTokenObjects(builder.build());
        }
    
}
    public class ServiceAccountObjectsNestedImpl<N> extends ServiceAccountFluentImpl<ServiceAccountObjectsNested<N>> implements ServiceAccountObjectsNested<N>{

        private final ServiceAccountBuilder builder;
    
             ServiceAccountObjectsNestedImpl (){
        this.builder = new ServiceAccountBuilder(this);
        }
             ServiceAccountObjectsNestedImpl ( ServiceAccount item){
        this.builder = new ServiceAccountBuilder(this, item);
        }
    
            public N and(){
            return (N) TemplateFluentImpl.this.addToServiceAccountObjects(builder.build());
        }
            public N endServiceAccountObject(){
            return and();
        }
    
}
    public class ImageStreamObjectsNestedImpl<N> extends ImageStreamFluentImpl<ImageStreamObjectsNested<N>> implements ImageStreamObjectsNested<N>{

        private final ImageStreamBuilder builder;
    
             ImageStreamObjectsNestedImpl (){
        this.builder = new ImageStreamBuilder(this);
        }
             ImageStreamObjectsNestedImpl ( ImageStream item){
        this.builder = new ImageStreamBuilder(this, item);
        }
    
            public N endImageStreamObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluentImpl.this.addToImageStreamObjects(builder.build());
        }
    
}
    public class BuildRequestObjectsNestedImpl<N> extends BuildRequestFluentImpl<BuildRequestObjectsNested<N>> implements BuildRequestObjectsNested<N>{

        private final BuildRequestBuilder builder;
    
             BuildRequestObjectsNestedImpl (){
        this.builder = new BuildRequestBuilder(this);
        }
             BuildRequestObjectsNestedImpl ( BuildRequest item){
        this.builder = new BuildRequestBuilder(this, item);
        }
    
            public N endBuildRequestObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluentImpl.this.addToBuildRequestObjects(builder.build());
        }
    
}
    public class ServiceObjectsNestedImpl<N> extends ServiceFluentImpl<ServiceObjectsNested<N>> implements ServiceObjectsNested<N>{

        private final ServiceBuilder builder;
    
             ServiceObjectsNestedImpl (){
        this.builder = new ServiceBuilder(this);
        }
             ServiceObjectsNestedImpl ( Service item){
        this.builder = new ServiceBuilder(this, item);
        }
    
            public N and(){
            return (N) TemplateFluentImpl.this.addToServiceObjects(builder.build());
        }
            public N endServiceObject(){
            return and();
        }
    
}
    public class BuildObjectsNestedImpl<N> extends BuildFluentImpl<BuildObjectsNested<N>> implements BuildObjectsNested<N>{

        private final BuildBuilder builder;
    
             BuildObjectsNestedImpl (){
        this.builder = new BuildBuilder(this);
        }
             BuildObjectsNestedImpl ( Build item){
        this.builder = new BuildBuilder(this, item);
        }
    
            public N endBuildObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluentImpl.this.addToBuildObjects(builder.build());
        }
    
}
    public class DeploymentConfigObjectsNestedImpl<N> extends DeploymentConfigFluentImpl<DeploymentConfigObjectsNested<N>> implements DeploymentConfigObjectsNested<N>{

        private final DeploymentConfigBuilder builder;
    
             DeploymentConfigObjectsNestedImpl (){
        this.builder = new DeploymentConfigBuilder(this);
        }
             DeploymentConfigObjectsNestedImpl ( DeploymentConfig item){
        this.builder = new DeploymentConfigBuilder(this, item);
        }
    
            public N and(){
            return (N) TemplateFluentImpl.this.addToDeploymentConfigObjects(builder.build());
        }
            public N endDeploymentConfigObject(){
            return and();
        }
    
}
    public class ClusterRoleBindingObjectsNestedImpl<N> extends ClusterRoleBindingFluentImpl<ClusterRoleBindingObjectsNested<N>> implements ClusterRoleBindingObjectsNested<N>{

        private final ClusterRoleBindingBuilder builder;
    
             ClusterRoleBindingObjectsNestedImpl (){
        this.builder = new ClusterRoleBindingBuilder(this);
        }
             ClusterRoleBindingObjectsNestedImpl ( ClusterRoleBinding item){
        this.builder = new ClusterRoleBindingBuilder(this, item);
        }
    
            public N endClusterRoleBindingObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluentImpl.this.addToClusterRoleBindingObjects(builder.build());
        }
    
}
    public class GroupObjectsNestedImpl<N> extends GroupFluentImpl<GroupObjectsNested<N>> implements GroupObjectsNested<N>{

        private final GroupBuilder builder;
    
             GroupObjectsNestedImpl (){
        this.builder = new GroupBuilder(this);
        }
             GroupObjectsNestedImpl ( Group item){
        this.builder = new GroupBuilder(this, item);
        }
    
            public N and(){
            return (N) TemplateFluentImpl.this.addToGroupObjects(builder.build());
        }
            public N endGroupObject(){
            return and();
        }
    
}
    public class PersistentVolumeClaimObjectsNestedImpl<N> extends PersistentVolumeClaimFluentImpl<PersistentVolumeClaimObjectsNested<N>> implements PersistentVolumeClaimObjectsNested<N>{

        private final PersistentVolumeClaimBuilder builder;
    
             PersistentVolumeClaimObjectsNestedImpl (){
        this.builder = new PersistentVolumeClaimBuilder(this);
        }
             PersistentVolumeClaimObjectsNestedImpl ( PersistentVolumeClaim item){
        this.builder = new PersistentVolumeClaimBuilder(this, item);
        }
    
            public N endPersistentVolumeClaimObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluentImpl.this.addToPersistentVolumeClaimObjects(builder.build());
        }
    
}
    public class PodObjectsNestedImpl<N> extends PodFluentImpl<PodObjectsNested<N>> implements PodObjectsNested<N>{

        private final PodBuilder builder;
    
             PodObjectsNestedImpl ( Pod item){
        this.builder = new PodBuilder(this, item);
        }
             PodObjectsNestedImpl (){
        this.builder = new PodBuilder(this);
        }
    
            public N endPodObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluentImpl.this.addToPodObjects(builder.build());
        }
    
}
    public class PolicyBindingObjectsNestedImpl<N> extends PolicyBindingFluentImpl<PolicyBindingObjectsNested<N>> implements PolicyBindingObjectsNested<N>{

        private final PolicyBindingBuilder builder;
    
             PolicyBindingObjectsNestedImpl (){
        this.builder = new PolicyBindingBuilder(this);
        }
             PolicyBindingObjectsNestedImpl ( PolicyBinding item){
        this.builder = new PolicyBindingBuilder(this, item);
        }
    
            public N and(){
            return (N) TemplateFluentImpl.this.addToPolicyBindingObjects(builder.build());
        }
            public N endPolicyBindingObject(){
            return and();
        }
    
}
    public class OAuthClientObjectsNestedImpl<N> extends OAuthClientFluentImpl<OAuthClientObjectsNested<N>> implements OAuthClientObjectsNested<N>{

        private final OAuthClientBuilder builder;
    
             OAuthClientObjectsNestedImpl (){
        this.builder = new OAuthClientBuilder(this);
        }
             OAuthClientObjectsNestedImpl ( OAuthClient item){
        this.builder = new OAuthClientBuilder(this, item);
        }
    
            public N and(){
            return (N) TemplateFluentImpl.this.addToOAuthClientObjects(builder.build());
        }
            public N endOAuthClientObject(){
            return and();
        }
    
}
    public class PersistentVolumeObjectsNestedImpl<N> extends PersistentVolumeFluentImpl<PersistentVolumeObjectsNested<N>> implements PersistentVolumeObjectsNested<N>{

        private final PersistentVolumeBuilder builder;
    
             PersistentVolumeObjectsNestedImpl (){
        this.builder = new PersistentVolumeBuilder(this);
        }
             PersistentVolumeObjectsNestedImpl ( PersistentVolume item){
        this.builder = new PersistentVolumeBuilder(this, item);
        }
    
            public N and(){
            return (N) TemplateFluentImpl.this.addToPersistentVolumeObjects(builder.build());
        }
            public N endPersistentVolumeObject(){
            return and();
        }
    
}
    public class EventObjectsNestedImpl<N> extends EventFluentImpl<EventObjectsNested<N>> implements EventObjectsNested<N>{

        private final EventBuilder builder;
    
             EventObjectsNestedImpl (){
        this.builder = new EventBuilder(this);
        }
             EventObjectsNestedImpl ( Event item){
        this.builder = new EventBuilder(this, item);
        }
    
            public N and(){
            return (N) TemplateFluentImpl.this.addToEventObjects(builder.build());
        }
            public N endEventObject(){
            return and();
        }
    
}
    public class ResourceQuotaObjectsNestedImpl<N> extends ResourceQuotaFluentImpl<ResourceQuotaObjectsNested<N>> implements ResourceQuotaObjectsNested<N>{

        private final ResourceQuotaBuilder builder;
    
             ResourceQuotaObjectsNestedImpl (){
        this.builder = new ResourceQuotaBuilder(this);
        }
             ResourceQuotaObjectsNestedImpl ( ResourceQuota item){
        this.builder = new ResourceQuotaBuilder(this, item);
        }
    
            public N endResourceQuotaObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluentImpl.this.addToResourceQuotaObjects(builder.build());
        }
    
}
    public class ClusterPolicyObjectsNestedImpl<N> extends ClusterPolicyFluentImpl<ClusterPolicyObjectsNested<N>> implements ClusterPolicyObjectsNested<N>{

        private final ClusterPolicyBuilder builder;
    
             ClusterPolicyObjectsNestedImpl (){
        this.builder = new ClusterPolicyBuilder(this);
        }
             ClusterPolicyObjectsNestedImpl ( ClusterPolicy item){
        this.builder = new ClusterPolicyBuilder(this, item);
        }
    
            public N endClusterPolicyObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluentImpl.this.addToClusterPolicyObjects(builder.build());
        }
    
}
    public class ClusterPolicyBindingObjectsNestedImpl<N> extends ClusterPolicyBindingFluentImpl<ClusterPolicyBindingObjectsNested<N>> implements ClusterPolicyBindingObjectsNested<N>{

        private final ClusterPolicyBindingBuilder builder;
    
             ClusterPolicyBindingObjectsNestedImpl (){
        this.builder = new ClusterPolicyBindingBuilder(this);
        }
             ClusterPolicyBindingObjectsNestedImpl ( ClusterPolicyBinding item){
        this.builder = new ClusterPolicyBindingBuilder(this, item);
        }
    
            public N endClusterPolicyBindingObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluentImpl.this.addToClusterPolicyBindingObjects(builder.build());
        }
    
}
    public class NamespaceObjectsNestedImpl<N> extends NamespaceFluentImpl<NamespaceObjectsNested<N>> implements NamespaceObjectsNested<N>{

        private final NamespaceBuilder builder;
    
             NamespaceObjectsNestedImpl (){
        this.builder = new NamespaceBuilder(this);
        }
             NamespaceObjectsNestedImpl ( Namespace item){
        this.builder = new NamespaceBuilder(this, item);
        }
    
            public N endNamespaceObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluentImpl.this.addToNamespaceObjects(builder.build());
        }
    
}
    public class IdentityObjectsNestedImpl<N> extends IdentityFluentImpl<IdentityObjectsNested<N>> implements IdentityObjectsNested<N>{

        private final IdentityBuilder builder;
    
             IdentityObjectsNestedImpl (){
        this.builder = new IdentityBuilder(this);
        }
             IdentityObjectsNestedImpl ( Identity item){
        this.builder = new IdentityBuilder(this, item);
        }
    
            public N and(){
            return (N) TemplateFluentImpl.this.addToIdentityObjects(builder.build());
        }
            public N endIdentityObject(){
            return and();
        }
    
}
    public class ParametersNestedImpl<N> extends ParameterFluentImpl<ParametersNested<N>> implements ParametersNested<N>{

        private final ParameterBuilder builder;
    
             ParametersNestedImpl (){
        this.builder = new ParameterBuilder(this);
        }
             ParametersNestedImpl ( Parameter item){
        this.builder = new ParameterBuilder(this, item);
        }
    
            public N endParameter(){
            return and();
        }
            public N and(){
            return (N) TemplateFluentImpl.this.addToParameters(builder.build());
        }
    
}


}
