package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public class MetadataFileFluentImpl<T extends MetadataFileFluent<T>> extends BaseFluent<T> implements MetadataFileFluent<T>{

     VisitableBuilder<ObjectFieldSelector, ?> fieldRef;     String name;     Map<String, Object> additionalProperties = new HashMap();
public MetadataFileFluentImpl(){
    
}
public MetadataFileFluentImpl( MetadataFile instance ){
    this.withFieldRef(instance.getFieldRef()); this.withName(instance.getName()); 
}

    public ObjectFieldSelector getFieldRef(){
    return this.fieldRef!=null?this.fieldRef.build():null;
    }
    public T withFieldRef( ObjectFieldSelector fieldRef){
    if (fieldRef!=null){ this.fieldRef= new ObjectFieldSelectorBuilder(fieldRef); _visitables.add(this.fieldRef);} return (T) this;
    }
    public FieldRefNested<T> withNewFieldRef(){
    return new FieldRefNestedImpl<T>();
    }
    public FieldRefNested<T> withNewFieldRefLike( ObjectFieldSelector item){
    return new FieldRefNestedImpl<T>(item);
    }
    public FieldRefNested<T> editFieldRef(){
    return withNewFieldRefLike(getFieldRef());
    }
    public T withNewFieldRef( String apiVersion,  String fieldPath){
    return withFieldRef(new ObjectFieldSelector(apiVersion, fieldPath));
    }
    public String getName(){
    return this.name;
    }
    public T withName( String name){
    this.name=name; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
MetadataFileFluentImpl that = (MetadataFileFluentImpl) o;
if (fieldRef != null ? !fieldRef.equals(that.fieldRef) :that.fieldRef != null) return false;
if (name != null ? !name.equals(that.name) :that.name != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class FieldRefNestedImpl<N> extends ObjectFieldSelectorFluentImpl<FieldRefNested<N>> implements FieldRefNested<N>{

        private final ObjectFieldSelectorBuilder builder;
    
             FieldRefNestedImpl ( ObjectFieldSelector item){
        this.builder = new ObjectFieldSelectorBuilder(this, item);
        }
             FieldRefNestedImpl (){
        this.builder = new ObjectFieldSelectorBuilder(this);
        }
    
            public N and(){
            return (N) MetadataFileFluentImpl.this.withFieldRef(builder.build());
        }
            public N endFieldRef(){
            return and();
        }
    
}


}
