package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Builder;

public class StatusDetailsBuilder extends StatusDetailsFluentImpl<StatusDetailsBuilder> implements VisitableBuilder<StatusDetails,StatusDetailsBuilder>{

     StatusDetailsFluent<?> fluent;
public StatusDetailsBuilder(){
    this(new StatusDetails());
}
public StatusDetailsBuilder( StatusDetailsFluent<?> fluent ){
    this(fluent, new StatusDetails());
}
public StatusDetailsBuilder( StatusDetailsFluent<?> fluent , StatusDetails instance ){
    this.fluent = fluent; fluent.withCauses(instance.getCauses()); fluent.withKind(instance.getKind()); fluent.withName(instance.getName()); fluent.withRetryAfterSeconds(instance.getRetryAfterSeconds()); 
}
public StatusDetailsBuilder( StatusDetails instance ){
    this.fluent = this; this.withCauses(instance.getCauses()); this.withKind(instance.getKind()); this.withName(instance.getName()); this.withRetryAfterSeconds(instance.getRetryAfterSeconds()); 
}

public EditableStatusDetails build(){
    EditableStatusDetails buildable = new EditableStatusDetails(fluent.getCauses(),fluent.getKind(),fluent.getName(),fluent.getRetryAfterSeconds());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
StatusDetailsBuilder that = (StatusDetailsBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
