package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface PersistentVolumeSpecFluent<T extends PersistentVolumeSpecFluent<T>> extends Fluent<T>{


    public T addToAccessModes( String ...items);    public T removeFromAccessModes( String ...items);    public List<String> getAccessModes();    public T withAccessModes( List<String> accessModes);    public T withAccessModes( String ...accessModes);    public AWSElasticBlockStoreVolumeSource getAwsElasticBlockStore();    public T withAwsElasticBlockStore( AWSElasticBlockStoreVolumeSource awsElasticBlockStore);    public AwsElasticBlockStoreNested<T> withNewAwsElasticBlockStore();    public AwsElasticBlockStoreNested<T> withNewAwsElasticBlockStoreLike( AWSElasticBlockStoreVolumeSource item);    public AwsElasticBlockStoreNested<T> editAwsElasticBlockStore();    public T withNewAwsElasticBlockStore( String fsType,  Integer partition,  Boolean readOnly,  String volumeID);    public T addToCapacity( String key,  Quantity value);    public T addToCapacity( Map<String, Quantity> map);    public T removeFromCapacity( String key);    public T removeFromCapacity( Map<String, Quantity> map);    public Map<String, Quantity> getCapacity();    public T withCapacity( Map<String, Quantity> capacity);    public CephFSVolumeSource getCephfs();    public T withCephfs( CephFSVolumeSource cephfs);    public CephfsNested<T> withNewCephfs();    public CephfsNested<T> withNewCephfsLike( CephFSVolumeSource item);    public CephfsNested<T> editCephfs();    public ObjectReference getClaimRef();    public T withClaimRef( ObjectReference claimRef);    public ClaimRefNested<T> withNewClaimRef();    public ClaimRefNested<T> withNewClaimRefLike( ObjectReference item);    public ClaimRefNested<T> editClaimRef();    public GCEPersistentDiskVolumeSource getGcePersistentDisk();    public T withGcePersistentDisk( GCEPersistentDiskVolumeSource gcePersistentDisk);    public GcePersistentDiskNested<T> withNewGcePersistentDisk();    public GcePersistentDiskNested<T> withNewGcePersistentDiskLike( GCEPersistentDiskVolumeSource item);    public GcePersistentDiskNested<T> editGcePersistentDisk();    public T withNewGcePersistentDisk( String fsType,  Integer partition,  String pdName,  Boolean readOnly);    public GlusterfsVolumeSource getGlusterfs();    public T withGlusterfs( GlusterfsVolumeSource glusterfs);    public GlusterfsNested<T> withNewGlusterfs();    public GlusterfsNested<T> withNewGlusterfsLike( GlusterfsVolumeSource item);    public GlusterfsNested<T> editGlusterfs();    public T withNewGlusterfs( String endpoints,  String path,  Boolean readOnly);    public HostPathVolumeSource getHostPath();    public T withHostPath( HostPathVolumeSource hostPath);    public HostPathNested<T> withNewHostPath();    public HostPathNested<T> withNewHostPathLike( HostPathVolumeSource item);    public HostPathNested<T> editHostPath();    public T withNewHostPath( String path);    public ISCSIVolumeSource getIscsi();    public T withIscsi( ISCSIVolumeSource iscsi);    public IscsiNested<T> withNewIscsi();    public IscsiNested<T> withNewIscsiLike( ISCSIVolumeSource item);    public IscsiNested<T> editIscsi();    public T withNewIscsi( String fsType,  String iqn,  Integer lun,  Boolean readOnly,  String targetPortal);    public NFSVolumeSource getNfs();    public T withNfs( NFSVolumeSource nfs);    public NfsNested<T> withNewNfs();    public NfsNested<T> withNewNfsLike( NFSVolumeSource item);    public NfsNested<T> editNfs();    public T withNewNfs( String path,  Boolean readOnly,  String server);    public String getPersistentVolumeReclaimPolicy();    public T withPersistentVolumeReclaimPolicy( String persistentVolumeReclaimPolicy);    public RBDVolumeSource getRbd();    public T withRbd( RBDVolumeSource rbd);    public RbdNested<T> withNewRbd();    public RbdNested<T> withNewRbdLike( RBDVolumeSource item);    public RbdNested<T> editRbd();    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface AwsElasticBlockStoreNested<N> extends Nested<N>, AWSElasticBlockStoreVolumeSourceFluent<AwsElasticBlockStoreNested<N>>{
            public N endAwsElasticBlockStore();            public N and();        
}

    public interface CephfsNested<N> extends Nested<N>, CephFSVolumeSourceFluent<CephfsNested<N>>{
            public N endCephfs();            public N and();        
}

    public interface ClaimRefNested<N> extends Nested<N>, ObjectReferenceFluent<ClaimRefNested<N>>{
            public N and();            public N endClaimRef();        
}

    public interface GcePersistentDiskNested<N> extends Nested<N>, GCEPersistentDiskVolumeSourceFluent<GcePersistentDiskNested<N>>{
            public N endGcePersistentDisk();            public N and();        
}

    public interface GlusterfsNested<N> extends Nested<N>, GlusterfsVolumeSourceFluent<GlusterfsNested<N>>{
            public N and();            public N endGlusterfs();        
}

    public interface HostPathNested<N> extends Nested<N>, HostPathVolumeSourceFluent<HostPathNested<N>>{
            public N and();            public N endHostPath();        
}

    public interface IscsiNested<N> extends Nested<N>, ISCSIVolumeSourceFluent<IscsiNested<N>>{
            public N and();            public N endIscsi();        
}

    public interface NfsNested<N> extends Nested<N>, NFSVolumeSourceFluent<NfsNested<N>>{
            public N endNfs();            public N and();        
}

    public interface RbdNested<N> extends Nested<N>, RBDVolumeSourceFluent<RbdNested<N>>{
            public N and();            public N endRbd();        
}


}
