package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class PodStatusFluentImpl<T extends PodStatusFluent<T>> extends BaseFluent<T> implements PodStatusFluent<T>{

     List<VisitableBuilder<PodCondition, ?>> conditions = new ArrayList();     List<VisitableBuilder<ContainerStatus, ?>> containerStatuses = new ArrayList();     String hostIP;     String message;     String phase;     String podIP;     String reason;     String startTime;     Map<String, Object> additionalProperties = new HashMap();
public PodStatusFluentImpl(){
    
}
public PodStatusFluentImpl( PodStatus instance ){
    this.withConditions(instance.getConditions()); this.withContainerStatuses(instance.getContainerStatuses()); this.withHostIP(instance.getHostIP()); this.withMessage(instance.getMessage()); this.withPhase(instance.getPhase()); this.withPodIP(instance.getPodIP()); this.withReason(instance.getReason()); this.withStartTime(instance.getStartTime()); 
}

    public T addToConditions( PodCondition ...items){
    for (PodCondition item : items) {PodConditionBuilder builder = new PodConditionBuilder(item);_visitables.add(builder);this.conditions.add(builder);} return (T)this;
    }
    public T removeFromConditions( PodCondition ...items){
    for (PodCondition item : items) {PodConditionBuilder builder = new PodConditionBuilder(item);_visitables.remove(builder);this.conditions.remove(builder);} return (T)this;
    }
    public List<PodCondition> getConditions(){
    return build(conditions);
    }
    public T withConditions( List<PodCondition> conditions){
    this.conditions.clear();if (conditions != null) {for (PodCondition item : conditions){this.addToConditions(item);}} return (T) this;
    }
    public T withConditions( PodCondition ...conditions){
    this.conditions.clear(); if (conditions != null) {for (PodCondition item :conditions){ this.addToConditions(item);}} return (T) this;
    }
    public ConditionsNested<T> addNewCondition(){
    return new ConditionsNestedImpl<T>();
    }
    public ConditionsNested<T> addNewConditionLike( PodCondition item){
    return new ConditionsNestedImpl<T>(item);
    }
    public T addNewCondition( String status,  String type){
    return addToConditions(new PodCondition(status, type));
    }
    public T addToContainerStatuses( ContainerStatus ...items){
    for (ContainerStatus item : items) {ContainerStatusBuilder builder = new ContainerStatusBuilder(item);_visitables.add(builder);this.containerStatuses.add(builder);} return (T)this;
    }
    public T removeFromContainerStatuses( ContainerStatus ...items){
    for (ContainerStatus item : items) {ContainerStatusBuilder builder = new ContainerStatusBuilder(item);_visitables.remove(builder);this.containerStatuses.remove(builder);} return (T)this;
    }
    public List<ContainerStatus> getContainerStatuses(){
    return build(containerStatuses);
    }
    public T withContainerStatuses( List<ContainerStatus> containerStatuses){
    this.containerStatuses.clear();if (containerStatuses != null) {for (ContainerStatus item : containerStatuses){this.addToContainerStatuses(item);}} return (T) this;
    }
    public T withContainerStatuses( ContainerStatus ...containerStatuses){
    this.containerStatuses.clear(); if (containerStatuses != null) {for (ContainerStatus item :containerStatuses){ this.addToContainerStatuses(item);}} return (T) this;
    }
    public ContainerStatusesNested<T> addNewContainerStatuse(){
    return new ContainerStatusesNestedImpl<T>();
    }
    public ContainerStatusesNested<T> addNewContainerStatuseLike( ContainerStatus item){
    return new ContainerStatusesNestedImpl<T>(item);
    }
    public String getHostIP(){
    return this.hostIP;
    }
    public T withHostIP( String hostIP){
    this.hostIP=hostIP; return (T) this;
    }
    public String getMessage(){
    return this.message;
    }
    public T withMessage( String message){
    this.message=message; return (T) this;
    }
    public String getPhase(){
    return this.phase;
    }
    public T withPhase( String phase){
    this.phase=phase; return (T) this;
    }
    public String getPodIP(){
    return this.podIP;
    }
    public T withPodIP( String podIP){
    this.podIP=podIP; return (T) this;
    }
    public String getReason(){
    return this.reason;
    }
    public T withReason( String reason){
    this.reason=reason; return (T) this;
    }
    public String getStartTime(){
    return this.startTime;
    }
    public T withStartTime( String startTime){
    this.startTime=startTime; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
PodStatusFluentImpl that = (PodStatusFluentImpl) o;
if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
if (containerStatuses != null ? !containerStatuses.equals(that.containerStatuses) :that.containerStatuses != null) return false;
if (hostIP != null ? !hostIP.equals(that.hostIP) :that.hostIP != null) return false;
if (message != null ? !message.equals(that.message) :that.message != null) return false;
if (phase != null ? !phase.equals(that.phase) :that.phase != null) return false;
if (podIP != null ? !podIP.equals(that.podIP) :that.podIP != null) return false;
if (reason != null ? !reason.equals(that.reason) :that.reason != null) return false;
if (startTime != null ? !startTime.equals(that.startTime) :that.startTime != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class ConditionsNestedImpl<N> extends PodConditionFluentImpl<ConditionsNested<N>> implements ConditionsNested<N>{

        private final PodConditionBuilder builder;
    
             ConditionsNestedImpl (){
        this.builder = new PodConditionBuilder(this);
        }
             ConditionsNestedImpl ( PodCondition item){
        this.builder = new PodConditionBuilder(this, item);
        }
    
            public N endCondition(){
            return and();
        }
            public N and(){
            return (N) PodStatusFluentImpl.this.addToConditions(builder.build());
        }
    
}
    public class ContainerStatusesNestedImpl<N> extends ContainerStatusFluentImpl<ContainerStatusesNested<N>> implements ContainerStatusesNested<N>{

        private final ContainerStatusBuilder builder;
    
             ContainerStatusesNestedImpl (){
        this.builder = new ContainerStatusBuilder(this);
        }
             ContainerStatusesNestedImpl ( ContainerStatus item){
        this.builder = new ContainerStatusBuilder(this, item);
        }
    
            public N endContainerStatuse(){
            return and();
        }
            public N and(){
            return (N) PodStatusFluentImpl.this.addToContainerStatuses(builder.build());
        }
    
}


}
