package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Builder;

public class RootPathsBuilder extends RootPathsFluentImpl<RootPathsBuilder> implements VisitableBuilder<RootPaths,RootPathsBuilder>{

     RootPathsFluent<?> fluent;
public RootPathsBuilder(){
    this(new RootPaths());
}
public RootPathsBuilder( RootPathsFluent<?> fluent ){
    this(fluent, new RootPaths());
}
public RootPathsBuilder( RootPathsFluent<?> fluent , RootPaths instance ){
    this.fluent = fluent; fluent.withPaths(instance.getPaths()); 
}
public RootPathsBuilder( RootPaths instance ){
    this.fluent = this; this.withPaths(instance.getPaths()); 
}

public EditableRootPaths build(){
    EditableRootPaths buildable = new EditableRootPaths(fluent.getPaths());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
RootPathsBuilder that = (RootPathsBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
