package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Builder;

public class RollingDeploymentStrategyParamsBuilder extends RollingDeploymentStrategyParamsFluentImpl<RollingDeploymentStrategyParamsBuilder> implements VisitableBuilder<RollingDeploymentStrategyParams,RollingDeploymentStrategyParamsBuilder>{

     RollingDeploymentStrategyParamsFluent<?> fluent;
public RollingDeploymentStrategyParamsBuilder(){
    this(new RollingDeploymentStrategyParams());
}
public RollingDeploymentStrategyParamsBuilder( RollingDeploymentStrategyParamsFluent<?> fluent ){
    this(fluent, new RollingDeploymentStrategyParams());
}
public RollingDeploymentStrategyParamsBuilder( RollingDeploymentStrategyParamsFluent<?> fluent , RollingDeploymentStrategyParams instance ){
    this.fluent = fluent; fluent.withIntervalSeconds(instance.getIntervalSeconds()); fluent.withPost(instance.getPost()); fluent.withPre(instance.getPre()); fluent.withTimeoutSeconds(instance.getTimeoutSeconds()); fluent.withUpdatePercent(instance.getUpdatePercent()); fluent.withUpdatePeriodSeconds(instance.getUpdatePeriodSeconds()); 
}
public RollingDeploymentStrategyParamsBuilder( RollingDeploymentStrategyParams instance ){
    this.fluent = this; this.withIntervalSeconds(instance.getIntervalSeconds()); this.withPost(instance.getPost()); this.withPre(instance.getPre()); this.withTimeoutSeconds(instance.getTimeoutSeconds()); this.withUpdatePercent(instance.getUpdatePercent()); this.withUpdatePeriodSeconds(instance.getUpdatePeriodSeconds()); 
}

public EditableRollingDeploymentStrategyParams build(){
    EditableRollingDeploymentStrategyParams buildable = new EditableRollingDeploymentStrategyParams(fluent.getIntervalSeconds(),fluent.getPost(),fluent.getPre(),fluent.getTimeoutSeconds(),fluent.getUpdatePercent(),fluent.getUpdatePeriodSeconds());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
RollingDeploymentStrategyParamsBuilder that = (RollingDeploymentStrategyParamsBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
