
package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "apiVersion",
    "content",
    "groups",
    "kind",
    "namespace",
    "resource",
    "resourceName",
    "user",
    "verb"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = true, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = @Inline(type = Doneable.class, prefix = "Doneable", value = "done"))
public class SubjectAccessReview {

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("apiVersion")
    @NotNull
    private SubjectAccessReview.ApiVersion apiVersion = SubjectAccessReview.ApiVersion.fromValue("v1");
    /**
     * 
     * 
     */
    @JsonProperty("content")
    @Valid
    private HasMetadata content;
    /**
     * optional
     * 
     */
    @JsonProperty("groups")
    @Valid
    private List<String> groups = new ArrayList<String>();
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("kind")
    @NotNull
    private String kind = "SubjectAccessReview";
    /**
     * namespace of the action being requested
     * 
     */
    @JsonProperty("namespace")
    private String namespace;
    /**
     * one of the existing resource types
     * 
     */
    @JsonProperty("resource")
    private String resource;
    /**
     * name of the resource being requested for a get or delete
     * 
     */
    @JsonProperty("resourceName")
    private String resourceName;
    /**
     * optional
     * 
     */
    @JsonProperty("user")
    private String user;
    /**
     * one of get
     * 
     */
    @JsonProperty("verb")
    private String verb;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public SubjectAccessReview() {
    }

    /**
     * 
     * @param apiVersion
     * @param resource
     * @param kind
     * @param namespace
     * @param verb
     * @param groups
     * @param resourceName
     * @param user
     * @param content
     */
    public SubjectAccessReview(SubjectAccessReview.ApiVersion apiVersion, HasMetadata content, List<String> groups, String kind, String namespace, String resource, String resourceName, String user, String verb) {
        this.apiVersion = apiVersion;
        this.content = content;
        this.groups = groups;
        this.kind = kind;
        this.namespace = namespace;
        this.resource = resource;
        this.resourceName = resourceName;
        this.user = user;
        this.verb = verb;
    }

    /**
     * 
     * (Required)
     * 
     * @return
     *     The apiVersion
     */
    @JsonProperty("apiVersion")
    public SubjectAccessReview.ApiVersion getApiVersion() {
        return apiVersion;
    }

    /**
     * 
     * (Required)
     * 
     * @param apiVersion
     *     The apiVersion
     */
    @JsonProperty("apiVersion")
    public void setApiVersion(SubjectAccessReview.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
    }

    /**
     * 
     * 
     * @return
     *     The content
     */
    @JsonProperty("content")
    public HasMetadata getContent() {
        return content;
    }

    /**
     * 
     * 
     * @param content
     *     The content
     */
    @JsonProperty("content")
    public void setContent(HasMetadata content) {
        this.content = content;
    }

    /**
     * optional
     * 
     * @return
     *     The groups
     */
    @JsonProperty("groups")
    public List<String> getGroups() {
        return groups;
    }

    /**
     * optional
     * 
     * @param groups
     *     The groups
     */
    @JsonProperty("groups")
    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    /**
     * 
     * (Required)
     * 
     * @return
     *     The kind
     */
    @JsonProperty("kind")
    public String getKind() {
        return kind;
    }

    /**
     * 
     * (Required)
     * 
     * @param kind
     *     The kind
     */
    @JsonProperty("kind")
    public void setKind(String kind) {
        this.kind = kind;
    }

    /**
     * namespace of the action being requested
     * 
     * @return
     *     The namespace
     */
    @JsonProperty("namespace")
    public String getNamespace() {
        return namespace;
    }

    /**
     * namespace of the action being requested
     * 
     * @param namespace
     *     The namespace
     */
    @JsonProperty("namespace")
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    /**
     * one of the existing resource types
     * 
     * @return
     *     The resource
     */
    @JsonProperty("resource")
    public String getResource() {
        return resource;
    }

    /**
     * one of the existing resource types
     * 
     * @param resource
     *     The resource
     */
    @JsonProperty("resource")
    public void setResource(String resource) {
        this.resource = resource;
    }

    /**
     * name of the resource being requested for a get or delete
     * 
     * @return
     *     The resourceName
     */
    @JsonProperty("resourceName")
    public String getResourceName() {
        return resourceName;
    }

    /**
     * name of the resource being requested for a get or delete
     * 
     * @param resourceName
     *     The resourceName
     */
    @JsonProperty("resourceName")
    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    /**
     * optional
     * 
     * @return
     *     The user
     */
    @JsonProperty("user")
    public String getUser() {
        return user;
    }

    /**
     * optional
     * 
     * @param user
     *     The user
     */
    @JsonProperty("user")
    public void setUser(String user) {
        this.user = user;
    }

    /**
     * one of get
     * 
     * @return
     *     The verb
     */
    @JsonProperty("verb")
    public String getVerb() {
        return verb;
    }

    /**
     * one of get
     * 
     * @param verb
     *     The verb
     */
    @JsonProperty("verb")
    public void setVerb(String verb) {
        this.verb = verb;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Generated("org.jsonschema2pojo")
    public static enum ApiVersion {

        V_1("v1");
        private final String value;
        private static Map<String, SubjectAccessReview.ApiVersion> constants = new HashMap<String, SubjectAccessReview.ApiVersion>();

        static {
            for (SubjectAccessReview.ApiVersion c: values()) {
                constants.put(c.value, c);
            }
        }

        private ApiVersion(String value) {
            this.value = value;
        }

        @JsonValue
        @Override
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static SubjectAccessReview.ApiVersion fromValue(String value) {
            SubjectAccessReview.ApiVersion constant = constants.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
