package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface ContainerStateFluent<T extends ContainerStateFluent<T>> extends Fluent<T>{


    public ContainerStateRunning getRunning();    public T withRunning( ContainerStateRunning running);    public RunningNested<T> withNewRunning();    public RunningNested<T> withNewRunningLike( ContainerStateRunning item);    public RunningNested<T> editRunning();    public T withNewRunning( String startedAt);    public ContainerStateTerminated getTerminated();    public T withTerminated( ContainerStateTerminated terminated);    public TerminatedNested<T> withNewTerminated();    public TerminatedNested<T> withNewTerminatedLike( ContainerStateTerminated item);    public TerminatedNested<T> editTerminated();    public ContainerStateWaiting getWaiting();    public T withWaiting( ContainerStateWaiting waiting);    public WaitingNested<T> withNewWaiting();    public WaitingNested<T> withNewWaitingLike( ContainerStateWaiting item);    public WaitingNested<T> editWaiting();    public T withNewWaiting( String reason);    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface RunningNested<N> extends Nested<N>, ContainerStateRunningFluent<RunningNested<N>>{
            public N and();            public N endRunning();        
}

    public interface TerminatedNested<N> extends Nested<N>, ContainerStateTerminatedFluent<TerminatedNested<N>>{
            public N endTerminated();            public N and();        
}

    public interface WaitingNested<N> extends Nested<N>, ContainerStateWaitingFluent<WaitingNested<N>>{
            public N and();            public N endWaiting();        
}


}
