package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.HasMetadata;
import java.util.ArrayList;
import java.util.Map;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.model.ResourceQuota;
import io.fabric8.kubernetes.api.model.ServiceAccountBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ResourceQuotaFluent;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeFluent;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluent;
import io.fabric8.kubernetes.api.model.NodeFluent;
import io.fabric8.kubernetes.api.model.ResourceQuotaBuilder;
import io.fabric8.kubernetes.api.model.SecretBuilder;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.EndpointsBuilder;
import io.fabric8.kubernetes.api.model.EventFluent;
import io.fabric8.kubernetes.api.model.ServiceAccountFluent;
import io.fabric8.kubernetes.api.model.SecretFluent;
import io.fabric8.kubernetes.api.model.PersistentVolumeBuilder;
import io.fabric8.kubernetes.api.model.SecurityContextConstraints;
import io.fabric8.kubernetes.api.model.EventBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.PersistentVolume;
import io.fabric8.kubernetes.api.model.Event;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.NodeBuilder;
import io.fabric8.kubernetes.api.model.EndpointsFluent;
import io.fabric8.kubernetes.api.model.SecurityContextConstraintsFluent;
import io.fabric8.kubernetes.api.model.SecurityContextConstraintsBuilder;
import io.fabric8.kubernetes.api.model.Node;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.ReplicationControllerBuilder;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.ServiceFluent;

public interface TemplateFluent<T extends TemplateFluent<T>> extends Fluent<T>{


    public Template.ApiVersion getApiVersion();    public T withApiVersion( Template.ApiVersion apiVersion);    public String getKind();    public T withKind( String kind);    public T addToLabels( String key,  String value);    public T addToLabels( Map<String, String> map);    public T removeFromLabels( String key);    public T removeFromLabels( Map<String, String> map);    public Map<String, String> getLabels();    public T withLabels( Map<String, String> labels);    public ObjectMeta getMetadata();    public T withMetadata( ObjectMeta metadata);    public MetadataNested<T> withNewMetadata();    public MetadataNested<T> withNewMetadataLike( ObjectMeta item);    public MetadataNested<T> editMetadata();    public T addToObjects( HasMetadata ...items);    public T removeFromObjects( HasMetadata ...items);    public List<HasMetadata> getObjects();    public T withObjects( List<HasMetadata> objects);    public T withObjects( HasMetadata ...objects);    public T addToPolicyObjects( Policy ...items);    public T removeFromPolicyObjects( Policy ...items);    public PolicyObjectsNested<T> addNewPolicyObject();    public PolicyObjectsNested<T> addNewPolicyObjectLike( Policy item);    public T addToTemplateObjects( Template ...items);    public T removeFromTemplateObjects( Template ...items);    public TemplateObjectsNested<T> addNewTemplateObject();    public TemplateObjectsNested<T> addNewTemplateObjectLike( Template item);    public T addToProjectObjects( Project ...items);    public T removeFromProjectObjects( Project ...items);    public ProjectObjectsNested<T> addNewProjectObject();    public ProjectObjectsNested<T> addNewProjectObjectLike( Project item);    public T addToOAuthAuthorizeTokenObjects( OAuthAuthorizeToken ...items);    public T removeFromOAuthAuthorizeTokenObjects( OAuthAuthorizeToken ...items);    public OAuthAuthorizeTokenObjectsNested<T> addNewOAuthAuthorizeTokenObject();    public OAuthAuthorizeTokenObjectsNested<T> addNewOAuthAuthorizeTokenObjectLike( OAuthAuthorizeToken item);    public T addToRoleBindingObjects( RoleBinding ...items);    public T removeFromRoleBindingObjects( RoleBinding ...items);    public RoleBindingObjectsNested<T> addNewRoleBindingObject();    public RoleBindingObjectsNested<T> addNewRoleBindingObjectLike( RoleBinding item);    public T addToBuildConfigObjects( BuildConfig ...items);    public T removeFromBuildConfigObjects( BuildConfig ...items);    public BuildConfigObjectsNested<T> addNewBuildConfigObject();    public BuildConfigObjectsNested<T> addNewBuildConfigObjectLike( BuildConfig item);    public T addToSecretObjects( Secret ...items);    public T removeFromSecretObjects( Secret ...items);    public SecretObjectsNested<T> addNewSecretObject();    public SecretObjectsNested<T> addNewSecretObjectLike( Secret item);    public T addToReplicationControllerObjects( ReplicationController ...items);    public T removeFromReplicationControllerObjects( ReplicationController ...items);    public ReplicationControllerObjectsNested<T> addNewReplicationControllerObject();    public ReplicationControllerObjectsNested<T> addNewReplicationControllerObjectLike( ReplicationController item);    public T addToUserObjects( User ...items);    public T removeFromUserObjects( User ...items);    public UserObjectsNested<T> addNewUserObject();    public UserObjectsNested<T> addNewUserObjectLike( User item);    public T addToImageObjects( Image ...items);    public T removeFromImageObjects( Image ...items);    public ImageObjectsNested<T> addNewImageObject();    public ImageObjectsNested<T> addNewImageObjectLike( Image item);    public T addToEndpointsObjects( Endpoints ...items);    public T removeFromEndpointsObjects( Endpoints ...items);    public EndpointsObjectsNested<T> addNewEndpointsObject();    public EndpointsObjectsNested<T> addNewEndpointsObjectLike( Endpoints item);    public T addToClusterRoleObjects( ClusterRole ...items);    public T removeFromClusterRoleObjects( ClusterRole ...items);    public ClusterRoleObjectsNested<T> addNewClusterRoleObject();    public ClusterRoleObjectsNested<T> addNewClusterRoleObjectLike( ClusterRole item);    public T addToRouteObjects( Route ...items);    public T removeFromRouteObjects( Route ...items);    public RouteObjectsNested<T> addNewRouteObject();    public RouteObjectsNested<T> addNewRouteObjectLike( Route item);    public T addToRoleObjects( Role ...items);    public T removeFromRoleObjects( Role ...items);    public RoleObjectsNested<T> addNewRoleObject();    public RoleObjectsNested<T> addNewRoleObjectLike( Role item);    public T addToSecurityContextConstraintsObjects( SecurityContextConstraints ...items);    public T removeFromSecurityContextConstraintsObjects( SecurityContextConstraints ...items);    public SecurityContextConstraintsObjectsNested<T> addNewSecurityContextConstraintsObject();    public SecurityContextConstraintsObjectsNested<T> addNewSecurityContextConstraintsObjectLike( SecurityContextConstraints item);    public T addToNodeObjects( Node ...items);    public T removeFromNodeObjects( Node ...items);    public NodeObjectsNested<T> addNewNodeObject();    public NodeObjectsNested<T> addNewNodeObjectLike( Node item);    public T addToOAuthClientAuthorizationObjects( OAuthClientAuthorization ...items);    public T removeFromOAuthClientAuthorizationObjects( OAuthClientAuthorization ...items);    public OAuthClientAuthorizationObjectsNested<T> addNewOAuthClientAuthorizationObject();    public OAuthClientAuthorizationObjectsNested<T> addNewOAuthClientAuthorizationObjectLike( OAuthClientAuthorization item);    public T addToOAuthAccessTokenObjects( OAuthAccessToken ...items);    public T removeFromOAuthAccessTokenObjects( OAuthAccessToken ...items);    public OAuthAccessTokenObjectsNested<T> addNewOAuthAccessTokenObject();    public OAuthAccessTokenObjectsNested<T> addNewOAuthAccessTokenObjectLike( OAuthAccessToken item);    public T addToServiceAccountObjects( ServiceAccount ...items);    public T removeFromServiceAccountObjects( ServiceAccount ...items);    public ServiceAccountObjectsNested<T> addNewServiceAccountObject();    public ServiceAccountObjectsNested<T> addNewServiceAccountObjectLike( ServiceAccount item);    public T addToImageStreamObjects( ImageStream ...items);    public T removeFromImageStreamObjects( ImageStream ...items);    public ImageStreamObjectsNested<T> addNewImageStreamObject();    public ImageStreamObjectsNested<T> addNewImageStreamObjectLike( ImageStream item);    public T addToBuildRequestObjects( BuildRequest ...items);    public T removeFromBuildRequestObjects( BuildRequest ...items);    public BuildRequestObjectsNested<T> addNewBuildRequestObject();    public BuildRequestObjectsNested<T> addNewBuildRequestObjectLike( BuildRequest item);    public T addToServiceObjects( Service ...items);    public T removeFromServiceObjects( Service ...items);    public ServiceObjectsNested<T> addNewServiceObject();    public ServiceObjectsNested<T> addNewServiceObjectLike( Service item);    public T addToBuildObjects( Build ...items);    public T removeFromBuildObjects( Build ...items);    public BuildObjectsNested<T> addNewBuildObject();    public BuildObjectsNested<T> addNewBuildObjectLike( Build item);    public T addToDeploymentConfigObjects( DeploymentConfig ...items);    public T removeFromDeploymentConfigObjects( DeploymentConfig ...items);    public DeploymentConfigObjectsNested<T> addNewDeploymentConfigObject();    public DeploymentConfigObjectsNested<T> addNewDeploymentConfigObjectLike( DeploymentConfig item);    public T addToClusterRoleBindingObjects( ClusterRoleBinding ...items);    public T removeFromClusterRoleBindingObjects( ClusterRoleBinding ...items);    public ClusterRoleBindingObjectsNested<T> addNewClusterRoleBindingObject();    public ClusterRoleBindingObjectsNested<T> addNewClusterRoleBindingObjectLike( ClusterRoleBinding item);    public T addToGroupObjects( Group ...items);    public T removeFromGroupObjects( Group ...items);    public GroupObjectsNested<T> addNewGroupObject();    public GroupObjectsNested<T> addNewGroupObjectLike( Group item);    public T addToPersistentVolumeClaimObjects( PersistentVolumeClaim ...items);    public T removeFromPersistentVolumeClaimObjects( PersistentVolumeClaim ...items);    public PersistentVolumeClaimObjectsNested<T> addNewPersistentVolumeClaimObject();    public PersistentVolumeClaimObjectsNested<T> addNewPersistentVolumeClaimObjectLike( PersistentVolumeClaim item);    public T addToPodObjects( Pod ...items);    public T removeFromPodObjects( Pod ...items);    public PodObjectsNested<T> addNewPodObject();    public PodObjectsNested<T> addNewPodObjectLike( Pod item);    public T addToPolicyBindingObjects( PolicyBinding ...items);    public T removeFromPolicyBindingObjects( PolicyBinding ...items);    public PolicyBindingObjectsNested<T> addNewPolicyBindingObject();    public PolicyBindingObjectsNested<T> addNewPolicyBindingObjectLike( PolicyBinding item);    public T addToOAuthClientObjects( OAuthClient ...items);    public T removeFromOAuthClientObjects( OAuthClient ...items);    public OAuthClientObjectsNested<T> addNewOAuthClientObject();    public OAuthClientObjectsNested<T> addNewOAuthClientObjectLike( OAuthClient item);    public T addToPersistentVolumeObjects( PersistentVolume ...items);    public T removeFromPersistentVolumeObjects( PersistentVolume ...items);    public PersistentVolumeObjectsNested<T> addNewPersistentVolumeObject();    public PersistentVolumeObjectsNested<T> addNewPersistentVolumeObjectLike( PersistentVolume item);    public T addToEventObjects( Event ...items);    public T removeFromEventObjects( Event ...items);    public EventObjectsNested<T> addNewEventObject();    public EventObjectsNested<T> addNewEventObjectLike( Event item);    public T addToProjectRequestObjects( ProjectRequest ...items);    public T removeFromProjectRequestObjects( ProjectRequest ...items);    public ProjectRequestObjectsNested<T> addNewProjectRequestObject();    public ProjectRequestObjectsNested<T> addNewProjectRequestObjectLike( ProjectRequest item);    public T addToResourceQuotaObjects( ResourceQuota ...items);    public T removeFromResourceQuotaObjects( ResourceQuota ...items);    public ResourceQuotaObjectsNested<T> addNewResourceQuotaObject();    public ResourceQuotaObjectsNested<T> addNewResourceQuotaObjectLike( ResourceQuota item);    public T addToClusterPolicyObjects( ClusterPolicy ...items);    public T removeFromClusterPolicyObjects( ClusterPolicy ...items);    public ClusterPolicyObjectsNested<T> addNewClusterPolicyObject();    public ClusterPolicyObjectsNested<T> addNewClusterPolicyObjectLike( ClusterPolicy item);    public T addToClusterPolicyBindingObjects( ClusterPolicyBinding ...items);    public T removeFromClusterPolicyBindingObjects( ClusterPolicyBinding ...items);    public ClusterPolicyBindingObjectsNested<T> addNewClusterPolicyBindingObject();    public ClusterPolicyBindingObjectsNested<T> addNewClusterPolicyBindingObjectLike( ClusterPolicyBinding item);    public T addToNamespaceObjects( Namespace ...items);    public T removeFromNamespaceObjects( Namespace ...items);    public NamespaceObjectsNested<T> addNewNamespaceObject();    public NamespaceObjectsNested<T> addNewNamespaceObjectLike( Namespace item);    public T addToIdentityObjects( Identity ...items);    public T removeFromIdentityObjects( Identity ...items);    public IdentityObjectsNested<T> addNewIdentityObject();    public IdentityObjectsNested<T> addNewIdentityObjectLike( Identity item);    public T addToParameters( Parameter ...items);    public T removeFromParameters( Parameter ...items);    public List<Parameter> getParameters();    public T withParameters( List<Parameter> parameters);    public T withParameters( Parameter ...parameters);    public ParametersNested<T> addNewParameter();    public ParametersNested<T> addNewParameterLike( Parameter item);    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface MetadataNested<N> extends Nested<N>, ObjectMetaFluent<MetadataNested<N>>{
            public N and();            public N endMetadata();        
}

    public interface PolicyObjectsNested<N> extends Nested<N>, PolicyFluent<PolicyObjectsNested<N>>{
            public N and();            public N endPolicyObject();        
}

    public interface TemplateObjectsNested<N> extends Nested<N>, TemplateFluent<TemplateObjectsNested<N>>{
            public N endTemplateObject();            public N and();        
}

    public interface ProjectObjectsNested<N> extends Nested<N>, ProjectFluent<ProjectObjectsNested<N>>{
            public N and();            public N endProjectObject();        
}

    public interface OAuthAuthorizeTokenObjectsNested<N> extends Nested<N>, OAuthAuthorizeTokenFluent<OAuthAuthorizeTokenObjectsNested<N>>{
            public N and();            public N endOAuthAuthorizeTokenObject();        
}

    public interface RoleBindingObjectsNested<N> extends Nested<N>, RoleBindingFluent<RoleBindingObjectsNested<N>>{
            public N and();            public N endRoleBindingObject();        
}

    public interface BuildConfigObjectsNested<N> extends Nested<N>, BuildConfigFluent<BuildConfigObjectsNested<N>>{
            public N and();            public N endBuildConfigObject();        
}

    public interface SecretObjectsNested<N> extends Nested<N>, SecretFluent<SecretObjectsNested<N>>{
            public N endSecretObject();            public N and();        
}

    public interface ReplicationControllerObjectsNested<N> extends Nested<N>, ReplicationControllerFluent<ReplicationControllerObjectsNested<N>>{
            public N endReplicationControllerObject();            public N and();        
}

    public interface UserObjectsNested<N> extends Nested<N>, UserFluent<UserObjectsNested<N>>{
            public N and();            public N endUserObject();        
}

    public interface ImageObjectsNested<N> extends Nested<N>, ImageFluent<ImageObjectsNested<N>>{
            public N endImageObject();            public N and();        
}

    public interface EndpointsObjectsNested<N> extends Nested<N>, EndpointsFluent<EndpointsObjectsNested<N>>{
            public N and();            public N endEndpointsObject();        
}

    public interface ClusterRoleObjectsNested<N> extends Nested<N>, ClusterRoleFluent<ClusterRoleObjectsNested<N>>{
            public N endClusterRoleObject();            public N and();        
}

    public interface RouteObjectsNested<N> extends Nested<N>, RouteFluent<RouteObjectsNested<N>>{
            public N endRouteObject();            public N and();        
}

    public interface RoleObjectsNested<N> extends Nested<N>, RoleFluent<RoleObjectsNested<N>>{
            public N and();            public N endRoleObject();        
}

    public interface SecurityContextConstraintsObjectsNested<N> extends Nested<N>, SecurityContextConstraintsFluent<SecurityContextConstraintsObjectsNested<N>>{
            public N and();            public N endSecurityContextConstraintsObject();        
}

    public interface NodeObjectsNested<N> extends Nested<N>, NodeFluent<NodeObjectsNested<N>>{
            public N endNodeObject();            public N and();        
}

    public interface OAuthClientAuthorizationObjectsNested<N> extends Nested<N>, OAuthClientAuthorizationFluent<OAuthClientAuthorizationObjectsNested<N>>{
            public N endOAuthClientAuthorizationObject();            public N and();        
}

    public interface OAuthAccessTokenObjectsNested<N> extends Nested<N>, OAuthAccessTokenFluent<OAuthAccessTokenObjectsNested<N>>{
            public N endOAuthAccessTokenObject();            public N and();        
}

    public interface ServiceAccountObjectsNested<N> extends Nested<N>, ServiceAccountFluent<ServiceAccountObjectsNested<N>>{
            public N and();            public N endServiceAccountObject();        
}

    public interface ImageStreamObjectsNested<N> extends Nested<N>, ImageStreamFluent<ImageStreamObjectsNested<N>>{
            public N endImageStreamObject();            public N and();        
}

    public interface BuildRequestObjectsNested<N> extends Nested<N>, BuildRequestFluent<BuildRequestObjectsNested<N>>{
            public N endBuildRequestObject();            public N and();        
}

    public interface ServiceObjectsNested<N> extends Nested<N>, ServiceFluent<ServiceObjectsNested<N>>{
            public N and();            public N endServiceObject();        
}

    public interface BuildObjectsNested<N> extends Nested<N>, BuildFluent<BuildObjectsNested<N>>{
            public N endBuildObject();            public N and();        
}

    public interface DeploymentConfigObjectsNested<N> extends Nested<N>, DeploymentConfigFluent<DeploymentConfigObjectsNested<N>>{
            public N and();            public N endDeploymentConfigObject();        
}

    public interface ClusterRoleBindingObjectsNested<N> extends Nested<N>, ClusterRoleBindingFluent<ClusterRoleBindingObjectsNested<N>>{
            public N endClusterRoleBindingObject();            public N and();        
}

    public interface GroupObjectsNested<N> extends Nested<N>, GroupFluent<GroupObjectsNested<N>>{
            public N and();            public N endGroupObject();        
}

    public interface PersistentVolumeClaimObjectsNested<N> extends Nested<N>, PersistentVolumeClaimFluent<PersistentVolumeClaimObjectsNested<N>>{
            public N endPersistentVolumeClaimObject();            public N and();        
}

    public interface PodObjectsNested<N> extends Nested<N>, PodFluent<PodObjectsNested<N>>{
            public N endPodObject();            public N and();        
}

    public interface PolicyBindingObjectsNested<N> extends Nested<N>, PolicyBindingFluent<PolicyBindingObjectsNested<N>>{
            public N and();            public N endPolicyBindingObject();        
}

    public interface OAuthClientObjectsNested<N> extends Nested<N>, OAuthClientFluent<OAuthClientObjectsNested<N>>{
            public N and();            public N endOAuthClientObject();        
}

    public interface PersistentVolumeObjectsNested<N> extends Nested<N>, PersistentVolumeFluent<PersistentVolumeObjectsNested<N>>{
            public N and();            public N endPersistentVolumeObject();        
}

    public interface EventObjectsNested<N> extends Nested<N>, EventFluent<EventObjectsNested<N>>{
            public N and();            public N endEventObject();        
}

    public interface ProjectRequestObjectsNested<N> extends Nested<N>, ProjectRequestFluent<ProjectRequestObjectsNested<N>>{
            public N endProjectRequestObject();            public N and();        
}

    public interface ResourceQuotaObjectsNested<N> extends Nested<N>, ResourceQuotaFluent<ResourceQuotaObjectsNested<N>>{
            public N endResourceQuotaObject();            public N and();        
}

    public interface ClusterPolicyObjectsNested<N> extends Nested<N>, ClusterPolicyFluent<ClusterPolicyObjectsNested<N>>{
            public N endClusterPolicyObject();            public N and();        
}

    public interface ClusterPolicyBindingObjectsNested<N> extends Nested<N>, ClusterPolicyBindingFluent<ClusterPolicyBindingObjectsNested<N>>{
            public N endClusterPolicyBindingObject();            public N and();        
}

    public interface NamespaceObjectsNested<N> extends Nested<N>, NamespaceFluent<NamespaceObjectsNested<N>>{
            public N endNamespaceObject();            public N and();        
}

    public interface IdentityObjectsNested<N> extends Nested<N>, IdentityFluent<IdentityObjectsNested<N>>{
            public N and();            public N endIdentityObject();        
}

    public interface ParametersNested<N> extends Nested<N>, ParameterFluent<ParametersNested<N>>{
            public N endParameter();            public N and();        
}


}
