package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public class ContextFluentImpl<T extends ContextFluent<T>> extends BaseFluent<T> implements ContextFluent<T>{

     String cluster;     List<VisitableBuilder<NamedExtension, ?>> extensions = new ArrayList();     String namespace;     String user;     Map<String, Object> additionalProperties = new HashMap();
public ContextFluentImpl(){
    
}
public ContextFluentImpl( Context instance ){
    this.withCluster(instance.getCluster()); this.withExtensions(instance.getExtensions()); this.withNamespace(instance.getNamespace()); this.withUser(instance.getUser()); 
}

    public String getCluster(){
    return this.cluster;
    }
    public T withCluster( String cluster){
    this.cluster=cluster; return (T) this;
    }
    public T addToExtensions( NamedExtension ...items){
    for (NamedExtension item : items) {NamedExtensionBuilder builder = new NamedExtensionBuilder(item);_visitables.add(builder);this.extensions.add(builder);} return (T)this;
    }
    public T removeFromExtensions( NamedExtension ...items){
    for (NamedExtension item : items) {NamedExtensionBuilder builder = new NamedExtensionBuilder(item);_visitables.remove(builder);this.extensions.remove(builder);} return (T)this;
    }
    public List<NamedExtension> getExtensions(){
    return build(extensions);
    }
    public T withExtensions( List<NamedExtension> extensions){
    this.extensions.clear();if (extensions != null) {for (NamedExtension item : extensions){this.addToExtensions(item);}} return (T) this;
    }
    public T withExtensions( NamedExtension ...extensions){
    this.extensions.clear(); if (extensions != null) {for (NamedExtension item :extensions){ this.addToExtensions(item);}} return (T) this;
    }
    public ExtensionsNested<T> addNewExtension(){
    return new ExtensionsNestedImpl<T>();
    }
    public ExtensionsNested<T> addNewExtensionLike( NamedExtension item){
    return new ExtensionsNestedImpl<T>(item);
    }
    public String getNamespace(){
    return this.namespace;
    }
    public T withNamespace( String namespace){
    this.namespace=namespace; return (T) this;
    }
    public String getUser(){
    return this.user;
    }
    public T withUser( String user){
    this.user=user; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ContextFluentImpl that = (ContextFluentImpl) o;
if (cluster != null ? !cluster.equals(that.cluster) :that.cluster != null) return false;
if (extensions != null ? !extensions.equals(that.extensions) :that.extensions != null) return false;
if (namespace != null ? !namespace.equals(that.namespace) :that.namespace != null) return false;
if (user != null ? !user.equals(that.user) :that.user != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class ExtensionsNestedImpl<N> extends NamedExtensionFluentImpl<ExtensionsNested<N>> implements ExtensionsNested<N>{

        private final NamedExtensionBuilder builder;
    
             ExtensionsNestedImpl (){
        this.builder = new NamedExtensionBuilder(this);
        }
             ExtensionsNestedImpl ( NamedExtension item){
        this.builder = new NamedExtensionBuilder(this, item);
        }
    
            public N and(){
            return (N) ContextFluentImpl.this.addToExtensions(builder.build());
        }
            public N endExtension(){
            return and();
        }
    
}


}
