package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Builder;

public class FCVolumeSourceBuilder extends FCVolumeSourceFluentImpl<FCVolumeSourceBuilder> implements VisitableBuilder<FCVolumeSource,FCVolumeSourceBuilder>{

     FCVolumeSourceFluent<?> fluent;
public FCVolumeSourceBuilder(){
    this(new FCVolumeSource());
}
public FCVolumeSourceBuilder( FCVolumeSourceFluent<?> fluent ){
    this(fluent, new FCVolumeSource());
}
public FCVolumeSourceBuilder( FCVolumeSourceFluent<?> fluent , FCVolumeSource instance ){
    this.fluent = fluent; fluent.withFsType(instance.getFsType()); fluent.withLun(instance.getLun()); fluent.withReadOnly(instance.getReadOnly()); fluent.withTargetWWNs(instance.getTargetWWNs()); 
}
public FCVolumeSourceBuilder( FCVolumeSource instance ){
    this.fluent = this; this.withFsType(instance.getFsType()); this.withLun(instance.getLun()); this.withReadOnly(instance.getReadOnly()); this.withTargetWWNs(instance.getTargetWWNs()); 
}

public EditableFCVolumeSource build(){
    EditableFCVolumeSource buildable = new EditableFCVolumeSource(fluent.getFsType(),fluent.getLun(),fluent.isReadOnly(),fluent.getTargetWWNs());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
FCVolumeSourceBuilder that = (FCVolumeSourceBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
