package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public class NodeDaemonEndpointsFluentImpl<T extends NodeDaemonEndpointsFluent<T>> extends BaseFluent<T> implements NodeDaemonEndpointsFluent<T>{

     VisitableBuilder<DaemonEndpoint, ?> kubeletEndpoint;     Map<String, Object> additionalProperties = new HashMap();
public NodeDaemonEndpointsFluentImpl(){
    
}
public NodeDaemonEndpointsFluentImpl( NodeDaemonEndpoints instance ){
    this.withKubeletEndpoint(instance.getKubeletEndpoint()); 
}

    public DaemonEndpoint getKubeletEndpoint(){
    return this.kubeletEndpoint!=null?this.kubeletEndpoint.build():null;
    }
    public T withKubeletEndpoint( DaemonEndpoint kubeletEndpoint){
    if (kubeletEndpoint!=null){ this.kubeletEndpoint= new DaemonEndpointBuilder(kubeletEndpoint); _visitables.add(this.kubeletEndpoint);} return (T) this;
    }
    public KubeletEndpointNested<T> withNewKubeletEndpoint(){
    return new KubeletEndpointNestedImpl<T>();
    }
    public KubeletEndpointNested<T> withNewKubeletEndpointLike( DaemonEndpoint item){
    return new KubeletEndpointNestedImpl<T>(item);
    }
    public KubeletEndpointNested<T> editKubeletEndpoint(){
    return withNewKubeletEndpointLike(getKubeletEndpoint());
    }
    public T withNewKubeletEndpoint( Integer Port){
    return withKubeletEndpoint(new DaemonEndpoint(Port));
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
NodeDaemonEndpointsFluentImpl that = (NodeDaemonEndpointsFluentImpl) o;
if (kubeletEndpoint != null ? !kubeletEndpoint.equals(that.kubeletEndpoint) :that.kubeletEndpoint != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class KubeletEndpointNestedImpl<N> extends DaemonEndpointFluentImpl<KubeletEndpointNested<N>> implements KubeletEndpointNested<N>{

        private final DaemonEndpointBuilder builder;
    
             KubeletEndpointNestedImpl (){
        this.builder = new DaemonEndpointBuilder(this);
        }
             KubeletEndpointNestedImpl ( DaemonEndpoint item){
        this.builder = new DaemonEndpointBuilder(this, item);
        }
    
            public N and(){
            return (N) NodeDaemonEndpointsFluentImpl.this.withKubeletEndpoint(builder.build());
        }
            public N endKubeletEndpoint(){
            return and();
        }
    
}


}
