package io.fabric8.kubernetes.api.model.extensions;

import java.util.ArrayList;
import java.util.Map;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class ThirdPartyResourceFluentImpl<T extends ThirdPartyResourceFluent<T>> extends BaseFluent<T> implements ThirdPartyResourceFluent<T>{

     ThirdPartyResource.ApiVersion apiVersion;     String description;     String kind;     VisitableBuilder<ObjectMeta, ?> metadata;     List<VisitableBuilder<APIVersion, ?>> versions = new ArrayList();     Map<String, Object> additionalProperties = new HashMap();
public ThirdPartyResourceFluentImpl(){
    
}
public ThirdPartyResourceFluentImpl( ThirdPartyResource instance ){
    this.withApiVersion(instance.getApiVersion()); this.withDescription(instance.getDescription()); this.withKind(instance.getKind()); this.withMetadata(instance.getMetadata()); this.withVersions(instance.getVersions()); 
}

    public ThirdPartyResource.ApiVersion getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( ThirdPartyResource.ApiVersion apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public String getDescription(){
    return this.description;
    }
    public T withDescription( String description){
    this.description=description; return (T) this;
    }
    public String getKind(){
    return this.kind;
    }
    public T withKind( String kind){
    this.kind=kind; return (T) this;
    }
    public ObjectMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public T withMetadata( ObjectMeta metadata){
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (T) this;
    }
    public MetadataNested<T> withNewMetadata(){
    return new MetadataNestedImpl<T>();
    }
    public MetadataNested<T> withNewMetadataLike( ObjectMeta item){
    return new MetadataNestedImpl<T>(item);
    }
    public MetadataNested<T> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public T addToVersions( APIVersion ...items){
    for (APIVersion item : items) {APIVersionBuilder builder = new APIVersionBuilder(item);_visitables.add(builder);this.versions.add(builder);} return (T)this;
    }
    public T removeFromVersions( APIVersion ...items){
    for (APIVersion item : items) {APIVersionBuilder builder = new APIVersionBuilder(item);_visitables.remove(builder);this.versions.remove(builder);} return (T)this;
    }
    public List<APIVersion> getVersions(){
    return build(versions);
    }
    public T withVersions( List<APIVersion> versions){
    this.versions.clear();if (versions != null) {for (APIVersion item : versions){this.addToVersions(item);}} return (T) this;
    }
    public T withVersions( APIVersion ...versions){
    this.versions.clear(); if (versions != null) {for (APIVersion item :versions){ this.addToVersions(item);}} return (T) this;
    }
    public VersionsNested<T> addNewVersion(){
    return new VersionsNestedImpl<T>();
    }
    public VersionsNested<T> addNewVersionLike( APIVersion item){
    return new VersionsNestedImpl<T>(item);
    }
    public T addNewVersion( String apiGroup,  String name){
    return addToVersions(new APIVersion(apiGroup, name));
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ThirdPartyResourceFluentImpl that = (ThirdPartyResourceFluentImpl) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (description != null ? !description.equals(that.description) :that.description != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
if (versions != null ? !versions.equals(that.versions) :that.versions != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<MetadataNested<N>> implements MetadataNested<N>{

        private final ObjectMetaBuilder builder;
    
             MetadataNestedImpl (){
        this.builder = new ObjectMetaBuilder(this);
        }
             MetadataNestedImpl ( ObjectMeta item){
        this.builder = new ObjectMetaBuilder(this, item);
        }
    
            public N and(){
            return (N) ThirdPartyResourceFluentImpl.this.withMetadata(builder.build());
        }
            public N endMetadata(){
            return and();
        }
    
}
    public class VersionsNestedImpl<N> extends APIVersionFluentImpl<VersionsNested<N>> implements VersionsNested<N>{

        private final APIVersionBuilder builder;
    
             VersionsNestedImpl (){
        this.builder = new APIVersionBuilder(this);
        }
             VersionsNestedImpl ( APIVersion item){
        this.builder = new APIVersionBuilder(this, item);
        }
    
            public N and(){
            return (N) ThirdPartyResourceFluentImpl.this.addToVersions(builder.build());
        }
            public N endVersion(){
            return and();
        }
    
}


}
