/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.AuthInfo;
import io.fabric8.kubernetes.api.model.AuthInfoBuilder;
import io.fabric8.kubernetes.api.model.AuthInfoFluentImpl;
import io.fabric8.kubernetes.api.model.NamedAuthInfo;
import io.fabric8.kubernetes.api.model.NamedAuthInfoFluent;
import java.util.HashMap;
import java.util.Map;

public class NamedAuthInfoFluentImpl<T extends NamedAuthInfoFluent<T>>
extends BaseFluent<T>
implements NamedAuthInfoFluent<T> {
    String name;
    VisitableBuilder<AuthInfo, ?> user;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public NamedAuthInfoFluentImpl() {
    }

    public NamedAuthInfoFluentImpl(NamedAuthInfo instance) {
        this.withName(instance.getName());
        this.withUser(instance.getUser());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public T withName(String name) {
        this.name = name;
        return (T)this;
    }

    @Override
    public AuthInfo getUser() {
        return this.user != null ? (AuthInfo)this.user.build() : null;
    }

    @Override
    public T withUser(AuthInfo user) {
        if (user != null) {
            this.user = new AuthInfoBuilder(user);
            this._visitables.add(this.user);
        }
        return (T)this;
    }

    @Override
    public NamedAuthInfoFluent.UserNested<T> withNewUser() {
        return new UserNestedImpl();
    }

    @Override
    public NamedAuthInfoFluent.UserNested<T> withNewUserLike(AuthInfo item) {
        return new UserNestedImpl(item);
    }

    @Override
    public NamedAuthInfoFluent.UserNested<T> editUser() {
        return this.withNewUserLike(this.getUser());
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NamedAuthInfoFluentImpl that = (NamedAuthInfoFluentImpl)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.user != null ? !this.user.equals(that.user) : that.user != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class UserNestedImpl<N>
    extends AuthInfoFluentImpl<NamedAuthInfoFluent.UserNested<N>>
    implements NamedAuthInfoFluent.UserNested<N> {
        private final AuthInfoBuilder builder;

        UserNestedImpl(AuthInfo item) {
            this.builder = new AuthInfoBuilder(this, item);
        }

        UserNestedImpl() {
            this.builder = new AuthInfoBuilder(this);
        }

        @Override
        public N and() {
            return (N)NamedAuthInfoFluentImpl.this.withUser(this.builder.build());
        }

        @Override
        public N endUser() {
            return this.and();
        }
    }
}

