package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;

public class GitRepoVolumeSourceFluentImpl<T extends GitRepoVolumeSourceFluent<T>> extends BaseFluent<T> implements GitRepoVolumeSourceFluent<T>{

     String repository;     String revision;     Map<String, Object> additionalProperties = new HashMap();
public GitRepoVolumeSourceFluentImpl(){
    
}
public GitRepoVolumeSourceFluentImpl( GitRepoVolumeSource instance ){
    this.withRepository(instance.getRepository()); this.withRevision(instance.getRevision()); 
}

    public String getRepository(){
    return this.repository;
    }
    public T withRepository( String repository){
    this.repository=repository; return (T) this;
    }
    public String getRevision(){
    return this.revision;
    }
    public T withRevision( String revision){
    this.revision=revision; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
GitRepoVolumeSourceFluentImpl that = (GitRepoVolumeSourceFluentImpl) o;
if (repository != null ? !repository.equals(that.repository) :that.repository != null) return false;
if (revision != null ? !revision.equals(that.revision) :that.revision != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }



}
