package io.fabric8.openshift.api.model;

import java.util.Map;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface BuildRequestFluent<T extends BuildRequestFluent<T>> extends Fluent<T>{


    public BuildRequest.ApiVersion getApiVersion();    public T withApiVersion( BuildRequest.ApiVersion apiVersion);    public BinaryBuildSource getBinary();    public T withBinary( BinaryBuildSource binary);    public BinaryNested<T> withNewBinary();    public BinaryNested<T> withNewBinaryLike( BinaryBuildSource item);    public BinaryNested<T> editBinary();    public T withNewBinary( String asFile);    public ObjectReference getFrom();    public T withFrom( ObjectReference from);    public FromNested<T> withNewFrom();    public FromNested<T> withNewFromLike( ObjectReference item);    public FromNested<T> editFrom();    public String getKind();    public T withKind( String kind);    public Integer getLastVersion();    public T withLastVersion( Integer lastVersion);    public ObjectMeta getMetadata();    public T withMetadata( ObjectMeta metadata);    public MetadataNested<T> withNewMetadata();    public MetadataNested<T> withNewMetadataLike( ObjectMeta item);    public MetadataNested<T> editMetadata();    public SourceRevision getRevision();    public T withRevision( SourceRevision revision);    public RevisionNested<T> withNewRevision();    public RevisionNested<T> withNewRevisionLike( SourceRevision item);    public RevisionNested<T> editRevision();    public ObjectReference getTriggeredByImage();    public T withTriggeredByImage( ObjectReference triggeredByImage);    public TriggeredByImageNested<T> withNewTriggeredByImage();    public TriggeredByImageNested<T> withNewTriggeredByImageLike( ObjectReference item);    public TriggeredByImageNested<T> editTriggeredByImage();    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface BinaryNested<N> extends Nested<N>, BinaryBuildSourceFluent<BinaryNested<N>>{
            public N and();            public N endBinary();        
}

    public interface FromNested<N> extends Nested<N>, ObjectReferenceFluent<FromNested<N>>{
            public N endFrom();            public N and();        
}

    public interface MetadataNested<N> extends Nested<N>, ObjectMetaFluent<MetadataNested<N>>{
            public N and();            public N endMetadata();        
}

    public interface RevisionNested<N> extends Nested<N>, SourceRevisionFluent<RevisionNested<N>>{
            public N endRevision();            public N and();        
}

    public interface TriggeredByImageNested<N> extends Nested<N>, ObjectReferenceFluent<TriggeredByImageNested<N>>{
            public N and();            public N endTriggeredByImage();        
}


}
