package io.fabric8.openshift.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public class SourceRevisionFluentImpl<T extends SourceRevisionFluent<T>> extends BaseFluent<T> implements SourceRevisionFluent<T>{

     VisitableBuilder<GitSourceRevision, ?> git;     String type;     Map<String, Object> additionalProperties = new HashMap();
public SourceRevisionFluentImpl(){
    
}
public SourceRevisionFluentImpl( SourceRevision instance ){
    this.withGit(instance.getGit()); this.withType(instance.getType()); 
}

    public GitSourceRevision getGit(){
    return this.git!=null?this.git.build():null;
    }
    public T withGit( GitSourceRevision git){
    if (git!=null){ this.git= new GitSourceRevisionBuilder(git); _visitables.add(this.git);} return (T) this;
    }
    public GitNested<T> withNewGit(){
    return new GitNestedImpl<T>();
    }
    public GitNested<T> withNewGitLike( GitSourceRevision item){
    return new GitNestedImpl<T>(item);
    }
    public GitNested<T> editGit(){
    return withNewGitLike(getGit());
    }
    public String getType(){
    return this.type;
    }
    public T withType( String type){
    this.type=type; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
SourceRevisionFluentImpl that = (SourceRevisionFluentImpl) o;
if (git != null ? !git.equals(that.git) :that.git != null) return false;
if (type != null ? !type.equals(that.type) :that.type != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class GitNestedImpl<N> extends GitSourceRevisionFluentImpl<GitNested<N>> implements GitNested<N>{

        private final GitSourceRevisionBuilder builder;
    
             GitNestedImpl (){
        this.builder = new GitSourceRevisionBuilder(this);
        }
             GitNestedImpl ( GitSourceRevision item){
        this.builder = new GitSourceRevisionBuilder(this, item);
        }
    
            public N and(){
            return (N) SourceRevisionFluentImpl.this.withGit(builder.build());
        }
            public N endGit(){
            return and();
        }
    
}


}
