package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class PodSpecFluentImpl<T extends PodSpecFluent<T>> extends BaseFluent<T> implements PodSpecFluent<T>{

     Long activeDeadlineSeconds;     List<VisitableBuilder<Container, ?>> containers = new ArrayList();     String dnsPolicy;     String host;     Boolean hostIPC;     Boolean hostNetwork;     Boolean hostPID;     List<VisitableBuilder<LocalObjectReference, ?>> imagePullSecrets = new ArrayList();     String nodeName;     Map<String, String> nodeSelector = new HashMap();     String restartPolicy;     VisitableBuilder<PodSecurityContext, ?> securityContext;     String serviceAccount;     String serviceAccountName;     Long terminationGracePeriodSeconds;     List<VisitableBuilder<Volume, ?>> volumes = new ArrayList();     Map<String, Object> additionalProperties = new HashMap();
public PodSpecFluentImpl(){
    
}
public PodSpecFluentImpl( PodSpec instance ){
    this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds()); this.withContainers(instance.getContainers()); this.withDnsPolicy(instance.getDnsPolicy()); this.withHost(instance.getHost()); this.withHostIPC(instance.getHostIPC()); this.withHostNetwork(instance.getHostNetwork()); this.withHostPID(instance.getHostPID()); this.withImagePullSecrets(instance.getImagePullSecrets()); this.withNodeName(instance.getNodeName()); this.withNodeSelector(instance.getNodeSelector()); this.withRestartPolicy(instance.getRestartPolicy()); this.withSecurityContext(instance.getSecurityContext()); this.withServiceAccount(instance.getServiceAccount()); this.withServiceAccountName(instance.getServiceAccountName()); this.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds()); this.withVolumes(instance.getVolumes()); 
}

    public Long getActiveDeadlineSeconds(){
    return this.activeDeadlineSeconds;
    }
    public T withActiveDeadlineSeconds( Long activeDeadlineSeconds){
    this.activeDeadlineSeconds=activeDeadlineSeconds; return (T) this;
    }
    public T addToContainers( Container ...items){
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.add(builder);this.containers.add(builder);} return (T)this;
    }
    public T removeFromContainers( Container ...items){
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.remove(builder);this.containers.remove(builder);} return (T)this;
    }
    public List<Container> getContainers(){
    return build(containers);
    }
    public T withContainers( List<Container> containers){
    this.containers.clear();if (containers != null) {for (Container item : containers){this.addToContainers(item);}} return (T) this;
    }
    public T withContainers( Container ...containers){
    this.containers.clear(); if (containers != null) {for (Container item :containers){ this.addToContainers(item);}} return (T) this;
    }
    public ContainersNested<T> addNewContainer(){
    return new ContainersNestedImpl<T>();
    }
    public ContainersNested<T> addNewContainerLike( Container item){
    return new ContainersNestedImpl<T>(item);
    }
    public String getDnsPolicy(){
    return this.dnsPolicy;
    }
    public T withDnsPolicy( String dnsPolicy){
    this.dnsPolicy=dnsPolicy; return (T) this;
    }
    public String getHost(){
    return this.host;
    }
    public T withHost( String host){
    this.host=host; return (T) this;
    }
    public Boolean isHostIPC(){
    return this.hostIPC;
    }
    public T withHostIPC( Boolean hostIPC){
    this.hostIPC=hostIPC; return (T) this;
    }
    public Boolean isHostNetwork(){
    return this.hostNetwork;
    }
    public T withHostNetwork( Boolean hostNetwork){
    this.hostNetwork=hostNetwork; return (T) this;
    }
    public Boolean isHostPID(){
    return this.hostPID;
    }
    public T withHostPID( Boolean hostPID){
    this.hostPID=hostPID; return (T) this;
    }
    public T addToImagePullSecrets( LocalObjectReference ...items){
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.add(builder);this.imagePullSecrets.add(builder);} return (T)this;
    }
    public T removeFromImagePullSecrets( LocalObjectReference ...items){
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.remove(builder);this.imagePullSecrets.remove(builder);} return (T)this;
    }
    public List<LocalObjectReference> getImagePullSecrets(){
    return build(imagePullSecrets);
    }
    public T withImagePullSecrets( List<LocalObjectReference> imagePullSecrets){
    this.imagePullSecrets.clear();if (imagePullSecrets != null) {for (LocalObjectReference item : imagePullSecrets){this.addToImagePullSecrets(item);}} return (T) this;
    }
    public T withImagePullSecrets( LocalObjectReference ...imagePullSecrets){
    this.imagePullSecrets.clear(); if (imagePullSecrets != null) {for (LocalObjectReference item :imagePullSecrets){ this.addToImagePullSecrets(item);}} return (T) this;
    }
    public ImagePullSecretsNested<T> addNewImagePullSecret(){
    return new ImagePullSecretsNestedImpl<T>();
    }
    public ImagePullSecretsNested<T> addNewImagePullSecretLike( LocalObjectReference item){
    return new ImagePullSecretsNestedImpl<T>(item);
    }
    public T addNewImagePullSecret( String name){
    return addToImagePullSecrets(new LocalObjectReference(name));
    }
    public String getNodeName(){
    return this.nodeName;
    }
    public T withNodeName( String nodeName){
    this.nodeName=nodeName; return (T) this;
    }
    public T addToNodeSelector( String key,  String value){
    if(key != null && value != null) {this.nodeSelector.put(key, value);} return (T)this;
    }
    public T addToNodeSelector( Map<String, String> map){
    if(map != null) { this.nodeSelector.putAll(map);} return (T)this;
    }
    public T removeFromNodeSelector( String key){
    if(key != null) {this.nodeSelector.remove(key);} return (T)this;
    }
    public T removeFromNodeSelector( Map<String, String> map){
    if(map != null) { for(Object key : map.keySet()) {this.nodeSelector.remove(key);}} return (T)this;
    }
    public Map<String, String> getNodeSelector(){
    return this.nodeSelector;
    }
    public T withNodeSelector( Map<String, String> nodeSelector){
    this.nodeSelector.clear();if (nodeSelector != null) {this.nodeSelector.putAll(nodeSelector);} return (T) this;
    }
    public String getRestartPolicy(){
    return this.restartPolicy;
    }
    public T withRestartPolicy( String restartPolicy){
    this.restartPolicy=restartPolicy; return (T) this;
    }
    public PodSecurityContext getSecurityContext(){
    return this.securityContext!=null?this.securityContext.build():null;
    }
    public T withSecurityContext( PodSecurityContext securityContext){
    if (securityContext!=null){ this.securityContext= new PodSecurityContextBuilder(securityContext); _visitables.add(this.securityContext);} return (T) this;
    }
    public SecurityContextNested<T> withNewSecurityContext(){
    return new SecurityContextNestedImpl<T>();
    }
    public SecurityContextNested<T> withNewSecurityContextLike( PodSecurityContext item){
    return new SecurityContextNestedImpl<T>(item);
    }
    public SecurityContextNested<T> editSecurityContext(){
    return withNewSecurityContextLike(getSecurityContext());
    }
    public String getServiceAccount(){
    return this.serviceAccount;
    }
    public T withServiceAccount( String serviceAccount){
    this.serviceAccount=serviceAccount; return (T) this;
    }
    public String getServiceAccountName(){
    return this.serviceAccountName;
    }
    public T withServiceAccountName( String serviceAccountName){
    this.serviceAccountName=serviceAccountName; return (T) this;
    }
    public Long getTerminationGracePeriodSeconds(){
    return this.terminationGracePeriodSeconds;
    }
    public T withTerminationGracePeriodSeconds( Long terminationGracePeriodSeconds){
    this.terminationGracePeriodSeconds=terminationGracePeriodSeconds; return (T) this;
    }
    public T addToVolumes( Volume ...items){
    for (Volume item : items) {VolumeBuilder builder = new VolumeBuilder(item);_visitables.add(builder);this.volumes.add(builder);} return (T)this;
    }
    public T removeFromVolumes( Volume ...items){
    for (Volume item : items) {VolumeBuilder builder = new VolumeBuilder(item);_visitables.remove(builder);this.volumes.remove(builder);} return (T)this;
    }
    public List<Volume> getVolumes(){
    return build(volumes);
    }
    public T withVolumes( List<Volume> volumes){
    this.volumes.clear();if (volumes != null) {for (Volume item : volumes){this.addToVolumes(item);}} return (T) this;
    }
    public T withVolumes( Volume ...volumes){
    this.volumes.clear(); if (volumes != null) {for (Volume item :volumes){ this.addToVolumes(item);}} return (T) this;
    }
    public VolumesNested<T> addNewVolume(){
    return new VolumesNestedImpl<T>();
    }
    public VolumesNested<T> addNewVolumeLike( Volume item){
    return new VolumesNestedImpl<T>(item);
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
PodSpecFluentImpl that = (PodSpecFluentImpl) o;
if (activeDeadlineSeconds != null ? !activeDeadlineSeconds.equals(that.activeDeadlineSeconds) :that.activeDeadlineSeconds != null) return false;
if (containers != null ? !containers.equals(that.containers) :that.containers != null) return false;
if (dnsPolicy != null ? !dnsPolicy.equals(that.dnsPolicy) :that.dnsPolicy != null) return false;
if (host != null ? !host.equals(that.host) :that.host != null) return false;
if (hostIPC != null ? !hostIPC.equals(that.hostIPC) :that.hostIPC != null) return false;
if (hostNetwork != null ? !hostNetwork.equals(that.hostNetwork) :that.hostNetwork != null) return false;
if (hostPID != null ? !hostPID.equals(that.hostPID) :that.hostPID != null) return false;
if (imagePullSecrets != null ? !imagePullSecrets.equals(that.imagePullSecrets) :that.imagePullSecrets != null) return false;
if (nodeName != null ? !nodeName.equals(that.nodeName) :that.nodeName != null) return false;
if (nodeSelector != null ? !nodeSelector.equals(that.nodeSelector) :that.nodeSelector != null) return false;
if (restartPolicy != null ? !restartPolicy.equals(that.restartPolicy) :that.restartPolicy != null) return false;
if (securityContext != null ? !securityContext.equals(that.securityContext) :that.securityContext != null) return false;
if (serviceAccount != null ? !serviceAccount.equals(that.serviceAccount) :that.serviceAccount != null) return false;
if (serviceAccountName != null ? !serviceAccountName.equals(that.serviceAccountName) :that.serviceAccountName != null) return false;
if (terminationGracePeriodSeconds != null ? !terminationGracePeriodSeconds.equals(that.terminationGracePeriodSeconds) :that.terminationGracePeriodSeconds != null) return false;
if (volumes != null ? !volumes.equals(that.volumes) :that.volumes != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class ContainersNestedImpl<N> extends ContainerFluentImpl<ContainersNested<N>> implements ContainersNested<N>{

        private final ContainerBuilder builder;
    
             ContainersNestedImpl (){
        this.builder = new ContainerBuilder(this);
        }
             ContainersNestedImpl ( Container item){
        this.builder = new ContainerBuilder(this, item);
        }
    
            public N and(){
            return (N) PodSpecFluentImpl.this.addToContainers(builder.build());
        }
            public N endContainer(){
            return and();
        }
    
}
    public class ImagePullSecretsNestedImpl<N> extends LocalObjectReferenceFluentImpl<ImagePullSecretsNested<N>> implements ImagePullSecretsNested<N>{

        private final LocalObjectReferenceBuilder builder;
    
             ImagePullSecretsNestedImpl (){
        this.builder = new LocalObjectReferenceBuilder(this);
        }
             ImagePullSecretsNestedImpl ( LocalObjectReference item){
        this.builder = new LocalObjectReferenceBuilder(this, item);
        }
    
            public N and(){
            return (N) PodSpecFluentImpl.this.addToImagePullSecrets(builder.build());
        }
            public N endImagePullSecret(){
            return and();
        }
    
}
    public class SecurityContextNestedImpl<N> extends PodSecurityContextFluentImpl<SecurityContextNested<N>> implements SecurityContextNested<N>{

        private final PodSecurityContextBuilder builder;
    
             SecurityContextNestedImpl ( PodSecurityContext item){
        this.builder = new PodSecurityContextBuilder(this, item);
        }
             SecurityContextNestedImpl (){
        this.builder = new PodSecurityContextBuilder(this);
        }
    
            public N and(){
            return (N) PodSpecFluentImpl.this.withSecurityContext(builder.build());
        }
            public N endSecurityContext(){
            return and();
        }
    
}
    public class VolumesNestedImpl<N> extends VolumeFluentImpl<VolumesNested<N>> implements VolumesNested<N>{

        private final VolumeBuilder builder;
    
             VolumesNestedImpl (){
        this.builder = new VolumeBuilder(this);
        }
             VolumesNestedImpl ( Volume item){
        this.builder = new VolumeBuilder(this, item);
        }
    
            public N and(){
            return (N) PodSpecFluentImpl.this.addToVolumes(builder.build());
        }
            public N endVolume(){
            return and();
        }
    
}


}
