package io.fabric8.kubernetes.api.model.extensions;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Builder;

public class PodSelectorBuilder extends PodSelectorFluentImpl<PodSelectorBuilder> implements VisitableBuilder<PodSelector,PodSelectorBuilder>{

     PodSelectorFluent<?> fluent;
public PodSelectorBuilder(){
    this(new PodSelector());
}
public PodSelectorBuilder( PodSelectorFluent<?> fluent ){
    this(fluent, new PodSelector());
}
public PodSelectorBuilder( PodSelectorFluent<?> fluent , PodSelector instance ){
    this.fluent = fluent; fluent.withMatchExpressions(instance.getMatchExpressions()); fluent.withMatchLabels(instance.getMatchLabels()); 
}
public PodSelectorBuilder( PodSelector instance ){
    this.fluent = this; this.withMatchExpressions(instance.getMatchExpressions()); this.withMatchLabels(instance.getMatchLabels()); 
}

public EditablePodSelector build(){
    EditablePodSelector buildable = new EditablePodSelector(fluent.getMatchExpressions(),fluent.getMatchLabels());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
PodSelectorBuilder that = (PodSelectorBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
