package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Builder;

public class ParameterBuilder extends ParameterFluentImpl<ParameterBuilder> implements VisitableBuilder<Parameter,ParameterBuilder>{

     ParameterFluent<?> fluent;
public ParameterBuilder(){
    this(new Parameter());
}
public ParameterBuilder( ParameterFluent<?> fluent ){
    this(fluent, new Parameter());
}
public ParameterBuilder( ParameterFluent<?> fluent , Parameter instance ){
    this.fluent = fluent; fluent.withDescription(instance.getDescription()); fluent.withDisplayName(instance.getDisplayName()); fluent.withFrom(instance.getFrom()); fluent.withGenerate(instance.getGenerate()); fluent.withName(instance.getName()); fluent.withRequired(instance.getRequired()); fluent.withValue(instance.getValue()); 
}
public ParameterBuilder( Parameter instance ){
    this.fluent = this; this.withDescription(instance.getDescription()); this.withDisplayName(instance.getDisplayName()); this.withFrom(instance.getFrom()); this.withGenerate(instance.getGenerate()); this.withName(instance.getName()); this.withRequired(instance.getRequired()); this.withValue(instance.getValue()); 
}

public EditableParameter build(){
    EditableParameter buildable = new EditableParameter(fluent.getDescription(),fluent.getDisplayName(),fluent.getFrom(),fluent.getGenerate(),fluent.getName(),fluent.isRequired(),fluent.getValue());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
ParameterBuilder that = (ParameterBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
