package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.util.List;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.EnvVarFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.EnvVarFluentImpl;

public class DockerBuildStrategyFluentImpl<T extends DockerBuildStrategyFluent<T>> extends BaseFluent<T> implements DockerBuildStrategyFluent<T>{

     List<VisitableBuilder<EnvVar, ?>> env = new ArrayList();     Boolean forcePull;     VisitableBuilder<ObjectReference, ?> from;     Boolean noCache;     VisitableBuilder<LocalObjectReference, ?> pullSecret;     Map<String, Object> additionalProperties = new HashMap();
public DockerBuildStrategyFluentImpl(){
    
}
public DockerBuildStrategyFluentImpl( DockerBuildStrategy instance ){
    this.withEnv(instance.getEnv()); this.withForcePull(instance.getForcePull()); this.withFrom(instance.getFrom()); this.withNoCache(instance.getNoCache()); this.withPullSecret(instance.getPullSecret()); 
}

    public T addToEnv( EnvVar ...items){
    for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.add(builder);this.env.add(builder);} return (T)this;
    }
    public T removeFromEnv( EnvVar ...items){
    for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.remove(builder);this.env.remove(builder);} return (T)this;
    }
    public List<EnvVar> getEnv(){
    return build(env);
    }
    public T withEnv( List<EnvVar> env){
    this.env.clear();if (env != null) {for (EnvVar item : env){this.addToEnv(item);}} return (T) this;
    }
    public T withEnv( EnvVar ...env){
    this.env.clear(); if (env != null) {for (EnvVar item :env){ this.addToEnv(item);}} return (T) this;
    }
    public EnvNested<T> addNewEnv(){
    return new EnvNestedImpl<T>();
    }
    public EnvNested<T> addNewEnvLike( EnvVar item){
    return new EnvNestedImpl<T>(item);
    }
    public Boolean isForcePull(){
    return this.forcePull;
    }
    public T withForcePull( Boolean forcePull){
    this.forcePull=forcePull; return (T) this;
    }
    public ObjectReference getFrom(){
    return this.from!=null?this.from.build():null;
    }
    public T withFrom( ObjectReference from){
    if (from!=null){ this.from= new ObjectReferenceBuilder(from); _visitables.add(this.from);} return (T) this;
    }
    public FromNested<T> withNewFrom(){
    return new FromNestedImpl<T>();
    }
    public FromNested<T> withNewFromLike( ObjectReference item){
    return new FromNestedImpl<T>(item);
    }
    public FromNested<T> editFrom(){
    return withNewFromLike(getFrom());
    }
    public Boolean isNoCache(){
    return this.noCache;
    }
    public T withNoCache( Boolean noCache){
    this.noCache=noCache; return (T) this;
    }
    public LocalObjectReference getPullSecret(){
    return this.pullSecret!=null?this.pullSecret.build():null;
    }
    public T withPullSecret( LocalObjectReference pullSecret){
    if (pullSecret!=null){ this.pullSecret= new LocalObjectReferenceBuilder(pullSecret); _visitables.add(this.pullSecret);} return (T) this;
    }
    public PullSecretNested<T> withNewPullSecret(){
    return new PullSecretNestedImpl<T>();
    }
    public PullSecretNested<T> withNewPullSecretLike( LocalObjectReference item){
    return new PullSecretNestedImpl<T>(item);
    }
    public PullSecretNested<T> editPullSecret(){
    return withNewPullSecretLike(getPullSecret());
    }
    public T withNewPullSecret( String name){
    return withPullSecret(new LocalObjectReference(name));
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
DockerBuildStrategyFluentImpl that = (DockerBuildStrategyFluentImpl) o;
if (env != null ? !env.equals(that.env) :that.env != null) return false;
if (forcePull != null ? !forcePull.equals(that.forcePull) :that.forcePull != null) return false;
if (from != null ? !from.equals(that.from) :that.from != null) return false;
if (noCache != null ? !noCache.equals(that.noCache) :that.noCache != null) return false;
if (pullSecret != null ? !pullSecret.equals(that.pullSecret) :that.pullSecret != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class EnvNestedImpl<N> extends EnvVarFluentImpl<EnvNested<N>> implements EnvNested<N>{

        private final EnvVarBuilder builder;
    
             EnvNestedImpl ( EnvVar item){
        this.builder = new EnvVarBuilder(this, item);
        }
             EnvNestedImpl (){
        this.builder = new EnvVarBuilder(this);
        }
    
            public N endEnv(){
            return and();
        }
            public N and(){
            return (N) DockerBuildStrategyFluentImpl.this.addToEnv(builder.build());
        }
    
}
    public class FromNestedImpl<N> extends ObjectReferenceFluentImpl<FromNested<N>> implements FromNested<N>{

        private final ObjectReferenceBuilder builder;
    
             FromNestedImpl (){
        this.builder = new ObjectReferenceBuilder(this);
        }
             FromNestedImpl ( ObjectReference item){
        this.builder = new ObjectReferenceBuilder(this, item);
        }
    
            public N endFrom(){
            return and();
        }
            public N and(){
            return (N) DockerBuildStrategyFluentImpl.this.withFrom(builder.build());
        }
    
}
    public class PullSecretNestedImpl<N> extends LocalObjectReferenceFluentImpl<PullSecretNested<N>> implements PullSecretNested<N>{

        private final LocalObjectReferenceBuilder builder;
    
             PullSecretNestedImpl ( LocalObjectReference item){
        this.builder = new LocalObjectReferenceBuilder(this, item);
        }
             PullSecretNestedImpl (){
        this.builder = new LocalObjectReferenceBuilder(this);
        }
    
            public N and(){
            return (N) DockerBuildStrategyFluentImpl.this.withPullSecret(builder.build());
        }
            public N endPullSecret(){
            return and();
        }
    
}


}
