package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public class LimitRangeSpecFluentImpl<T extends LimitRangeSpecFluent<T>> extends BaseFluent<T> implements LimitRangeSpecFluent<T>{

     List<VisitableBuilder<LimitRangeItem, ?>> limits = new ArrayList();     Map<String, Object> additionalProperties = new HashMap();
public LimitRangeSpecFluentImpl(){
    
}
public LimitRangeSpecFluentImpl( LimitRangeSpec instance ){
    this.withLimits(instance.getLimits()); 
}

    public T addToLimits( LimitRangeItem ...items){
    for (LimitRangeItem item : items) {LimitRangeItemBuilder builder = new LimitRangeItemBuilder(item);_visitables.add(builder);this.limits.add(builder);} return (T)this;
    }
    public T removeFromLimits( LimitRangeItem ...items){
    for (LimitRangeItem item : items) {LimitRangeItemBuilder builder = new LimitRangeItemBuilder(item);_visitables.remove(builder);this.limits.remove(builder);} return (T)this;
    }
    public List<LimitRangeItem> getLimits(){
    return build(limits);
    }
    public T withLimits( List<LimitRangeItem> limits){
    this.limits.clear();if (limits != null) {for (LimitRangeItem item : limits){this.addToLimits(item);}} return (T) this;
    }
    public T withLimits( LimitRangeItem ...limits){
    this.limits.clear(); if (limits != null) {for (LimitRangeItem item :limits){ this.addToLimits(item);}} return (T) this;
    }
    public LimitsNested<T> addNewLimit(){
    return new LimitsNestedImpl<T>();
    }
    public LimitsNested<T> addNewLimitLike( LimitRangeItem item){
    return new LimitsNestedImpl<T>(item);
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
LimitRangeSpecFluentImpl that = (LimitRangeSpecFluentImpl) o;
if (limits != null ? !limits.equals(that.limits) :that.limits != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class LimitsNestedImpl<N> extends LimitRangeItemFluentImpl<LimitsNested<N>> implements LimitsNested<N>{

        private final LimitRangeItemBuilder builder;
    
             LimitsNestedImpl (){
        this.builder = new LimitRangeItemBuilder(this);
        }
             LimitsNestedImpl ( LimitRangeItem item){
        this.builder = new LimitRangeItemBuilder(this, item);
        }
    
            public N and(){
            return (N) LimitRangeSpecFluentImpl.this.addToLimits(builder.build());
        }
            public N endLimit(){
            return and();
        }
    
}


}
