package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.model.IntOrString;
import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.IntOrStringFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.IntOrStringFluentImpl;
import io.fabric8.kubernetes.api.builder.Fluent;

public class RollingUpdateDeploymentFluentImpl<T extends RollingUpdateDeploymentFluent<T>> extends BaseFluent<T> implements RollingUpdateDeploymentFluent<T>{

     VisitableBuilder<IntOrString, ?> maxSurge;     VisitableBuilder<IntOrString, ?> maxUnavailable;     Integer minReadySeconds;     Map<String, Object> additionalProperties = new HashMap();
public RollingUpdateDeploymentFluentImpl(){
    
}
public RollingUpdateDeploymentFluentImpl( RollingUpdateDeployment instance ){
    this.withMaxSurge(instance.getMaxSurge()); this.withMaxUnavailable(instance.getMaxUnavailable()); this.withMinReadySeconds(instance.getMinReadySeconds()); 
}

    public IntOrString getMaxSurge(){
    return this.maxSurge!=null?this.maxSurge.build():null;
    }
    public T withMaxSurge( IntOrString maxSurge){
    if (maxSurge!=null){ this.maxSurge= new IntOrStringBuilder(maxSurge); _visitables.add(this.maxSurge);} return (T) this;
    }
    public MaxSurgeNested<T> withNewMaxSurge(){
    return new MaxSurgeNestedImpl<T>();
    }
    public MaxSurgeNested<T> withNewMaxSurgeLike( IntOrString item){
    return new MaxSurgeNestedImpl<T>(item);
    }
    public MaxSurgeNested<T> editMaxSurge(){
    return withNewMaxSurgeLike(getMaxSurge());
    }
    public T withNewMaxSurge( Integer intVal){
    return withMaxSurge(new IntOrString(intVal));
    }
    public T withNewMaxSurge( String strVal){
    return withMaxSurge(new IntOrString(strVal));
    }
    public IntOrString getMaxUnavailable(){
    return this.maxUnavailable!=null?this.maxUnavailable.build():null;
    }
    public T withMaxUnavailable( IntOrString maxUnavailable){
    if (maxUnavailable!=null){ this.maxUnavailable= new IntOrStringBuilder(maxUnavailable); _visitables.add(this.maxUnavailable);} return (T) this;
    }
    public MaxUnavailableNested<T> withNewMaxUnavailable(){
    return new MaxUnavailableNestedImpl<T>();
    }
    public MaxUnavailableNested<T> withNewMaxUnavailableLike( IntOrString item){
    return new MaxUnavailableNestedImpl<T>(item);
    }
    public MaxUnavailableNested<T> editMaxUnavailable(){
    return withNewMaxUnavailableLike(getMaxUnavailable());
    }
    public T withNewMaxUnavailable( Integer intVal){
    return withMaxUnavailable(new IntOrString(intVal));
    }
    public T withNewMaxUnavailable( String strVal){
    return withMaxUnavailable(new IntOrString(strVal));
    }
    public Integer getMinReadySeconds(){
    return this.minReadySeconds;
    }
    public T withMinReadySeconds( Integer minReadySeconds){
    this.minReadySeconds=minReadySeconds; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
RollingUpdateDeploymentFluentImpl that = (RollingUpdateDeploymentFluentImpl) o;
if (maxSurge != null ? !maxSurge.equals(that.maxSurge) :that.maxSurge != null) return false;
if (maxUnavailable != null ? !maxUnavailable.equals(that.maxUnavailable) :that.maxUnavailable != null) return false;
if (minReadySeconds != null ? !minReadySeconds.equals(that.minReadySeconds) :that.minReadySeconds != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class MaxSurgeNestedImpl<N> extends IntOrStringFluentImpl<MaxSurgeNested<N>> implements MaxSurgeNested<N>{

        private final IntOrStringBuilder builder;
    
             MaxSurgeNestedImpl (){
        this.builder = new IntOrStringBuilder(this);
        }
             MaxSurgeNestedImpl ( IntOrString item){
        this.builder = new IntOrStringBuilder(this, item);
        }
    
            public N and(){
            return (N) RollingUpdateDeploymentFluentImpl.this.withMaxSurge(builder.build());
        }
            public N endMaxSurge(){
            return and();
        }
    
}
    public class MaxUnavailableNestedImpl<N> extends IntOrStringFluentImpl<MaxUnavailableNested<N>> implements MaxUnavailableNested<N>{

        private final IntOrStringBuilder builder;
    
             MaxUnavailableNestedImpl (){
        this.builder = new IntOrStringBuilder(this);
        }
             MaxUnavailableNestedImpl ( IntOrString item){
        this.builder = new IntOrStringBuilder(this, item);
        }
    
            public N endMaxUnavailable(){
            return and();
        }
            public N and(){
            return (N) RollingUpdateDeploymentFluentImpl.this.withMaxUnavailable(builder.build());
        }
    
}


}
