package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.HasMetadata;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.TypeMeta;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.TypeMetaFluent;
import io.fabric8.kubernetes.api.model.TypeMetaBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.TypeMetaFluentImpl;
import io.fabric8.kubernetes.api.builder.Fluent;

public class LocalSubjectAccessReviewFluentImpl<T extends LocalSubjectAccessReviewFluent<T>> extends BaseFluent<T> implements LocalSubjectAccessReviewFluent<T>{

     VisitableBuilder<TypeMeta, ?> TypeMeta;     HasMetadata content;     List<String> groups = new ArrayList();     String namespace;     String resource;     String resourceName;     String user;     String verb;     Map<String, Object> additionalProperties = new HashMap();
public LocalSubjectAccessReviewFluentImpl(){
    
}
public LocalSubjectAccessReviewFluentImpl( LocalSubjectAccessReview instance ){
    this.withTypeMeta(instance.getTypeMeta()); this.withContent(instance.getContent()); this.withGroups(instance.getGroups()); this.withNamespace(instance.getNamespace()); this.withResource(instance.getResource()); this.withResourceName(instance.getResourceName()); this.withUser(instance.getUser()); this.withVerb(instance.getVerb()); 
}

    public TypeMeta getTypeMeta(){
    return this.TypeMeta!=null?this.TypeMeta.build():null;
    }
    public T withTypeMeta( TypeMeta TypeMeta){
    if (TypeMeta!=null){ this.TypeMeta= new TypeMetaBuilder(TypeMeta); _visitables.add(this.TypeMeta);} return (T) this;
    }
    public TypeMetaNested<T> withNewTypeMeta(){
    return new TypeMetaNestedImpl<T>();
    }
    public TypeMetaNested<T> withNewTypeMetaLike( TypeMeta item){
    return new TypeMetaNestedImpl<T>(item);
    }
    public TypeMetaNested<T> editTypeMeta(){
    return withNewTypeMetaLike(getTypeMeta());
    }
    public T withNewTypeMeta( String apiVersion,  String kind){
    return withTypeMeta(new TypeMeta(apiVersion, kind));
    }
    public HasMetadata getContent(){
    return this.content;
    }
    public T withContent( HasMetadata content){
    this.content=content; return (T) this;
    }
    public T addToGroups( String ...items){
    for (String item : items) {this.groups.add(item);} return (T)this;
    }
    public T removeFromGroups( String ...items){
    for (String item : items) {this.groups.remove(item);} return (T)this;
    }
    public List<String> getGroups(){
    return this.groups;
    }
    public T withGroups( List<String> groups){
    this.groups.clear();if (groups != null) {for (String item : groups){this.addToGroups(item);}} return (T) this;
    }
    public T withGroups( String ...groups){
    this.groups.clear(); if (groups != null) {for (String item :groups){ this.addToGroups(item);}} return (T) this;
    }
    public String getNamespace(){
    return this.namespace;
    }
    public T withNamespace( String namespace){
    this.namespace=namespace; return (T) this;
    }
    public String getResource(){
    return this.resource;
    }
    public T withResource( String resource){
    this.resource=resource; return (T) this;
    }
    public String getResourceName(){
    return this.resourceName;
    }
    public T withResourceName( String resourceName){
    this.resourceName=resourceName; return (T) this;
    }
    public String getUser(){
    return this.user;
    }
    public T withUser( String user){
    this.user=user; return (T) this;
    }
    public String getVerb(){
    return this.verb;
    }
    public T withVerb( String verb){
    this.verb=verb; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
LocalSubjectAccessReviewFluentImpl that = (LocalSubjectAccessReviewFluentImpl) o;
if (TypeMeta != null ? !TypeMeta.equals(that.TypeMeta) :that.TypeMeta != null) return false;
if (content != null ? !content.equals(that.content) :that.content != null) return false;
if (groups != null ? !groups.equals(that.groups) :that.groups != null) return false;
if (namespace != null ? !namespace.equals(that.namespace) :that.namespace != null) return false;
if (resource != null ? !resource.equals(that.resource) :that.resource != null) return false;
if (resourceName != null ? !resourceName.equals(that.resourceName) :that.resourceName != null) return false;
if (user != null ? !user.equals(that.user) :that.user != null) return false;
if (verb != null ? !verb.equals(that.verb) :that.verb != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class TypeMetaNestedImpl<N> extends TypeMetaFluentImpl<TypeMetaNested<N>> implements TypeMetaNested<N>{

        private final TypeMetaBuilder builder;
    
             TypeMetaNestedImpl ( TypeMeta item){
        this.builder = new TypeMetaBuilder(this, item);
        }
             TypeMetaNestedImpl (){
        this.builder = new TypeMetaBuilder(this);
        }
    
            public N and(){
            return (N) LocalSubjectAccessReviewFluentImpl.this.withTypeMeta(builder.build());
        }
            public N endTypeMeta(){
            return and();
        }
    
}


}
