package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public class HTTPGetActionFluentImpl<T extends HTTPGetActionFluent<T>> extends BaseFluent<T> implements HTTPGetActionFluent<T>{

     String host;     String path;     VisitableBuilder<IntOrString, ?> port;     String scheme;     Map<String, Object> additionalProperties = new HashMap();
public HTTPGetActionFluentImpl(){
    
}
public HTTPGetActionFluentImpl( HTTPGetAction instance ){
    this.withHost(instance.getHost()); this.withPath(instance.getPath()); this.withPort(instance.getPort()); this.withScheme(instance.getScheme()); 
}

    public String getHost(){
    return this.host;
    }
    public T withHost( String host){
    this.host=host; return (T) this;
    }
    public String getPath(){
    return this.path;
    }
    public T withPath( String path){
    this.path=path; return (T) this;
    }
    public IntOrString getPort(){
    return this.port!=null?this.port.build():null;
    }
    public T withPort( IntOrString port){
    if (port!=null){ this.port= new IntOrStringBuilder(port); _visitables.add(this.port);} return (T) this;
    }
    public PortNested<T> withNewPort(){
    return new PortNestedImpl<T>();
    }
    public PortNested<T> withNewPortLike( IntOrString item){
    return new PortNestedImpl<T>(item);
    }
    public PortNested<T> editPort(){
    return withNewPortLike(getPort());
    }
    public T withNewPort( String strVal){
    return withPort(new IntOrString(strVal));
    }
    public T withNewPort( Integer intVal){
    return withPort(new IntOrString(intVal));
    }
    public String getScheme(){
    return this.scheme;
    }
    public T withScheme( String scheme){
    this.scheme=scheme; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
HTTPGetActionFluentImpl that = (HTTPGetActionFluentImpl) o;
if (host != null ? !host.equals(that.host) :that.host != null) return false;
if (path != null ? !path.equals(that.path) :that.path != null) return false;
if (port != null ? !port.equals(that.port) :that.port != null) return false;
if (scheme != null ? !scheme.equals(that.scheme) :that.scheme != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class PortNestedImpl<N> extends IntOrStringFluentImpl<PortNested<N>> implements PortNested<N>{

        private final IntOrStringBuilder builder;
    
             PortNestedImpl ( IntOrString item){
        this.builder = new IntOrStringBuilder(this, item);
        }
             PortNestedImpl (){
        this.builder = new IntOrStringBuilder(this);
        }
    
            public N endPort(){
            return and();
        }
            public N and(){
            return (N) HTTPGetActionFluentImpl.this.withPort(builder.build());
        }
    
}


}
