package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Builder;

public class SELinuxContextStrategyOptionsBuilder extends SELinuxContextStrategyOptionsFluentImpl<SELinuxContextStrategyOptionsBuilder> implements VisitableBuilder<SELinuxContextStrategyOptions,SELinuxContextStrategyOptionsBuilder>{

     SELinuxContextStrategyOptionsFluent<?> fluent;
public SELinuxContextStrategyOptionsBuilder(){
    this(new SELinuxContextStrategyOptions());
}
public SELinuxContextStrategyOptionsBuilder( SELinuxContextStrategyOptionsFluent<?> fluent ){
    this(fluent, new SELinuxContextStrategyOptions());
}
public SELinuxContextStrategyOptionsBuilder( SELinuxContextStrategyOptionsFluent<?> fluent , SELinuxContextStrategyOptions instance ){
    this.fluent = fluent; fluent.withSeLinuxOptions(instance.getSeLinuxOptions()); fluent.withType(instance.getType()); 
}
public SELinuxContextStrategyOptionsBuilder( SELinuxContextStrategyOptions instance ){
    this.fluent = this; this.withSeLinuxOptions(instance.getSeLinuxOptions()); this.withType(instance.getType()); 
}

public EditableSELinuxContextStrategyOptions build(){
    EditableSELinuxContextStrategyOptions buildable = new EditableSELinuxContextStrategyOptions(fluent.getSeLinuxOptions(),fluent.getType());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
SELinuxContextStrategyOptionsBuilder that = (SELinuxContextStrategyOptionsBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
