package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.TypeMeta;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Builder;

public class LocalSubjectAccessReviewBuilder extends LocalSubjectAccessReviewFluentImpl<LocalSubjectAccessReviewBuilder> implements VisitableBuilder<LocalSubjectAccessReview,LocalSubjectAccessReviewBuilder>{

     LocalSubjectAccessReviewFluent<?> fluent;
public LocalSubjectAccessReviewBuilder(){
    this(new LocalSubjectAccessReview());
}
public LocalSubjectAccessReviewBuilder( LocalSubjectAccessReviewFluent<?> fluent ){
    this(fluent, new LocalSubjectAccessReview());
}
public LocalSubjectAccessReviewBuilder( LocalSubjectAccessReviewFluent<?> fluent , LocalSubjectAccessReview instance ){
    this.fluent = fluent; fluent.withTypeMeta(instance.getTypeMeta()); fluent.withContent(instance.getContent()); fluent.withGroups(instance.getGroups()); fluent.withNamespace(instance.getNamespace()); fluent.withResource(instance.getResource()); fluent.withResourceName(instance.getResourceName()); fluent.withUser(instance.getUser()); fluent.withVerb(instance.getVerb()); 
}
public LocalSubjectAccessReviewBuilder( LocalSubjectAccessReview instance ){
    this.fluent = this; this.withTypeMeta(instance.getTypeMeta()); this.withContent(instance.getContent()); this.withGroups(instance.getGroups()); this.withNamespace(instance.getNamespace()); this.withResource(instance.getResource()); this.withResourceName(instance.getResourceName()); this.withUser(instance.getUser()); this.withVerb(instance.getVerb()); 
}

public EditableLocalSubjectAccessReview build(){
    EditableLocalSubjectAccessReview buildable = new EditableLocalSubjectAccessReview(fluent.getTypeMeta(),fluent.getContent(),fluent.getGroups(),fluent.getNamespace(),fluent.getResource(),fluent.getResourceName(),fluent.getUser(),fluent.getVerb());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
LocalSubjectAccessReviewBuilder that = (LocalSubjectAccessReviewBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
