package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.HasMetadata;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class SubjectAccessReviewFluentImpl<T extends SubjectAccessReviewFluent<T>> extends BaseFluent<T> implements SubjectAccessReviewFluent<T>{

     SubjectAccessReview.ApiVersion apiVersion;     HasMetadata content;     List<String> groups = new ArrayList();     String kind;     String namespace;     String resource;     String resourceName;     String user;     String verb;     Map<String, Object> additionalProperties = new HashMap();
public SubjectAccessReviewFluentImpl(){
    
}
public SubjectAccessReviewFluentImpl( SubjectAccessReview instance ){
    this.withApiVersion(instance.getApiVersion()); this.withContent(instance.getContent()); this.withGroups(instance.getGroups()); this.withKind(instance.getKind()); this.withNamespace(instance.getNamespace()); this.withResource(instance.getResource()); this.withResourceName(instance.getResourceName()); this.withUser(instance.getUser()); this.withVerb(instance.getVerb()); 
}

    public SubjectAccessReview.ApiVersion getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( SubjectAccessReview.ApiVersion apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public HasMetadata getContent(){
    return this.content;
    }
    public T withContent( HasMetadata content){
    this.content=content; return (T) this;
    }
    public T addToGroups( String ...items){
    for (String item : items) {this.groups.add(item);} return (T)this;
    }
    public T removeFromGroups( String ...items){
    for (String item : items) {this.groups.remove(item);} return (T)this;
    }
    public List<String> getGroups(){
    return this.groups;
    }
    public T withGroups( List<String> groups){
    this.groups.clear();if (groups != null) {for (String item : groups){this.addToGroups(item);}} return (T) this;
    }
    public T withGroups( String ...groups){
    this.groups.clear(); if (groups != null) {for (String item :groups){ this.addToGroups(item);}} return (T) this;
    }
    public String getKind(){
    return this.kind;
    }
    public T withKind( String kind){
    this.kind=kind; return (T) this;
    }
    public String getNamespace(){
    return this.namespace;
    }
    public T withNamespace( String namespace){
    this.namespace=namespace; return (T) this;
    }
    public String getResource(){
    return this.resource;
    }
    public T withResource( String resource){
    this.resource=resource; return (T) this;
    }
    public String getResourceName(){
    return this.resourceName;
    }
    public T withResourceName( String resourceName){
    this.resourceName=resourceName; return (T) this;
    }
    public String getUser(){
    return this.user;
    }
    public T withUser( String user){
    this.user=user; return (T) this;
    }
    public String getVerb(){
    return this.verb;
    }
    public T withVerb( String verb){
    this.verb=verb; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
SubjectAccessReviewFluentImpl that = (SubjectAccessReviewFluentImpl) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (content != null ? !content.equals(that.content) :that.content != null) return false;
if (groups != null ? !groups.equals(that.groups) :that.groups != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (namespace != null ? !namespace.equals(that.namespace) :that.namespace != null) return false;
if (resource != null ? !resource.equals(that.resource) :that.resource != null) return false;
if (resourceName != null ? !resourceName.equals(that.resourceName) :that.resourceName != null) return false;
if (user != null ? !user.equals(that.user) :that.user != null) return false;
if (verb != null ? !verb.equals(that.verb) :that.verb != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }



}
