package io.fabric8.kubernetes.api.model.extensions;

import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class IngressSpecFluentImpl<T extends IngressSpecFluent<T>> extends BaseFluent<T> implements IngressSpecFluent<T>{

     VisitableBuilder<IngressBackend, ?> backend;     List<VisitableBuilder<IngressRule, ?>> rules = new ArrayList();     Map<String, Object> additionalProperties = new HashMap();
public IngressSpecFluentImpl(){
    
}
public IngressSpecFluentImpl( IngressSpec instance ){
    this.withBackend(instance.getBackend()); this.withRules(instance.getRules()); 
}

    public IngressBackend getBackend(){
    return this.backend!=null?this.backend.build():null;
    }
    public T withBackend( IngressBackend backend){
    if (backend!=null){ this.backend= new IngressBackendBuilder(backend); _visitables.add(this.backend);} return (T) this;
    }
    public BackendNested<T> withNewBackend(){
    return new BackendNestedImpl<T>();
    }
    public BackendNested<T> withNewBackendLike( IngressBackend item){
    return new BackendNestedImpl<T>(item);
    }
    public BackendNested<T> editBackend(){
    return withNewBackendLike(getBackend());
    }
    public T addToRules( IngressRule ...items){
    for (IngressRule item : items) {IngressRuleBuilder builder = new IngressRuleBuilder(item);_visitables.add(builder);this.rules.add(builder);} return (T)this;
    }
    public T removeFromRules( IngressRule ...items){
    for (IngressRule item : items) {IngressRuleBuilder builder = new IngressRuleBuilder(item);_visitables.remove(builder);this.rules.remove(builder);} return (T)this;
    }
    public List<IngressRule> getRules(){
    return build(rules);
    }
    public T withRules( List<IngressRule> rules){
    this.rules.clear();if (rules != null) {for (IngressRule item : rules){this.addToRules(item);}} return (T) this;
    }
    public T withRules( IngressRule ...rules){
    this.rules.clear(); if (rules != null) {for (IngressRule item :rules){ this.addToRules(item);}} return (T) this;
    }
    public RulesNested<T> addNewRule(){
    return new RulesNestedImpl<T>();
    }
    public RulesNested<T> addNewRuleLike( IngressRule item){
    return new RulesNestedImpl<T>(item);
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
IngressSpecFluentImpl that = (IngressSpecFluentImpl) o;
if (backend != null ? !backend.equals(that.backend) :that.backend != null) return false;
if (rules != null ? !rules.equals(that.rules) :that.rules != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class BackendNestedImpl<N> extends IngressBackendFluentImpl<BackendNested<N>> implements BackendNested<N>{

        private final IngressBackendBuilder builder;
    
             BackendNestedImpl ( IngressBackend item){
        this.builder = new IngressBackendBuilder(this, item);
        }
             BackendNestedImpl (){
        this.builder = new IngressBackendBuilder(this);
        }
    
            public N and(){
            return (N) IngressSpecFluentImpl.this.withBackend(builder.build());
        }
            public N endBackend(){
            return and();
        }
    
}
    public class RulesNestedImpl<N> extends IngressRuleFluentImpl<RulesNested<N>> implements RulesNested<N>{

        private final IngressRuleBuilder builder;
    
             RulesNestedImpl (){
        this.builder = new IngressRuleBuilder(this);
        }
             RulesNestedImpl ( IngressRule item){
        this.builder = new IngressRuleBuilder(this, item);
        }
    
            public N and(){
            return (N) IngressSpecFluentImpl.this.addToRules(builder.build());
        }
            public N endRule(){
            return and();
        }
    
}


}
