package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.IntOrString;
import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import io.fabric8.kubernetes.api.model.IntOrStringFluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.IntOrStringFluentImpl;
import io.fabric8.kubernetes.api.builder.Fluent;

public class RoutePortFluentImpl<T extends RoutePortFluent<T>> extends BaseFluent<T> implements RoutePortFluent<T>{

     VisitableBuilder<IntOrString, ?> targetPort;     Map<String, Object> additionalProperties = new HashMap();
public RoutePortFluentImpl(){
    
}
public RoutePortFluentImpl( RoutePort instance ){
    this.withTargetPort(instance.getTargetPort()); 
}

    public IntOrString getTargetPort(){
    return this.targetPort!=null?this.targetPort.build():null;
    }
    public T withTargetPort( IntOrString targetPort){
    if (targetPort!=null){ this.targetPort= new IntOrStringBuilder(targetPort); _visitables.add(this.targetPort);} return (T) this;
    }
    public TargetPortNested<T> withNewTargetPort(){
    return new TargetPortNestedImpl<T>();
    }
    public TargetPortNested<T> withNewTargetPortLike( IntOrString item){
    return new TargetPortNestedImpl<T>(item);
    }
    public TargetPortNested<T> editTargetPort(){
    return withNewTargetPortLike(getTargetPort());
    }
    public T withNewTargetPort( String strVal){
    return withTargetPort(new IntOrString(strVal));
    }
    public T withNewTargetPort( Integer intVal){
    return withTargetPort(new IntOrString(intVal));
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
RoutePortFluentImpl that = (RoutePortFluentImpl) o;
if (targetPort != null ? !targetPort.equals(that.targetPort) :that.targetPort != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class TargetPortNestedImpl<N> extends IntOrStringFluentImpl<TargetPortNested<N>> implements TargetPortNested<N>{

        private final IntOrStringBuilder builder;
    
             TargetPortNestedImpl (){
        this.builder = new IntOrStringBuilder(this);
        }
             TargetPortNestedImpl ( IntOrString item){
        this.builder = new IntOrStringBuilder(this, item);
        }
    
            public N endTargetPort(){
            return and();
        }
            public N and(){
            return (N) RoutePortFluentImpl.this.withTargetPort(builder.build());
        }
    
}


}
