/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluentImpl;
import io.fabric8.openshift.api.model.BuildOutput;
import io.fabric8.openshift.api.model.BuildOutputBuilder;
import io.fabric8.openshift.api.model.BuildOutputFluentImpl;
import io.fabric8.openshift.api.model.BuildSource;
import io.fabric8.openshift.api.model.BuildSourceBuilder;
import io.fabric8.openshift.api.model.BuildSourceFluentImpl;
import io.fabric8.openshift.api.model.BuildSpec;
import io.fabric8.openshift.api.model.BuildSpecFluent;
import io.fabric8.openshift.api.model.BuildStrategy;
import io.fabric8.openshift.api.model.BuildStrategyBuilder;
import io.fabric8.openshift.api.model.BuildStrategyFluentImpl;
import io.fabric8.openshift.api.model.SourceRevision;
import io.fabric8.openshift.api.model.SourceRevisionBuilder;
import io.fabric8.openshift.api.model.SourceRevisionFluentImpl;
import java.util.HashMap;
import java.util.Map;

public class BuildSpecFluentImpl<T extends BuildSpecFluent<T>>
extends BaseFluent<T>
implements BuildSpecFluent<T> {
    Long completionDeadlineSeconds;
    VisitableBuilder<BuildOutput, ?> output;
    VisitableBuilder<ResourceRequirements, ?> resources;
    VisitableBuilder<SourceRevision, ?> revision;
    String serviceAccount;
    VisitableBuilder<BuildSource, ?> source;
    VisitableBuilder<BuildStrategy, ?> strategy;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public BuildSpecFluentImpl() {
    }

    public BuildSpecFluentImpl(BuildSpec instance) {
        this.withCompletionDeadlineSeconds(instance.getCompletionDeadlineSeconds());
        this.withOutput(instance.getOutput());
        this.withResources(instance.getResources());
        this.withRevision(instance.getRevision());
        this.withServiceAccount(instance.getServiceAccount());
        this.withSource(instance.getSource());
        this.withStrategy(instance.getStrategy());
    }

    @Override
    public Long getCompletionDeadlineSeconds() {
        return this.completionDeadlineSeconds;
    }

    @Override
    public T withCompletionDeadlineSeconds(Long completionDeadlineSeconds) {
        this.completionDeadlineSeconds = completionDeadlineSeconds;
        return (T)this;
    }

    @Override
    public BuildOutput getOutput() {
        return this.output != null ? (BuildOutput)this.output.build() : null;
    }

    @Override
    public T withOutput(BuildOutput output) {
        if (output != null) {
            this.output = new BuildOutputBuilder(output);
            this._visitables.add(this.output);
        }
        return (T)this;
    }

    @Override
    public BuildSpecFluent.OutputNested<T> withNewOutput() {
        return new OutputNestedImpl();
    }

    @Override
    public BuildSpecFluent.OutputNested<T> withNewOutputLike(BuildOutput item) {
        return new OutputNestedImpl(item);
    }

    @Override
    public BuildSpecFluent.OutputNested<T> editOutput() {
        return this.withNewOutputLike(this.getOutput());
    }

    @Override
    public ResourceRequirements getResources() {
        return this.resources != null ? (ResourceRequirements)this.resources.build() : null;
    }

    @Override
    public T withResources(ResourceRequirements resources) {
        if (resources != null) {
            this.resources = new ResourceRequirementsBuilder(resources);
            this._visitables.add(this.resources);
        }
        return (T)this;
    }

    @Override
    public BuildSpecFluent.ResourcesNested<T> withNewResources() {
        return new ResourcesNestedImpl();
    }

    @Override
    public BuildSpecFluent.ResourcesNested<T> withNewResourcesLike(ResourceRequirements item) {
        return new ResourcesNestedImpl(item);
    }

    @Override
    public BuildSpecFluent.ResourcesNested<T> editResources() {
        return this.withNewResourcesLike(this.getResources());
    }

    @Override
    public SourceRevision getRevision() {
        return this.revision != null ? (SourceRevision)this.revision.build() : null;
    }

    @Override
    public T withRevision(SourceRevision revision) {
        if (revision != null) {
            this.revision = new SourceRevisionBuilder(revision);
            this._visitables.add(this.revision);
        }
        return (T)this;
    }

    @Override
    public BuildSpecFluent.RevisionNested<T> withNewRevision() {
        return new RevisionNestedImpl();
    }

    @Override
    public BuildSpecFluent.RevisionNested<T> withNewRevisionLike(SourceRevision item) {
        return new RevisionNestedImpl(item);
    }

    @Override
    public BuildSpecFluent.RevisionNested<T> editRevision() {
        return this.withNewRevisionLike(this.getRevision());
    }

    @Override
    public String getServiceAccount() {
        return this.serviceAccount;
    }

    @Override
    public T withServiceAccount(String serviceAccount) {
        this.serviceAccount = serviceAccount;
        return (T)this;
    }

    @Override
    public BuildSource getSource() {
        return this.source != null ? (BuildSource)this.source.build() : null;
    }

    @Override
    public T withSource(BuildSource source) {
        if (source != null) {
            this.source = new BuildSourceBuilder(source);
            this._visitables.add(this.source);
        }
        return (T)this;
    }

    @Override
    public BuildSpecFluent.SourceNested<T> withNewSource() {
        return new SourceNestedImpl();
    }

    @Override
    public BuildSpecFluent.SourceNested<T> withNewSourceLike(BuildSource item) {
        return new SourceNestedImpl(item);
    }

    @Override
    public BuildSpecFluent.SourceNested<T> editSource() {
        return this.withNewSourceLike(this.getSource());
    }

    @Override
    public BuildStrategy getStrategy() {
        return this.strategy != null ? (BuildStrategy)this.strategy.build() : null;
    }

    @Override
    public T withStrategy(BuildStrategy strategy) {
        if (strategy != null) {
            this.strategy = new BuildStrategyBuilder(strategy);
            this._visitables.add(this.strategy);
        }
        return (T)this;
    }

    @Override
    public BuildSpecFluent.StrategyNested<T> withNewStrategy() {
        return new StrategyNestedImpl();
    }

    @Override
    public BuildSpecFluent.StrategyNested<T> withNewStrategyLike(BuildStrategy item) {
        return new StrategyNestedImpl(item);
    }

    @Override
    public BuildSpecFluent.StrategyNested<T> editStrategy() {
        return this.withNewStrategyLike(this.getStrategy());
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildSpecFluentImpl that = (BuildSpecFluentImpl)o;
        if (this.completionDeadlineSeconds != null ? !this.completionDeadlineSeconds.equals(that.completionDeadlineSeconds) : that.completionDeadlineSeconds != null) {
            return false;
        }
        if (this.output != null ? !this.output.equals(that.output) : that.output != null) {
            return false;
        }
        if (this.resources != null ? !this.resources.equals(that.resources) : that.resources != null) {
            return false;
        }
        if (this.revision != null ? !this.revision.equals(that.revision) : that.revision != null) {
            return false;
        }
        if (this.serviceAccount != null ? !this.serviceAccount.equals(that.serviceAccount) : that.serviceAccount != null) {
            return false;
        }
        if (this.source != null ? !this.source.equals(that.source) : that.source != null) {
            return false;
        }
        if (this.strategy != null ? !this.strategy.equals(that.strategy) : that.strategy != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class StrategyNestedImpl<N>
    extends BuildStrategyFluentImpl<BuildSpecFluent.StrategyNested<N>>
    implements BuildSpecFluent.StrategyNested<N> {
        private final BuildStrategyBuilder builder;

        StrategyNestedImpl() {
            this.builder = new BuildStrategyBuilder(this);
        }

        StrategyNestedImpl(BuildStrategy item) {
            this.builder = new BuildStrategyBuilder(this, item);
        }

        @Override
        public N endStrategy() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)BuildSpecFluentImpl.this.withStrategy(this.builder.build());
        }
    }

    public class SourceNestedImpl<N>
    extends BuildSourceFluentImpl<BuildSpecFluent.SourceNested<N>>
    implements BuildSpecFluent.SourceNested<N> {
        private final BuildSourceBuilder builder;

        SourceNestedImpl() {
            this.builder = new BuildSourceBuilder(this);
        }

        SourceNestedImpl(BuildSource item) {
            this.builder = new BuildSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BuildSpecFluentImpl.this.withSource(this.builder.build());
        }

        @Override
        public N endSource() {
            return this.and();
        }
    }

    public class RevisionNestedImpl<N>
    extends SourceRevisionFluentImpl<BuildSpecFluent.RevisionNested<N>>
    implements BuildSpecFluent.RevisionNested<N> {
        private final SourceRevisionBuilder builder;

        RevisionNestedImpl() {
            this.builder = new SourceRevisionBuilder(this);
        }

        RevisionNestedImpl(SourceRevision item) {
            this.builder = new SourceRevisionBuilder(this, item);
        }

        @Override
        public N endRevision() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)BuildSpecFluentImpl.this.withRevision(this.builder.build());
        }
    }

    public class ResourcesNestedImpl<N>
    extends ResourceRequirementsFluentImpl<BuildSpecFluent.ResourcesNested<N>>
    implements BuildSpecFluent.ResourcesNested<N> {
        private final ResourceRequirementsBuilder builder;

        ResourcesNestedImpl() {
            this.builder = new ResourceRequirementsBuilder(this);
        }

        ResourcesNestedImpl(ResourceRequirements item) {
            this.builder = new ResourceRequirementsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BuildSpecFluentImpl.this.withResources(this.builder.build());
        }

        @Override
        public N endResources() {
            return this.and();
        }
    }

    public class OutputNestedImpl<N>
    extends BuildOutputFluentImpl<BuildSpecFluent.OutputNested<N>>
    implements BuildSpecFluent.OutputNested<N> {
        private final BuildOutputBuilder builder;

        OutputNestedImpl() {
            this.builder = new BuildOutputBuilder(this);
        }

        OutputNestedImpl(BuildOutput item) {
            this.builder = new BuildOutputBuilder(this, item);
        }

        @Override
        public N endOutput() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)BuildSpecFluentImpl.this.withOutput(this.builder.build());
        }
    }
}

