package io.fabric8.openshift.api.model;

import java.util.Map;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;

public class ProjectRequestFluentImpl<T extends ProjectRequestFluent<T>> extends BaseFluent<T> implements ProjectRequestFluent<T>{

     ProjectRequest.ApiVersion apiVersion;     String description;     String displayName;     String kind;     VisitableBuilder<ObjectMeta, ?> metadata;     Map<String, Object> additionalProperties = new HashMap();
public ProjectRequestFluentImpl(){
    
}
public ProjectRequestFluentImpl( ProjectRequest instance ){
    this.withApiVersion(instance.getApiVersion()); this.withDescription(instance.getDescription()); this.withDisplayName(instance.getDisplayName()); this.withKind(instance.getKind()); this.withMetadata(instance.getMetadata()); 
}

    public ProjectRequest.ApiVersion getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( ProjectRequest.ApiVersion apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public String getDescription(){
    return this.description;
    }
    public T withDescription( String description){
    this.description=description; return (T) this;
    }
    public String getDisplayName(){
    return this.displayName;
    }
    public T withDisplayName( String displayName){
    this.displayName=displayName; return (T) this;
    }
    public String getKind(){
    return this.kind;
    }
    public T withKind( String kind){
    this.kind=kind; return (T) this;
    }
    public ObjectMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public T withMetadata( ObjectMeta metadata){
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (T) this;
    }
    public MetadataNested<T> withNewMetadata(){
    return new MetadataNestedImpl<T>();
    }
    public MetadataNested<T> withNewMetadataLike( ObjectMeta item){
    return new MetadataNestedImpl<T>(item);
    }
    public MetadataNested<T> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ProjectRequestFluentImpl that = (ProjectRequestFluentImpl) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (description != null ? !description.equals(that.description) :that.description != null) return false;
if (displayName != null ? !displayName.equals(that.displayName) :that.displayName != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<MetadataNested<N>> implements MetadataNested<N>{

        private final ObjectMetaBuilder builder;
    
             MetadataNestedImpl (){
        this.builder = new ObjectMetaBuilder(this);
        }
             MetadataNestedImpl ( ObjectMeta item){
        this.builder = new ObjectMetaBuilder(this, item);
        }
    
            public N and(){
            return (N) ProjectRequestFluentImpl.this.withMetadata(builder.build());
        }
            public N endMetadata(){
            return and();
        }
    
}


}
