package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import io.fabric8.openshift.api.model.GroupFluent;
import io.fabric8.openshift.api.model.OAuthClientAuthorizationBuilder;
import io.fabric8.kubernetes.api.model.extensions.JobFluent;
import io.fabric8.openshift.api.model.ClusterRoleBindingFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.ProjectRequestFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.ScaleFluent;
import io.fabric8.openshift.api.model.BuildBuilder;
import io.fabric8.openshift.api.model.BuildConfigFluent;
import io.fabric8.openshift.api.model.RoleBindingBuilder;
import io.fabric8.openshift.api.model.Identity;
import io.fabric8.openshift.api.model.ProjectRequestFluent;
import io.fabric8.openshift.api.model.OAuthAuthorizeToken;
import io.fabric8.openshift.api.model.ClusterPolicyFluent;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ProjectFluentImpl;
import io.fabric8.openshift.api.model.BuildRequestBuilder;
import io.fabric8.openshift.api.model.ClusterRoleFluentImpl;
import io.fabric8.openshift.api.model.GroupBuilder;
import io.fabric8.openshift.api.model.ProjectRequestBuilder;
import io.fabric8.openshift.api.model.TemplateBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigFluent;
import io.fabric8.openshift.api.model.ImageStreamFluent;
import io.fabric8.openshift.api.model.OAuthAuthorizeTokenFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.DeploymentFluent;
import io.fabric8.openshift.api.model.RoleFluent;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.kubernetes.api.model.extensions.IngressBuilder;
import io.fabric8.openshift.api.model.RoleBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.openshift.api.model.RoleBindingFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.Scale;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.UserFluent;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscaler;
import io.fabric8.kubernetes.api.model.extensions.DeploymentFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.IngressFluent;
import io.fabric8.kubernetes.api.model.extensions.JobFluentImpl;
import io.fabric8.openshift.api.model.TemplateFluent;
import io.fabric8.openshift.api.model.ProjectFluent;
import io.fabric8.openshift.api.model.BuildRequestFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.IngressFluentImpl;
import io.fabric8.openshift.api.model.OAuthClientFluent;
import io.fabric8.kubernetes.api.model.extensions.ScaleBuilder;
import io.fabric8.openshift.api.model.OAuthClientAuthorizationFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.Deployment;
import io.fabric8.kubernetes.api.model.extensions.Ingress;
import io.fabric8.openshift.api.model.OAuthClient;
import io.fabric8.kubernetes.api.model.extensions.Job;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.openshift.api.model.ProjectRequest;
import io.fabric8.openshift.api.model.ImageFluentImpl;
import io.fabric8.openshift.api.model.ImageBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.OAuthAuthorizeTokenFluent;
import io.fabric8.kubernetes.api.model.extensions.ThirdPartyResourceFluentImpl;
import io.fabric8.openshift.api.model.ClusterPolicyBindingBuilder;
import io.fabric8.openshift.api.model.ClusterRoleBuilder;
import io.fabric8.openshift.api.model.ClusterRoleBindingBuilder;
import io.fabric8.openshift.api.model.IdentityFluent;
import io.fabric8.openshift.api.model.BuildFluent;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetFluent;
import io.fabric8.openshift.api.model.ImageFluent;
import io.fabric8.openshift.api.model.ProjectBuilder;
import io.fabric8.openshift.api.model.OAuthAccessTokenFluentImpl;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.ClusterPolicyBindingFluent;
import io.fabric8.openshift.api.model.ClusterPolicyBindingFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.JobBuilder;
import io.fabric8.openshift.api.model.ClusterPolicyFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.ThirdPartyResource;
import io.fabric8.openshift.api.model.OAuthAuthorizeTokenBuilder;
import io.fabric8.openshift.api.model.OAuthAccessTokenFluent;
import io.fabric8.openshift.api.model.OAuthClientAuthorizationFluent;
import io.fabric8.openshift.api.model.RouteFluentImpl;
import io.fabric8.openshift.api.model.DeploymentConfigFluentImpl;
import io.fabric8.openshift.api.model.BuildConfigFluentImpl;
import io.fabric8.openshift.api.model.Image;
import io.fabric8.openshift.api.model.ClusterPolicyBuilder;
import io.fabric8.openshift.api.model.RoleBindingFluent;
import io.fabric8.openshift.api.model.UserFluentImpl;
import io.fabric8.openshift.api.model.IdentityFluentImpl;
import io.fabric8.openshift.api.model.Group;
import io.fabric8.openshift.api.model.ClusterPolicyBinding;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetFluentImpl;
import io.fabric8.openshift.api.model.ClusterRoleBindingFluent;
import io.fabric8.openshift.api.model.Project;
import io.fabric8.openshift.api.model.OAuthClientBuilder;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerFluentImpl;
import io.fabric8.openshift.api.model.Role;
import io.fabric8.openshift.api.model.Policy;
import io.fabric8.openshift.api.model.GroupFluentImpl;
import io.fabric8.openshift.api.model.PolicyBindingFluent;
import io.fabric8.openshift.api.model.RoleBinding;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.OAuthAccessTokenBuilder;
import io.fabric8.openshift.api.model.BuildFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.DeploymentBuilder;
import io.fabric8.openshift.api.model.OAuthAccessToken;
import io.fabric8.openshift.api.model.PolicyBinding;
import io.fabric8.openshift.api.model.BuildConfigBuilder;
import io.fabric8.openshift.api.model.ClusterRole;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerBuilder;
import io.fabric8.openshift.api.model.PolicyFluentImpl;
import io.fabric8.openshift.api.model.BuildRequestFluent;
import io.fabric8.openshift.api.model.OAuthClientFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerFluent;
import io.fabric8.openshift.api.model.ClusterRoleBinding;
import io.fabric8.openshift.api.model.ImageStreamFluentImpl;
import io.fabric8.openshift.api.model.PolicyBindingBuilder;
import io.fabric8.openshift.api.model.RouteFluent;
import io.fabric8.kubernetes.api.model.extensions.ThirdPartyResourceFluent;
import io.fabric8.kubernetes.api.model.extensions.ThirdPartyResourceBuilder;
import io.fabric8.kubernetes.api.model.extensions.DaemonSet;
import io.fabric8.openshift.api.model.PolicyBindingFluentImpl;
import io.fabric8.openshift.api.model.User;
import io.fabric8.openshift.api.model.ClusterRoleFluent;
import io.fabric8.kubernetes.api.model.extensions.ScaleFluentImpl;
import io.fabric8.openshift.api.model.PolicyFluent;
import io.fabric8.openshift.api.model.OAuthClientAuthorization;
import io.fabric8.openshift.api.model.ImageStreamBuilder;
import io.fabric8.openshift.api.model.RouteBuilder;
import io.fabric8.openshift.api.model.ClusterPolicy;
import io.fabric8.openshift.api.model.DeploymentConfigBuilder;
import io.fabric8.openshift.api.model.BuildRequest;
import io.fabric8.openshift.api.model.UserBuilder;
import io.fabric8.openshift.api.model.RoleFluentImpl;
import io.fabric8.openshift.api.model.IdentityBuilder;
import io.fabric8.openshift.api.model.PolicyBuilder;
import io.fabric8.openshift.api.model.TemplateFluentImpl;

public class BaseKubernetesListFluentImpl<T extends BaseKubernetesListFluent<T>> extends BaseFluent<T> implements BaseKubernetesListFluent<T>{

     BaseKubernetesList.ApiVersion apiVersion;     List<HasMetadata> items = new ArrayList();     List<VisitableBuilder<Job, ?>> jobItems = new ArrayList();     List<VisitableBuilder<OAuthAccessToken, ?>> oAuthAccessTokenItems = new ArrayList();     List<VisitableBuilder<Deployment, ?>> deploymentItems = new ArrayList();     List<VisitableBuilder<Secret, ?>> secretItems = new ArrayList();     List<VisitableBuilder<PersistentVolume, ?>> persistentVolumeItems = new ArrayList();     List<VisitableBuilder<Build, ?>> buildItems = new ArrayList();     List<VisitableBuilder<DaemonSet, ?>> daemonSetItems = new ArrayList();     List<VisitableBuilder<User, ?>> userItems = new ArrayList();     List<VisitableBuilder<BuildRequest, ?>> buildRequestItems = new ArrayList();     List<VisitableBuilder<HorizontalPodAutoscaler, ?>> horizontalPodAutoscalerItems = new ArrayList();     List<VisitableBuilder<LimitRange, ?>> limitRangeItems = new ArrayList();     List<VisitableBuilder<ServiceAccount, ?>> serviceAccountItems = new ArrayList();     List<VisitableBuilder<Project, ?>> projectItems = new ArrayList();     List<VisitableBuilder<SecurityContextConstraints, ?>> securityContextConstraintsItems = new ArrayList();     List<VisitableBuilder<Namespace, ?>> namespaceItems = new ArrayList();     List<VisitableBuilder<ThirdPartyResource, ?>> thirdPartyResourceItems = new ArrayList();     List<VisitableBuilder<Node, ?>> nodeItems = new ArrayList();     List<VisitableBuilder<Template, ?>> templateItems = new ArrayList();     List<VisitableBuilder<Pod, ?>> podItems = new ArrayList();     List<VisitableBuilder<Role, ?>> roleItems = new ArrayList();     List<VisitableBuilder<DeploymentConfig, ?>> deploymentConfigItems = new ArrayList();     List<VisitableBuilder<ClusterPolicy, ?>> clusterPolicyItems = new ArrayList();     List<VisitableBuilder<Identity, ?>> identityItems = new ArrayList();     List<VisitableBuilder<OAuthClient, ?>> oAuthClientItems = new ArrayList();     List<VisitableBuilder<OAuthClientAuthorization, ?>> oAuthClientAuthorizationItems = new ArrayList();     List<VisitableBuilder<RoleBinding, ?>> roleBindingItems = new ArrayList();     List<VisitableBuilder<ClusterRoleBinding, ?>> clusterRoleBindingItems = new ArrayList();     List<VisitableBuilder<Scale, ?>> scaleItems = new ArrayList();     List<VisitableBuilder<Binding, ?>> bindingItems = new ArrayList();     List<VisitableBuilder<PolicyBinding, ?>> policyBindingItems = new ArrayList();     List<VisitableBuilder<ClusterPolicyBinding, ?>> clusterPolicyBindingItems = new ArrayList();     List<VisitableBuilder<ImageStream, ?>> imageStreamItems = new ArrayList();     List<VisitableBuilder<Ingress, ?>> ingressItems = new ArrayList();     List<VisitableBuilder<ComponentStatus, ?>> componentStatusItems = new ArrayList();     List<VisitableBuilder<Endpoints, ?>> endpointsItems = new ArrayList();     List<VisitableBuilder<ProjectRequest, ?>> projectRequestItems = new ArrayList();     List<VisitableBuilder<ResourceQuota, ?>> resourceQuotaItems = new ArrayList();     List<VisitableBuilder<Service, ?>> serviceItems = new ArrayList();     List<VisitableBuilder<PodTemplate, ?>> podTemplateItems = new ArrayList();     List<VisitableBuilder<Policy, ?>> policyItems = new ArrayList();     List<VisitableBuilder<ClusterRole, ?>> clusterRoleItems = new ArrayList();     List<VisitableBuilder<Route, ?>> routeItems = new ArrayList();     List<VisitableBuilder<PersistentVolumeClaim, ?>> persistentVolumeClaimItems = new ArrayList();     List<VisitableBuilder<ReplicationController, ?>> replicationControllerItems = new ArrayList();     List<VisitableBuilder<Image, ?>> imageItems = new ArrayList();     List<VisitableBuilder<Group, ?>> groupItems = new ArrayList();     List<VisitableBuilder<OAuthAuthorizeToken, ?>> oAuthAuthorizeTokenItems = new ArrayList();     List<VisitableBuilder<BuildConfig, ?>> buildConfigItems = new ArrayList();     List<VisitableBuilder<Event, ?>> eventItems = new ArrayList();     String kind;     VisitableBuilder<ListMeta, ?> metadata;     Map<String, Object> additionalProperties = new HashMap();
public BaseKubernetesListFluentImpl(){
    
}
public BaseKubernetesListFluentImpl( BaseKubernetesList instance ){
    this.withApiVersion(instance.getApiVersion()); this.withItems(instance.getItems()); this.withKind(instance.getKind()); this.withMetadata(instance.getMetadata()); 
}

    public BaseKubernetesList.ApiVersion getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( BaseKubernetesList.ApiVersion apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public T addToItems( HasMetadata ...items){
    for (HasMetadata item : items) {if (item instanceof Job){addToJobItems((Job)item);}
 else if (item instanceof OAuthAccessToken){addToOAuthAccessTokenItems((OAuthAccessToken)item);}
 else if (item instanceof Deployment){addToDeploymentItems((Deployment)item);}
 else if (item instanceof Secret){addToSecretItems((Secret)item);}
 else if (item instanceof PersistentVolume){addToPersistentVolumeItems((PersistentVolume)item);}
 else if (item instanceof Build){addToBuildItems((Build)item);}
 else if (item instanceof DaemonSet){addToDaemonSetItems((DaemonSet)item);}
 else if (item instanceof User){addToUserItems((User)item);}
 else if (item instanceof BuildRequest){addToBuildRequestItems((BuildRequest)item);}
 else if (item instanceof HorizontalPodAutoscaler){addToHorizontalPodAutoscalerItems((HorizontalPodAutoscaler)item);}
 else if (item instanceof LimitRange){addToLimitRangeItems((LimitRange)item);}
 else if (item instanceof ServiceAccount){addToServiceAccountItems((ServiceAccount)item);}
 else if (item instanceof Project){addToProjectItems((Project)item);}
 else if (item instanceof SecurityContextConstraints){addToSecurityContextConstraintsItems((SecurityContextConstraints)item);}
 else if (item instanceof Namespace){addToNamespaceItems((Namespace)item);}
 else if (item instanceof ThirdPartyResource){addToThirdPartyResourceItems((ThirdPartyResource)item);}
 else if (item instanceof Node){addToNodeItems((Node)item);}
 else if (item instanceof Template){addToTemplateItems((Template)item);}
 else if (item instanceof Pod){addToPodItems((Pod)item);}
 else if (item instanceof Role){addToRoleItems((Role)item);}
 else if (item instanceof DeploymentConfig){addToDeploymentConfigItems((DeploymentConfig)item);}
 else if (item instanceof ClusterPolicy){addToClusterPolicyItems((ClusterPolicy)item);}
 else if (item instanceof Identity){addToIdentityItems((Identity)item);}
 else if (item instanceof OAuthClient){addToOAuthClientItems((OAuthClient)item);}
 else if (item instanceof OAuthClientAuthorization){addToOAuthClientAuthorizationItems((OAuthClientAuthorization)item);}
 else if (item instanceof RoleBinding){addToRoleBindingItems((RoleBinding)item);}
 else if (item instanceof ClusterRoleBinding){addToClusterRoleBindingItems((ClusterRoleBinding)item);}
 else if (item instanceof Scale){addToScaleItems((Scale)item);}
 else if (item instanceof Binding){addToBindingItems((Binding)item);}
 else if (item instanceof PolicyBinding){addToPolicyBindingItems((PolicyBinding)item);}
 else if (item instanceof ClusterPolicyBinding){addToClusterPolicyBindingItems((ClusterPolicyBinding)item);}
 else if (item instanceof ImageStream){addToImageStreamItems((ImageStream)item);}
 else if (item instanceof Ingress){addToIngressItems((Ingress)item);}
 else if (item instanceof ComponentStatus){addToComponentStatusItems((ComponentStatus)item);}
 else if (item instanceof Endpoints){addToEndpointsItems((Endpoints)item);}
 else if (item instanceof ProjectRequest){addToProjectRequestItems((ProjectRequest)item);}
 else if (item instanceof ResourceQuota){addToResourceQuotaItems((ResourceQuota)item);}
 else if (item instanceof Service){addToServiceItems((Service)item);}
 else if (item instanceof PodTemplate){addToPodTemplateItems((PodTemplate)item);}
 else if (item instanceof Policy){addToPolicyItems((Policy)item);}
 else if (item instanceof ClusterRole){addToClusterRoleItems((ClusterRole)item);}
 else if (item instanceof Route){addToRouteItems((Route)item);}
 else if (item instanceof PersistentVolumeClaim){addToPersistentVolumeClaimItems((PersistentVolumeClaim)item);}
 else if (item instanceof ReplicationController){addToReplicationControllerItems((ReplicationController)item);}
 else if (item instanceof Image){addToImageItems((Image)item);}
 else if (item instanceof Group){addToGroupItems((Group)item);}
 else if (item instanceof OAuthAuthorizeToken){addToOAuthAuthorizeTokenItems((OAuthAuthorizeToken)item);}
 else if (item instanceof BuildConfig){addToBuildConfigItems((BuildConfig)item);}
 else if (item instanceof Event){addToEventItems((Event)item);}
} return (T)this;
    }
    public T removeFromItems( HasMetadata ...items){
    for (HasMetadata item : items) {if (item instanceof Job){removeFromJobItems((Job)item);}
 else if (item instanceof OAuthAccessToken){removeFromOAuthAccessTokenItems((OAuthAccessToken)item);}
 else if (item instanceof Deployment){removeFromDeploymentItems((Deployment)item);}
 else if (item instanceof Secret){removeFromSecretItems((Secret)item);}
 else if (item instanceof PersistentVolume){removeFromPersistentVolumeItems((PersistentVolume)item);}
 else if (item instanceof Build){removeFromBuildItems((Build)item);}
 else if (item instanceof DaemonSet){removeFromDaemonSetItems((DaemonSet)item);}
 else if (item instanceof User){removeFromUserItems((User)item);}
 else if (item instanceof BuildRequest){removeFromBuildRequestItems((BuildRequest)item);}
 else if (item instanceof HorizontalPodAutoscaler){removeFromHorizontalPodAutoscalerItems((HorizontalPodAutoscaler)item);}
 else if (item instanceof LimitRange){removeFromLimitRangeItems((LimitRange)item);}
 else if (item instanceof ServiceAccount){removeFromServiceAccountItems((ServiceAccount)item);}
 else if (item instanceof Project){removeFromProjectItems((Project)item);}
 else if (item instanceof SecurityContextConstraints){removeFromSecurityContextConstraintsItems((SecurityContextConstraints)item);}
 else if (item instanceof Namespace){removeFromNamespaceItems((Namespace)item);}
 else if (item instanceof ThirdPartyResource){removeFromThirdPartyResourceItems((ThirdPartyResource)item);}
 else if (item instanceof Node){removeFromNodeItems((Node)item);}
 else if (item instanceof Template){removeFromTemplateItems((Template)item);}
 else if (item instanceof Pod){removeFromPodItems((Pod)item);}
 else if (item instanceof Role){removeFromRoleItems((Role)item);}
 else if (item instanceof DeploymentConfig){removeFromDeploymentConfigItems((DeploymentConfig)item);}
 else if (item instanceof ClusterPolicy){removeFromClusterPolicyItems((ClusterPolicy)item);}
 else if (item instanceof Identity){removeFromIdentityItems((Identity)item);}
 else if (item instanceof OAuthClient){removeFromOAuthClientItems((OAuthClient)item);}
 else if (item instanceof OAuthClientAuthorization){removeFromOAuthClientAuthorizationItems((OAuthClientAuthorization)item);}
 else if (item instanceof RoleBinding){removeFromRoleBindingItems((RoleBinding)item);}
 else if (item instanceof ClusterRoleBinding){removeFromClusterRoleBindingItems((ClusterRoleBinding)item);}
 else if (item instanceof Scale){removeFromScaleItems((Scale)item);}
 else if (item instanceof Binding){removeFromBindingItems((Binding)item);}
 else if (item instanceof PolicyBinding){removeFromPolicyBindingItems((PolicyBinding)item);}
 else if (item instanceof ClusterPolicyBinding){removeFromClusterPolicyBindingItems((ClusterPolicyBinding)item);}
 else if (item instanceof ImageStream){removeFromImageStreamItems((ImageStream)item);}
 else if (item instanceof Ingress){removeFromIngressItems((Ingress)item);}
 else if (item instanceof ComponentStatus){removeFromComponentStatusItems((ComponentStatus)item);}
 else if (item instanceof Endpoints){removeFromEndpointsItems((Endpoints)item);}
 else if (item instanceof ProjectRequest){removeFromProjectRequestItems((ProjectRequest)item);}
 else if (item instanceof ResourceQuota){removeFromResourceQuotaItems((ResourceQuota)item);}
 else if (item instanceof Service){removeFromServiceItems((Service)item);}
 else if (item instanceof PodTemplate){removeFromPodTemplateItems((PodTemplate)item);}
 else if (item instanceof Policy){removeFromPolicyItems((Policy)item);}
 else if (item instanceof ClusterRole){removeFromClusterRoleItems((ClusterRole)item);}
 else if (item instanceof Route){removeFromRouteItems((Route)item);}
 else if (item instanceof PersistentVolumeClaim){removeFromPersistentVolumeClaimItems((PersistentVolumeClaim)item);}
 else if (item instanceof ReplicationController){removeFromReplicationControllerItems((ReplicationController)item);}
 else if (item instanceof Image){removeFromImageItems((Image)item);}
 else if (item instanceof Group){removeFromGroupItems((Group)item);}
 else if (item instanceof OAuthAuthorizeToken){removeFromOAuthAuthorizeTokenItems((OAuthAuthorizeToken)item);}
 else if (item instanceof BuildConfig){removeFromBuildConfigItems((BuildConfig)item);}
 else if (item instanceof Event){removeFromEventItems((Event)item);}
} return (T)this;
    }
    public List<HasMetadata> getItems(){
    return aggregate(build(bindingItems), build(buildConfigItems), build(buildItems), build(buildRequestItems), build(clusterPolicyBindingItems), build(clusterPolicyItems), build(clusterRoleBindingItems), build(clusterRoleItems), build(componentStatusItems), build(daemonSetItems), build(deploymentConfigItems), build(deploymentItems), build(endpointsItems), build(eventItems), build(groupItems), build(horizontalPodAutoscalerItems), build(identityItems), build(imageItems), build(imageStreamItems), build(ingressItems), build(jobItems), build(limitRangeItems), build(namespaceItems), build(nodeItems), build(oAuthAccessTokenItems), build(oAuthAuthorizeTokenItems), build(oAuthClientAuthorizationItems), build(oAuthClientItems), build(persistentVolumeClaimItems), build(persistentVolumeItems), build(podItems), build(podTemplateItems), build(policyBindingItems), build(policyItems), build(projectItems), build(projectRequestItems), build(replicationControllerItems), build(resourceQuotaItems), build(roleBindingItems), build(roleItems), build(routeItems), build(scaleItems), build(secretItems), build(securityContextConstraintsItems), build(serviceAccountItems), build(serviceItems), build(templateItems), build(thirdPartyResourceItems), build(userItems));
    }
    public T withItems( List<HasMetadata> items){
    this.items.clear();if (items != null) {for (HasMetadata item : items){this.addToItems(item);}} return (T) this;
    }
    public T withItems( HasMetadata ...items){
    this.items.clear(); if (items != null) {for (HasMetadata item :items){ this.addToItems(item);}} return (T) this;
    }
    public T addToJobItems( Job ...items){
    for (Job item : items) {JobBuilder builder = new JobBuilder(item);_visitables.add(builder);this.jobItems.add(builder);} return (T)this;
    }
    public T removeFromJobItems( Job ...items){
    for (Job item : items) {JobBuilder builder = new JobBuilder(item);_visitables.remove(builder);this.jobItems.remove(builder);} return (T)this;
    }
    public JobItemsNested<T> addNewJobItem(){
    return new JobItemsNestedImpl<T>();
    }
    public JobItemsNested<T> addNewJobItemLike( Job item){
    return new JobItemsNestedImpl<T>(item);
    }
    public T addToOAuthAccessTokenItems( OAuthAccessToken ...items){
    for (OAuthAccessToken item : items) {OAuthAccessTokenBuilder builder = new OAuthAccessTokenBuilder(item);_visitables.add(builder);this.oAuthAccessTokenItems.add(builder);} return (T)this;
    }
    public T removeFromOAuthAccessTokenItems( OAuthAccessToken ...items){
    for (OAuthAccessToken item : items) {OAuthAccessTokenBuilder builder = new OAuthAccessTokenBuilder(item);_visitables.remove(builder);this.oAuthAccessTokenItems.remove(builder);} return (T)this;
    }
    public OAuthAccessTokenItemsNested<T> addNewOAuthAccessTokenItem(){
    return new OAuthAccessTokenItemsNestedImpl<T>();
    }
    public OAuthAccessTokenItemsNested<T> addNewOAuthAccessTokenItemLike( OAuthAccessToken item){
    return new OAuthAccessTokenItemsNestedImpl<T>(item);
    }
    public T addToDeploymentItems( Deployment ...items){
    for (Deployment item : items) {DeploymentBuilder builder = new DeploymentBuilder(item);_visitables.add(builder);this.deploymentItems.add(builder);} return (T)this;
    }
    public T removeFromDeploymentItems( Deployment ...items){
    for (Deployment item : items) {DeploymentBuilder builder = new DeploymentBuilder(item);_visitables.remove(builder);this.deploymentItems.remove(builder);} return (T)this;
    }
    public DeploymentItemsNested<T> addNewDeploymentItem(){
    return new DeploymentItemsNestedImpl<T>();
    }
    public DeploymentItemsNested<T> addNewDeploymentItemLike( Deployment item){
    return new DeploymentItemsNestedImpl<T>(item);
    }
    public T addToSecretItems( Secret ...items){
    for (Secret item : items) {SecretBuilder builder = new SecretBuilder(item);_visitables.add(builder);this.secretItems.add(builder);} return (T)this;
    }
    public T removeFromSecretItems( Secret ...items){
    for (Secret item : items) {SecretBuilder builder = new SecretBuilder(item);_visitables.remove(builder);this.secretItems.remove(builder);} return (T)this;
    }
    public SecretItemsNested<T> addNewSecretItem(){
    return new SecretItemsNestedImpl<T>();
    }
    public SecretItemsNested<T> addNewSecretItemLike( Secret item){
    return new SecretItemsNestedImpl<T>(item);
    }
    public T addToPersistentVolumeItems( PersistentVolume ...items){
    for (PersistentVolume item : items) {PersistentVolumeBuilder builder = new PersistentVolumeBuilder(item);_visitables.add(builder);this.persistentVolumeItems.add(builder);} return (T)this;
    }
    public T removeFromPersistentVolumeItems( PersistentVolume ...items){
    for (PersistentVolume item : items) {PersistentVolumeBuilder builder = new PersistentVolumeBuilder(item);_visitables.remove(builder);this.persistentVolumeItems.remove(builder);} return (T)this;
    }
    public PersistentVolumeItemsNested<T> addNewPersistentVolumeItem(){
    return new PersistentVolumeItemsNestedImpl<T>();
    }
    public PersistentVolumeItemsNested<T> addNewPersistentVolumeItemLike( PersistentVolume item){
    return new PersistentVolumeItemsNestedImpl<T>(item);
    }
    public T addToBuildItems( Build ...items){
    for (Build item : items) {BuildBuilder builder = new BuildBuilder(item);_visitables.add(builder);this.buildItems.add(builder);} return (T)this;
    }
    public T removeFromBuildItems( Build ...items){
    for (Build item : items) {BuildBuilder builder = new BuildBuilder(item);_visitables.remove(builder);this.buildItems.remove(builder);} return (T)this;
    }
    public BuildItemsNested<T> addNewBuildItem(){
    return new BuildItemsNestedImpl<T>();
    }
    public BuildItemsNested<T> addNewBuildItemLike( Build item){
    return new BuildItemsNestedImpl<T>(item);
    }
    public T addToDaemonSetItems( DaemonSet ...items){
    for (DaemonSet item : items) {DaemonSetBuilder builder = new DaemonSetBuilder(item);_visitables.add(builder);this.daemonSetItems.add(builder);} return (T)this;
    }
    public T removeFromDaemonSetItems( DaemonSet ...items){
    for (DaemonSet item : items) {DaemonSetBuilder builder = new DaemonSetBuilder(item);_visitables.remove(builder);this.daemonSetItems.remove(builder);} return (T)this;
    }
    public DaemonSetItemsNested<T> addNewDaemonSetItem(){
    return new DaemonSetItemsNestedImpl<T>();
    }
    public DaemonSetItemsNested<T> addNewDaemonSetItemLike( DaemonSet item){
    return new DaemonSetItemsNestedImpl<T>(item);
    }
    public T addToUserItems( User ...items){
    for (User item : items) {UserBuilder builder = new UserBuilder(item);_visitables.add(builder);this.userItems.add(builder);} return (T)this;
    }
    public T removeFromUserItems( User ...items){
    for (User item : items) {UserBuilder builder = new UserBuilder(item);_visitables.remove(builder);this.userItems.remove(builder);} return (T)this;
    }
    public UserItemsNested<T> addNewUserItem(){
    return new UserItemsNestedImpl<T>();
    }
    public UserItemsNested<T> addNewUserItemLike( User item){
    return new UserItemsNestedImpl<T>(item);
    }
    public T addToBuildRequestItems( BuildRequest ...items){
    for (BuildRequest item : items) {BuildRequestBuilder builder = new BuildRequestBuilder(item);_visitables.add(builder);this.buildRequestItems.add(builder);} return (T)this;
    }
    public T removeFromBuildRequestItems( BuildRequest ...items){
    for (BuildRequest item : items) {BuildRequestBuilder builder = new BuildRequestBuilder(item);_visitables.remove(builder);this.buildRequestItems.remove(builder);} return (T)this;
    }
    public BuildRequestItemsNested<T> addNewBuildRequestItem(){
    return new BuildRequestItemsNestedImpl<T>();
    }
    public BuildRequestItemsNested<T> addNewBuildRequestItemLike( BuildRequest item){
    return new BuildRequestItemsNestedImpl<T>(item);
    }
    public T addToHorizontalPodAutoscalerItems( HorizontalPodAutoscaler ...items){
    for (HorizontalPodAutoscaler item : items) {HorizontalPodAutoscalerBuilder builder = new HorizontalPodAutoscalerBuilder(item);_visitables.add(builder);this.horizontalPodAutoscalerItems.add(builder);} return (T)this;
    }
    public T removeFromHorizontalPodAutoscalerItems( HorizontalPodAutoscaler ...items){
    for (HorizontalPodAutoscaler item : items) {HorizontalPodAutoscalerBuilder builder = new HorizontalPodAutoscalerBuilder(item);_visitables.remove(builder);this.horizontalPodAutoscalerItems.remove(builder);} return (T)this;
    }
    public HorizontalPodAutoscalerItemsNested<T> addNewHorizontalPodAutoscalerItem(){
    return new HorizontalPodAutoscalerItemsNestedImpl<T>();
    }
    public HorizontalPodAutoscalerItemsNested<T> addNewHorizontalPodAutoscalerItemLike( HorizontalPodAutoscaler item){
    return new HorizontalPodAutoscalerItemsNestedImpl<T>(item);
    }
    public T addToLimitRangeItems( LimitRange ...items){
    for (LimitRange item : items) {LimitRangeBuilder builder = new LimitRangeBuilder(item);_visitables.add(builder);this.limitRangeItems.add(builder);} return (T)this;
    }
    public T removeFromLimitRangeItems( LimitRange ...items){
    for (LimitRange item : items) {LimitRangeBuilder builder = new LimitRangeBuilder(item);_visitables.remove(builder);this.limitRangeItems.remove(builder);} return (T)this;
    }
    public LimitRangeItemsNested<T> addNewLimitRangeItem(){
    return new LimitRangeItemsNestedImpl<T>();
    }
    public LimitRangeItemsNested<T> addNewLimitRangeItemLike( LimitRange item){
    return new LimitRangeItemsNestedImpl<T>(item);
    }
    public T addToServiceAccountItems( ServiceAccount ...items){
    for (ServiceAccount item : items) {ServiceAccountBuilder builder = new ServiceAccountBuilder(item);_visitables.add(builder);this.serviceAccountItems.add(builder);} return (T)this;
    }
    public T removeFromServiceAccountItems( ServiceAccount ...items){
    for (ServiceAccount item : items) {ServiceAccountBuilder builder = new ServiceAccountBuilder(item);_visitables.remove(builder);this.serviceAccountItems.remove(builder);} return (T)this;
    }
    public ServiceAccountItemsNested<T> addNewServiceAccountItem(){
    return new ServiceAccountItemsNestedImpl<T>();
    }
    public ServiceAccountItemsNested<T> addNewServiceAccountItemLike( ServiceAccount item){
    return new ServiceAccountItemsNestedImpl<T>(item);
    }
    public T addToProjectItems( Project ...items){
    for (Project item : items) {ProjectBuilder builder = new ProjectBuilder(item);_visitables.add(builder);this.projectItems.add(builder);} return (T)this;
    }
    public T removeFromProjectItems( Project ...items){
    for (Project item : items) {ProjectBuilder builder = new ProjectBuilder(item);_visitables.remove(builder);this.projectItems.remove(builder);} return (T)this;
    }
    public ProjectItemsNested<T> addNewProjectItem(){
    return new ProjectItemsNestedImpl<T>();
    }
    public ProjectItemsNested<T> addNewProjectItemLike( Project item){
    return new ProjectItemsNestedImpl<T>(item);
    }
    public T addToSecurityContextConstraintsItems( SecurityContextConstraints ...items){
    for (SecurityContextConstraints item : items) {SecurityContextConstraintsBuilder builder = new SecurityContextConstraintsBuilder(item);_visitables.add(builder);this.securityContextConstraintsItems.add(builder);} return (T)this;
    }
    public T removeFromSecurityContextConstraintsItems( SecurityContextConstraints ...items){
    for (SecurityContextConstraints item : items) {SecurityContextConstraintsBuilder builder = new SecurityContextConstraintsBuilder(item);_visitables.remove(builder);this.securityContextConstraintsItems.remove(builder);} return (T)this;
    }
    public SecurityContextConstraintsItemsNested<T> addNewSecurityContextConstraintsItem(){
    return new SecurityContextConstraintsItemsNestedImpl<T>();
    }
    public SecurityContextConstraintsItemsNested<T> addNewSecurityContextConstraintsItemLike( SecurityContextConstraints item){
    return new SecurityContextConstraintsItemsNestedImpl<T>(item);
    }
    public T addToNamespaceItems( Namespace ...items){
    for (Namespace item : items) {NamespaceBuilder builder = new NamespaceBuilder(item);_visitables.add(builder);this.namespaceItems.add(builder);} return (T)this;
    }
    public T removeFromNamespaceItems( Namespace ...items){
    for (Namespace item : items) {NamespaceBuilder builder = new NamespaceBuilder(item);_visitables.remove(builder);this.namespaceItems.remove(builder);} return (T)this;
    }
    public NamespaceItemsNested<T> addNewNamespaceItem(){
    return new NamespaceItemsNestedImpl<T>();
    }
    public NamespaceItemsNested<T> addNewNamespaceItemLike( Namespace item){
    return new NamespaceItemsNestedImpl<T>(item);
    }
    public T addToThirdPartyResourceItems( ThirdPartyResource ...items){
    for (ThirdPartyResource item : items) {ThirdPartyResourceBuilder builder = new ThirdPartyResourceBuilder(item);_visitables.add(builder);this.thirdPartyResourceItems.add(builder);} return (T)this;
    }
    public T removeFromThirdPartyResourceItems( ThirdPartyResource ...items){
    for (ThirdPartyResource item : items) {ThirdPartyResourceBuilder builder = new ThirdPartyResourceBuilder(item);_visitables.remove(builder);this.thirdPartyResourceItems.remove(builder);} return (T)this;
    }
    public ThirdPartyResourceItemsNested<T> addNewThirdPartyResourceItem(){
    return new ThirdPartyResourceItemsNestedImpl<T>();
    }
    public ThirdPartyResourceItemsNested<T> addNewThirdPartyResourceItemLike( ThirdPartyResource item){
    return new ThirdPartyResourceItemsNestedImpl<T>(item);
    }
    public T addToNodeItems( Node ...items){
    for (Node item : items) {NodeBuilder builder = new NodeBuilder(item);_visitables.add(builder);this.nodeItems.add(builder);} return (T)this;
    }
    public T removeFromNodeItems( Node ...items){
    for (Node item : items) {NodeBuilder builder = new NodeBuilder(item);_visitables.remove(builder);this.nodeItems.remove(builder);} return (T)this;
    }
    public NodeItemsNested<T> addNewNodeItem(){
    return new NodeItemsNestedImpl<T>();
    }
    public NodeItemsNested<T> addNewNodeItemLike( Node item){
    return new NodeItemsNestedImpl<T>(item);
    }
    public T addToTemplateItems( Template ...items){
    for (Template item : items) {TemplateBuilder builder = new TemplateBuilder(item);_visitables.add(builder);this.templateItems.add(builder);} return (T)this;
    }
    public T removeFromTemplateItems( Template ...items){
    for (Template item : items) {TemplateBuilder builder = new TemplateBuilder(item);_visitables.remove(builder);this.templateItems.remove(builder);} return (T)this;
    }
    public TemplateItemsNested<T> addNewTemplateItem(){
    return new TemplateItemsNestedImpl<T>();
    }
    public TemplateItemsNested<T> addNewTemplateItemLike( Template item){
    return new TemplateItemsNestedImpl<T>(item);
    }
    public T addToPodItems( Pod ...items){
    for (Pod item : items) {PodBuilder builder = new PodBuilder(item);_visitables.add(builder);this.podItems.add(builder);} return (T)this;
    }
    public T removeFromPodItems( Pod ...items){
    for (Pod item : items) {PodBuilder builder = new PodBuilder(item);_visitables.remove(builder);this.podItems.remove(builder);} return (T)this;
    }
    public PodItemsNested<T> addNewPodItem(){
    return new PodItemsNestedImpl<T>();
    }
    public PodItemsNested<T> addNewPodItemLike( Pod item){
    return new PodItemsNestedImpl<T>(item);
    }
    public T addToRoleItems( Role ...items){
    for (Role item : items) {RoleBuilder builder = new RoleBuilder(item);_visitables.add(builder);this.roleItems.add(builder);} return (T)this;
    }
    public T removeFromRoleItems( Role ...items){
    for (Role item : items) {RoleBuilder builder = new RoleBuilder(item);_visitables.remove(builder);this.roleItems.remove(builder);} return (T)this;
    }
    public RoleItemsNested<T> addNewRoleItem(){
    return new RoleItemsNestedImpl<T>();
    }
    public RoleItemsNested<T> addNewRoleItemLike( Role item){
    return new RoleItemsNestedImpl<T>(item);
    }
    public T addToDeploymentConfigItems( DeploymentConfig ...items){
    for (DeploymentConfig item : items) {DeploymentConfigBuilder builder = new DeploymentConfigBuilder(item);_visitables.add(builder);this.deploymentConfigItems.add(builder);} return (T)this;
    }
    public T removeFromDeploymentConfigItems( DeploymentConfig ...items){
    for (DeploymentConfig item : items) {DeploymentConfigBuilder builder = new DeploymentConfigBuilder(item);_visitables.remove(builder);this.deploymentConfigItems.remove(builder);} return (T)this;
    }
    public DeploymentConfigItemsNested<T> addNewDeploymentConfigItem(){
    return new DeploymentConfigItemsNestedImpl<T>();
    }
    public DeploymentConfigItemsNested<T> addNewDeploymentConfigItemLike( DeploymentConfig item){
    return new DeploymentConfigItemsNestedImpl<T>(item);
    }
    public T addToClusterPolicyItems( ClusterPolicy ...items){
    for (ClusterPolicy item : items) {ClusterPolicyBuilder builder = new ClusterPolicyBuilder(item);_visitables.add(builder);this.clusterPolicyItems.add(builder);} return (T)this;
    }
    public T removeFromClusterPolicyItems( ClusterPolicy ...items){
    for (ClusterPolicy item : items) {ClusterPolicyBuilder builder = new ClusterPolicyBuilder(item);_visitables.remove(builder);this.clusterPolicyItems.remove(builder);} return (T)this;
    }
    public ClusterPolicyItemsNested<T> addNewClusterPolicyItem(){
    return new ClusterPolicyItemsNestedImpl<T>();
    }
    public ClusterPolicyItemsNested<T> addNewClusterPolicyItemLike( ClusterPolicy item){
    return new ClusterPolicyItemsNestedImpl<T>(item);
    }
    public T addToIdentityItems( Identity ...items){
    for (Identity item : items) {IdentityBuilder builder = new IdentityBuilder(item);_visitables.add(builder);this.identityItems.add(builder);} return (T)this;
    }
    public T removeFromIdentityItems( Identity ...items){
    for (Identity item : items) {IdentityBuilder builder = new IdentityBuilder(item);_visitables.remove(builder);this.identityItems.remove(builder);} return (T)this;
    }
    public IdentityItemsNested<T> addNewIdentityItem(){
    return new IdentityItemsNestedImpl<T>();
    }
    public IdentityItemsNested<T> addNewIdentityItemLike( Identity item){
    return new IdentityItemsNestedImpl<T>(item);
    }
    public T addToOAuthClientItems( OAuthClient ...items){
    for (OAuthClient item : items) {OAuthClientBuilder builder = new OAuthClientBuilder(item);_visitables.add(builder);this.oAuthClientItems.add(builder);} return (T)this;
    }
    public T removeFromOAuthClientItems( OAuthClient ...items){
    for (OAuthClient item : items) {OAuthClientBuilder builder = new OAuthClientBuilder(item);_visitables.remove(builder);this.oAuthClientItems.remove(builder);} return (T)this;
    }
    public OAuthClientItemsNested<T> addNewOAuthClientItem(){
    return new OAuthClientItemsNestedImpl<T>();
    }
    public OAuthClientItemsNested<T> addNewOAuthClientItemLike( OAuthClient item){
    return new OAuthClientItemsNestedImpl<T>(item);
    }
    public T addToOAuthClientAuthorizationItems( OAuthClientAuthorization ...items){
    for (OAuthClientAuthorization item : items) {OAuthClientAuthorizationBuilder builder = new OAuthClientAuthorizationBuilder(item);_visitables.add(builder);this.oAuthClientAuthorizationItems.add(builder);} return (T)this;
    }
    public T removeFromOAuthClientAuthorizationItems( OAuthClientAuthorization ...items){
    for (OAuthClientAuthorization item : items) {OAuthClientAuthorizationBuilder builder = new OAuthClientAuthorizationBuilder(item);_visitables.remove(builder);this.oAuthClientAuthorizationItems.remove(builder);} return (T)this;
    }
    public OAuthClientAuthorizationItemsNested<T> addNewOAuthClientAuthorizationItem(){
    return new OAuthClientAuthorizationItemsNestedImpl<T>();
    }
    public OAuthClientAuthorizationItemsNested<T> addNewOAuthClientAuthorizationItemLike( OAuthClientAuthorization item){
    return new OAuthClientAuthorizationItemsNestedImpl<T>(item);
    }
    public T addToRoleBindingItems( RoleBinding ...items){
    for (RoleBinding item : items) {RoleBindingBuilder builder = new RoleBindingBuilder(item);_visitables.add(builder);this.roleBindingItems.add(builder);} return (T)this;
    }
    public T removeFromRoleBindingItems( RoleBinding ...items){
    for (RoleBinding item : items) {RoleBindingBuilder builder = new RoleBindingBuilder(item);_visitables.remove(builder);this.roleBindingItems.remove(builder);} return (T)this;
    }
    public RoleBindingItemsNested<T> addNewRoleBindingItem(){
    return new RoleBindingItemsNestedImpl<T>();
    }
    public RoleBindingItemsNested<T> addNewRoleBindingItemLike( RoleBinding item){
    return new RoleBindingItemsNestedImpl<T>(item);
    }
    public T addToClusterRoleBindingItems( ClusterRoleBinding ...items){
    for (ClusterRoleBinding item : items) {ClusterRoleBindingBuilder builder = new ClusterRoleBindingBuilder(item);_visitables.add(builder);this.clusterRoleBindingItems.add(builder);} return (T)this;
    }
    public T removeFromClusterRoleBindingItems( ClusterRoleBinding ...items){
    for (ClusterRoleBinding item : items) {ClusterRoleBindingBuilder builder = new ClusterRoleBindingBuilder(item);_visitables.remove(builder);this.clusterRoleBindingItems.remove(builder);} return (T)this;
    }
    public ClusterRoleBindingItemsNested<T> addNewClusterRoleBindingItem(){
    return new ClusterRoleBindingItemsNestedImpl<T>();
    }
    public ClusterRoleBindingItemsNested<T> addNewClusterRoleBindingItemLike( ClusterRoleBinding item){
    return new ClusterRoleBindingItemsNestedImpl<T>(item);
    }
    public T addToScaleItems( Scale ...items){
    for (Scale item : items) {ScaleBuilder builder = new ScaleBuilder(item);_visitables.add(builder);this.scaleItems.add(builder);} return (T)this;
    }
    public T removeFromScaleItems( Scale ...items){
    for (Scale item : items) {ScaleBuilder builder = new ScaleBuilder(item);_visitables.remove(builder);this.scaleItems.remove(builder);} return (T)this;
    }
    public ScaleItemsNested<T> addNewScaleItem(){
    return new ScaleItemsNestedImpl<T>();
    }
    public ScaleItemsNested<T> addNewScaleItemLike( Scale item){
    return new ScaleItemsNestedImpl<T>(item);
    }
    public T addToBindingItems( Binding ...items){
    for (Binding item : items) {BindingBuilder builder = new BindingBuilder(item);_visitables.add(builder);this.bindingItems.add(builder);} return (T)this;
    }
    public T removeFromBindingItems( Binding ...items){
    for (Binding item : items) {BindingBuilder builder = new BindingBuilder(item);_visitables.remove(builder);this.bindingItems.remove(builder);} return (T)this;
    }
    public BindingItemsNested<T> addNewBindingItem(){
    return new BindingItemsNestedImpl<T>();
    }
    public BindingItemsNested<T> addNewBindingItemLike( Binding item){
    return new BindingItemsNestedImpl<T>(item);
    }
    public T addToPolicyBindingItems( PolicyBinding ...items){
    for (PolicyBinding item : items) {PolicyBindingBuilder builder = new PolicyBindingBuilder(item);_visitables.add(builder);this.policyBindingItems.add(builder);} return (T)this;
    }
    public T removeFromPolicyBindingItems( PolicyBinding ...items){
    for (PolicyBinding item : items) {PolicyBindingBuilder builder = new PolicyBindingBuilder(item);_visitables.remove(builder);this.policyBindingItems.remove(builder);} return (T)this;
    }
    public PolicyBindingItemsNested<T> addNewPolicyBindingItem(){
    return new PolicyBindingItemsNestedImpl<T>();
    }
    public PolicyBindingItemsNested<T> addNewPolicyBindingItemLike( PolicyBinding item){
    return new PolicyBindingItemsNestedImpl<T>(item);
    }
    public T addToClusterPolicyBindingItems( ClusterPolicyBinding ...items){
    for (ClusterPolicyBinding item : items) {ClusterPolicyBindingBuilder builder = new ClusterPolicyBindingBuilder(item);_visitables.add(builder);this.clusterPolicyBindingItems.add(builder);} return (T)this;
    }
    public T removeFromClusterPolicyBindingItems( ClusterPolicyBinding ...items){
    for (ClusterPolicyBinding item : items) {ClusterPolicyBindingBuilder builder = new ClusterPolicyBindingBuilder(item);_visitables.remove(builder);this.clusterPolicyBindingItems.remove(builder);} return (T)this;
    }
    public ClusterPolicyBindingItemsNested<T> addNewClusterPolicyBindingItem(){
    return new ClusterPolicyBindingItemsNestedImpl<T>();
    }
    public ClusterPolicyBindingItemsNested<T> addNewClusterPolicyBindingItemLike( ClusterPolicyBinding item){
    return new ClusterPolicyBindingItemsNestedImpl<T>(item);
    }
    public T addToImageStreamItems( ImageStream ...items){
    for (ImageStream item : items) {ImageStreamBuilder builder = new ImageStreamBuilder(item);_visitables.add(builder);this.imageStreamItems.add(builder);} return (T)this;
    }
    public T removeFromImageStreamItems( ImageStream ...items){
    for (ImageStream item : items) {ImageStreamBuilder builder = new ImageStreamBuilder(item);_visitables.remove(builder);this.imageStreamItems.remove(builder);} return (T)this;
    }
    public ImageStreamItemsNested<T> addNewImageStreamItem(){
    return new ImageStreamItemsNestedImpl<T>();
    }
    public ImageStreamItemsNested<T> addNewImageStreamItemLike( ImageStream item){
    return new ImageStreamItemsNestedImpl<T>(item);
    }
    public T addToIngressItems( Ingress ...items){
    for (Ingress item : items) {IngressBuilder builder = new IngressBuilder(item);_visitables.add(builder);this.ingressItems.add(builder);} return (T)this;
    }
    public T removeFromIngressItems( Ingress ...items){
    for (Ingress item : items) {IngressBuilder builder = new IngressBuilder(item);_visitables.remove(builder);this.ingressItems.remove(builder);} return (T)this;
    }
    public IngressItemsNested<T> addNewIngressItem(){
    return new IngressItemsNestedImpl<T>();
    }
    public IngressItemsNested<T> addNewIngressItemLike( Ingress item){
    return new IngressItemsNestedImpl<T>(item);
    }
    public T addToComponentStatusItems( ComponentStatus ...items){
    for (ComponentStatus item : items) {ComponentStatusBuilder builder = new ComponentStatusBuilder(item);_visitables.add(builder);this.componentStatusItems.add(builder);} return (T)this;
    }
    public T removeFromComponentStatusItems( ComponentStatus ...items){
    for (ComponentStatus item : items) {ComponentStatusBuilder builder = new ComponentStatusBuilder(item);_visitables.remove(builder);this.componentStatusItems.remove(builder);} return (T)this;
    }
    public ComponentStatusItemsNested<T> addNewComponentStatusItem(){
    return new ComponentStatusItemsNestedImpl<T>();
    }
    public ComponentStatusItemsNested<T> addNewComponentStatusItemLike( ComponentStatus item){
    return new ComponentStatusItemsNestedImpl<T>(item);
    }
    public T addToEndpointsItems( Endpoints ...items){
    for (Endpoints item : items) {EndpointsBuilder builder = new EndpointsBuilder(item);_visitables.add(builder);this.endpointsItems.add(builder);} return (T)this;
    }
    public T removeFromEndpointsItems( Endpoints ...items){
    for (Endpoints item : items) {EndpointsBuilder builder = new EndpointsBuilder(item);_visitables.remove(builder);this.endpointsItems.remove(builder);} return (T)this;
    }
    public EndpointsItemsNested<T> addNewEndpointsItem(){
    return new EndpointsItemsNestedImpl<T>();
    }
    public EndpointsItemsNested<T> addNewEndpointsItemLike( Endpoints item){
    return new EndpointsItemsNestedImpl<T>(item);
    }
    public T addToProjectRequestItems( ProjectRequest ...items){
    for (ProjectRequest item : items) {ProjectRequestBuilder builder = new ProjectRequestBuilder(item);_visitables.add(builder);this.projectRequestItems.add(builder);} return (T)this;
    }
    public T removeFromProjectRequestItems( ProjectRequest ...items){
    for (ProjectRequest item : items) {ProjectRequestBuilder builder = new ProjectRequestBuilder(item);_visitables.remove(builder);this.projectRequestItems.remove(builder);} return (T)this;
    }
    public ProjectRequestItemsNested<T> addNewProjectRequestItem(){
    return new ProjectRequestItemsNestedImpl<T>();
    }
    public ProjectRequestItemsNested<T> addNewProjectRequestItemLike( ProjectRequest item){
    return new ProjectRequestItemsNestedImpl<T>(item);
    }
    public T addToResourceQuotaItems( ResourceQuota ...items){
    for (ResourceQuota item : items) {ResourceQuotaBuilder builder = new ResourceQuotaBuilder(item);_visitables.add(builder);this.resourceQuotaItems.add(builder);} return (T)this;
    }
    public T removeFromResourceQuotaItems( ResourceQuota ...items){
    for (ResourceQuota item : items) {ResourceQuotaBuilder builder = new ResourceQuotaBuilder(item);_visitables.remove(builder);this.resourceQuotaItems.remove(builder);} return (T)this;
    }
    public ResourceQuotaItemsNested<T> addNewResourceQuotaItem(){
    return new ResourceQuotaItemsNestedImpl<T>();
    }
    public ResourceQuotaItemsNested<T> addNewResourceQuotaItemLike( ResourceQuota item){
    return new ResourceQuotaItemsNestedImpl<T>(item);
    }
    public T addToServiceItems( Service ...items){
    for (Service item : items) {ServiceBuilder builder = new ServiceBuilder(item);_visitables.add(builder);this.serviceItems.add(builder);} return (T)this;
    }
    public T removeFromServiceItems( Service ...items){
    for (Service item : items) {ServiceBuilder builder = new ServiceBuilder(item);_visitables.remove(builder);this.serviceItems.remove(builder);} return (T)this;
    }
    public ServiceItemsNested<T> addNewServiceItem(){
    return new ServiceItemsNestedImpl<T>();
    }
    public ServiceItemsNested<T> addNewServiceItemLike( Service item){
    return new ServiceItemsNestedImpl<T>(item);
    }
    public T addToPodTemplateItems( PodTemplate ...items){
    for (PodTemplate item : items) {PodTemplateBuilder builder = new PodTemplateBuilder(item);_visitables.add(builder);this.podTemplateItems.add(builder);} return (T)this;
    }
    public T removeFromPodTemplateItems( PodTemplate ...items){
    for (PodTemplate item : items) {PodTemplateBuilder builder = new PodTemplateBuilder(item);_visitables.remove(builder);this.podTemplateItems.remove(builder);} return (T)this;
    }
    public PodTemplateItemsNested<T> addNewPodTemplateItem(){
    return new PodTemplateItemsNestedImpl<T>();
    }
    public PodTemplateItemsNested<T> addNewPodTemplateItemLike( PodTemplate item){
    return new PodTemplateItemsNestedImpl<T>(item);
    }
    public T addToPolicyItems( Policy ...items){
    for (Policy item : items) {PolicyBuilder builder = new PolicyBuilder(item);_visitables.add(builder);this.policyItems.add(builder);} return (T)this;
    }
    public T removeFromPolicyItems( Policy ...items){
    for (Policy item : items) {PolicyBuilder builder = new PolicyBuilder(item);_visitables.remove(builder);this.policyItems.remove(builder);} return (T)this;
    }
    public PolicyItemsNested<T> addNewPolicyItem(){
    return new PolicyItemsNestedImpl<T>();
    }
    public PolicyItemsNested<T> addNewPolicyItemLike( Policy item){
    return new PolicyItemsNestedImpl<T>(item);
    }
    public T addToClusterRoleItems( ClusterRole ...items){
    for (ClusterRole item : items) {ClusterRoleBuilder builder = new ClusterRoleBuilder(item);_visitables.add(builder);this.clusterRoleItems.add(builder);} return (T)this;
    }
    public T removeFromClusterRoleItems( ClusterRole ...items){
    for (ClusterRole item : items) {ClusterRoleBuilder builder = new ClusterRoleBuilder(item);_visitables.remove(builder);this.clusterRoleItems.remove(builder);} return (T)this;
    }
    public ClusterRoleItemsNested<T> addNewClusterRoleItem(){
    return new ClusterRoleItemsNestedImpl<T>();
    }
    public ClusterRoleItemsNested<T> addNewClusterRoleItemLike( ClusterRole item){
    return new ClusterRoleItemsNestedImpl<T>(item);
    }
    public T addToRouteItems( Route ...items){
    for (Route item : items) {RouteBuilder builder = new RouteBuilder(item);_visitables.add(builder);this.routeItems.add(builder);} return (T)this;
    }
    public T removeFromRouteItems( Route ...items){
    for (Route item : items) {RouteBuilder builder = new RouteBuilder(item);_visitables.remove(builder);this.routeItems.remove(builder);} return (T)this;
    }
    public RouteItemsNested<T> addNewRouteItem(){
    return new RouteItemsNestedImpl<T>();
    }
    public RouteItemsNested<T> addNewRouteItemLike( Route item){
    return new RouteItemsNestedImpl<T>(item);
    }
    public T addToPersistentVolumeClaimItems( PersistentVolumeClaim ...items){
    for (PersistentVolumeClaim item : items) {PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.add(builder);this.persistentVolumeClaimItems.add(builder);} return (T)this;
    }
    public T removeFromPersistentVolumeClaimItems( PersistentVolumeClaim ...items){
    for (PersistentVolumeClaim item : items) {PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.remove(builder);this.persistentVolumeClaimItems.remove(builder);} return (T)this;
    }
    public PersistentVolumeClaimItemsNested<T> addNewPersistentVolumeClaimItem(){
    return new PersistentVolumeClaimItemsNestedImpl<T>();
    }
    public PersistentVolumeClaimItemsNested<T> addNewPersistentVolumeClaimItemLike( PersistentVolumeClaim item){
    return new PersistentVolumeClaimItemsNestedImpl<T>(item);
    }
    public T addToReplicationControllerItems( ReplicationController ...items){
    for (ReplicationController item : items) {ReplicationControllerBuilder builder = new ReplicationControllerBuilder(item);_visitables.add(builder);this.replicationControllerItems.add(builder);} return (T)this;
    }
    public T removeFromReplicationControllerItems( ReplicationController ...items){
    for (ReplicationController item : items) {ReplicationControllerBuilder builder = new ReplicationControllerBuilder(item);_visitables.remove(builder);this.replicationControllerItems.remove(builder);} return (T)this;
    }
    public ReplicationControllerItemsNested<T> addNewReplicationControllerItem(){
    return new ReplicationControllerItemsNestedImpl<T>();
    }
    public ReplicationControllerItemsNested<T> addNewReplicationControllerItemLike( ReplicationController item){
    return new ReplicationControllerItemsNestedImpl<T>(item);
    }
    public T addToImageItems( Image ...items){
    for (Image item : items) {ImageBuilder builder = new ImageBuilder(item);_visitables.add(builder);this.imageItems.add(builder);} return (T)this;
    }
    public T removeFromImageItems( Image ...items){
    for (Image item : items) {ImageBuilder builder = new ImageBuilder(item);_visitables.remove(builder);this.imageItems.remove(builder);} return (T)this;
    }
    public ImageItemsNested<T> addNewImageItem(){
    return new ImageItemsNestedImpl<T>();
    }
    public ImageItemsNested<T> addNewImageItemLike( Image item){
    return new ImageItemsNestedImpl<T>(item);
    }
    public T addToGroupItems( Group ...items){
    for (Group item : items) {GroupBuilder builder = new GroupBuilder(item);_visitables.add(builder);this.groupItems.add(builder);} return (T)this;
    }
    public T removeFromGroupItems( Group ...items){
    for (Group item : items) {GroupBuilder builder = new GroupBuilder(item);_visitables.remove(builder);this.groupItems.remove(builder);} return (T)this;
    }
    public GroupItemsNested<T> addNewGroupItem(){
    return new GroupItemsNestedImpl<T>();
    }
    public GroupItemsNested<T> addNewGroupItemLike( Group item){
    return new GroupItemsNestedImpl<T>(item);
    }
    public T addToOAuthAuthorizeTokenItems( OAuthAuthorizeToken ...items){
    for (OAuthAuthorizeToken item : items) {OAuthAuthorizeTokenBuilder builder = new OAuthAuthorizeTokenBuilder(item);_visitables.add(builder);this.oAuthAuthorizeTokenItems.add(builder);} return (T)this;
    }
    public T removeFromOAuthAuthorizeTokenItems( OAuthAuthorizeToken ...items){
    for (OAuthAuthorizeToken item : items) {OAuthAuthorizeTokenBuilder builder = new OAuthAuthorizeTokenBuilder(item);_visitables.remove(builder);this.oAuthAuthorizeTokenItems.remove(builder);} return (T)this;
    }
    public OAuthAuthorizeTokenItemsNested<T> addNewOAuthAuthorizeTokenItem(){
    return new OAuthAuthorizeTokenItemsNestedImpl<T>();
    }
    public OAuthAuthorizeTokenItemsNested<T> addNewOAuthAuthorizeTokenItemLike( OAuthAuthorizeToken item){
    return new OAuthAuthorizeTokenItemsNestedImpl<T>(item);
    }
    public T addToBuildConfigItems( BuildConfig ...items){
    for (BuildConfig item : items) {BuildConfigBuilder builder = new BuildConfigBuilder(item);_visitables.add(builder);this.buildConfigItems.add(builder);} return (T)this;
    }
    public T removeFromBuildConfigItems( BuildConfig ...items){
    for (BuildConfig item : items) {BuildConfigBuilder builder = new BuildConfigBuilder(item);_visitables.remove(builder);this.buildConfigItems.remove(builder);} return (T)this;
    }
    public BuildConfigItemsNested<T> addNewBuildConfigItem(){
    return new BuildConfigItemsNestedImpl<T>();
    }
    public BuildConfigItemsNested<T> addNewBuildConfigItemLike( BuildConfig item){
    return new BuildConfigItemsNestedImpl<T>(item);
    }
    public T addToEventItems( Event ...items){
    for (Event item : items) {EventBuilder builder = new EventBuilder(item);_visitables.add(builder);this.eventItems.add(builder);} return (T)this;
    }
    public T removeFromEventItems( Event ...items){
    for (Event item : items) {EventBuilder builder = new EventBuilder(item);_visitables.remove(builder);this.eventItems.remove(builder);} return (T)this;
    }
    public EventItemsNested<T> addNewEventItem(){
    return new EventItemsNestedImpl<T>();
    }
    public EventItemsNested<T> addNewEventItemLike( Event item){
    return new EventItemsNestedImpl<T>(item);
    }
    public String getKind(){
    return this.kind;
    }
    public T withKind( String kind){
    this.kind=kind; return (T) this;
    }
    public ListMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public T withMetadata( ListMeta metadata){
    if (metadata!=null){ this.metadata= new ListMetaBuilder(metadata); _visitables.add(this.metadata);} return (T) this;
    }
    public MetadataNested<T> withNewMetadata(){
    return new MetadataNestedImpl<T>();
    }
    public MetadataNested<T> withNewMetadataLike( ListMeta item){
    return new MetadataNestedImpl<T>(item);
    }
    public MetadataNested<T> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public T withNewMetadata( String resourceVersion,  String selfLink){
    return withMetadata(new ListMeta(resourceVersion, selfLink));
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
BaseKubernetesListFluentImpl that = (BaseKubernetesListFluentImpl) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (items != null ? !items.equals(that.items) :that.items != null) return false;
if (jobItems != null ? !jobItems.equals(that.jobItems) :that.jobItems != null) return false;
if (oAuthAccessTokenItems != null ? !oAuthAccessTokenItems.equals(that.oAuthAccessTokenItems) :that.oAuthAccessTokenItems != null) return false;
if (deploymentItems != null ? !deploymentItems.equals(that.deploymentItems) :that.deploymentItems != null) return false;
if (secretItems != null ? !secretItems.equals(that.secretItems) :that.secretItems != null) return false;
if (persistentVolumeItems != null ? !persistentVolumeItems.equals(that.persistentVolumeItems) :that.persistentVolumeItems != null) return false;
if (buildItems != null ? !buildItems.equals(that.buildItems) :that.buildItems != null) return false;
if (daemonSetItems != null ? !daemonSetItems.equals(that.daemonSetItems) :that.daemonSetItems != null) return false;
if (userItems != null ? !userItems.equals(that.userItems) :that.userItems != null) return false;
if (buildRequestItems != null ? !buildRequestItems.equals(that.buildRequestItems) :that.buildRequestItems != null) return false;
if (horizontalPodAutoscalerItems != null ? !horizontalPodAutoscalerItems.equals(that.horizontalPodAutoscalerItems) :that.horizontalPodAutoscalerItems != null) return false;
if (limitRangeItems != null ? !limitRangeItems.equals(that.limitRangeItems) :that.limitRangeItems != null) return false;
if (serviceAccountItems != null ? !serviceAccountItems.equals(that.serviceAccountItems) :that.serviceAccountItems != null) return false;
if (projectItems != null ? !projectItems.equals(that.projectItems) :that.projectItems != null) return false;
if (securityContextConstraintsItems != null ? !securityContextConstraintsItems.equals(that.securityContextConstraintsItems) :that.securityContextConstraintsItems != null) return false;
if (namespaceItems != null ? !namespaceItems.equals(that.namespaceItems) :that.namespaceItems != null) return false;
if (thirdPartyResourceItems != null ? !thirdPartyResourceItems.equals(that.thirdPartyResourceItems) :that.thirdPartyResourceItems != null) return false;
if (nodeItems != null ? !nodeItems.equals(that.nodeItems) :that.nodeItems != null) return false;
if (templateItems != null ? !templateItems.equals(that.templateItems) :that.templateItems != null) return false;
if (podItems != null ? !podItems.equals(that.podItems) :that.podItems != null) return false;
if (roleItems != null ? !roleItems.equals(that.roleItems) :that.roleItems != null) return false;
if (deploymentConfigItems != null ? !deploymentConfigItems.equals(that.deploymentConfigItems) :that.deploymentConfigItems != null) return false;
if (clusterPolicyItems != null ? !clusterPolicyItems.equals(that.clusterPolicyItems) :that.clusterPolicyItems != null) return false;
if (identityItems != null ? !identityItems.equals(that.identityItems) :that.identityItems != null) return false;
if (oAuthClientItems != null ? !oAuthClientItems.equals(that.oAuthClientItems) :that.oAuthClientItems != null) return false;
if (oAuthClientAuthorizationItems != null ? !oAuthClientAuthorizationItems.equals(that.oAuthClientAuthorizationItems) :that.oAuthClientAuthorizationItems != null) return false;
if (roleBindingItems != null ? !roleBindingItems.equals(that.roleBindingItems) :that.roleBindingItems != null) return false;
if (clusterRoleBindingItems != null ? !clusterRoleBindingItems.equals(that.clusterRoleBindingItems) :that.clusterRoleBindingItems != null) return false;
if (scaleItems != null ? !scaleItems.equals(that.scaleItems) :that.scaleItems != null) return false;
if (bindingItems != null ? !bindingItems.equals(that.bindingItems) :that.bindingItems != null) return false;
if (policyBindingItems != null ? !policyBindingItems.equals(that.policyBindingItems) :that.policyBindingItems != null) return false;
if (clusterPolicyBindingItems != null ? !clusterPolicyBindingItems.equals(that.clusterPolicyBindingItems) :that.clusterPolicyBindingItems != null) return false;
if (imageStreamItems != null ? !imageStreamItems.equals(that.imageStreamItems) :that.imageStreamItems != null) return false;
if (ingressItems != null ? !ingressItems.equals(that.ingressItems) :that.ingressItems != null) return false;
if (componentStatusItems != null ? !componentStatusItems.equals(that.componentStatusItems) :that.componentStatusItems != null) return false;
if (endpointsItems != null ? !endpointsItems.equals(that.endpointsItems) :that.endpointsItems != null) return false;
if (projectRequestItems != null ? !projectRequestItems.equals(that.projectRequestItems) :that.projectRequestItems != null) return false;
if (resourceQuotaItems != null ? !resourceQuotaItems.equals(that.resourceQuotaItems) :that.resourceQuotaItems != null) return false;
if (serviceItems != null ? !serviceItems.equals(that.serviceItems) :that.serviceItems != null) return false;
if (podTemplateItems != null ? !podTemplateItems.equals(that.podTemplateItems) :that.podTemplateItems != null) return false;
if (policyItems != null ? !policyItems.equals(that.policyItems) :that.policyItems != null) return false;
if (clusterRoleItems != null ? !clusterRoleItems.equals(that.clusterRoleItems) :that.clusterRoleItems != null) return false;
if (routeItems != null ? !routeItems.equals(that.routeItems) :that.routeItems != null) return false;
if (persistentVolumeClaimItems != null ? !persistentVolumeClaimItems.equals(that.persistentVolumeClaimItems) :that.persistentVolumeClaimItems != null) return false;
if (replicationControllerItems != null ? !replicationControllerItems.equals(that.replicationControllerItems) :that.replicationControllerItems != null) return false;
if (imageItems != null ? !imageItems.equals(that.imageItems) :that.imageItems != null) return false;
if (groupItems != null ? !groupItems.equals(that.groupItems) :that.groupItems != null) return false;
if (oAuthAuthorizeTokenItems != null ? !oAuthAuthorizeTokenItems.equals(that.oAuthAuthorizeTokenItems) :that.oAuthAuthorizeTokenItems != null) return false;
if (buildConfigItems != null ? !buildConfigItems.equals(that.buildConfigItems) :that.buildConfigItems != null) return false;
if (eventItems != null ? !eventItems.equals(that.eventItems) :that.eventItems != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class JobItemsNestedImpl<N> extends JobFluentImpl<JobItemsNested<N>> implements JobItemsNested<N>{

        private final JobBuilder builder;
    
             JobItemsNestedImpl (){
        this.builder = new JobBuilder(this);
        }
             JobItemsNestedImpl ( Job item){
        this.builder = new JobBuilder(this, item);
        }
    
            public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToJobItems(builder.build());
        }
            public N endJobItem(){
            return and();
        }
    
}
    public class OAuthAccessTokenItemsNestedImpl<N> extends OAuthAccessTokenFluentImpl<OAuthAccessTokenItemsNested<N>> implements OAuthAccessTokenItemsNested<N>{

        private final OAuthAccessTokenBuilder builder;
    
             OAuthAccessTokenItemsNestedImpl (){
        this.builder = new OAuthAccessTokenBuilder(this);
        }
             OAuthAccessTokenItemsNestedImpl ( OAuthAccessToken item){
        this.builder = new OAuthAccessTokenBuilder(this, item);
        }
    
            public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToOAuthAccessTokenItems(builder.build());
        }
            public N endOAuthAccessTokenItem(){
            return and();
        }
    
}
    public class DeploymentItemsNestedImpl<N> extends DeploymentFluentImpl<DeploymentItemsNested<N>> implements DeploymentItemsNested<N>{

        private final DeploymentBuilder builder;
    
             DeploymentItemsNestedImpl (){
        this.builder = new DeploymentBuilder(this);
        }
             DeploymentItemsNestedImpl ( Deployment item){
        this.builder = new DeploymentBuilder(this, item);
        }
    
            public N endDeploymentItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToDeploymentItems(builder.build());
        }
    
}
    public class SecretItemsNestedImpl<N> extends SecretFluentImpl<SecretItemsNested<N>> implements SecretItemsNested<N>{

        private final SecretBuilder builder;
    
             SecretItemsNestedImpl (){
        this.builder = new SecretBuilder(this);
        }
             SecretItemsNestedImpl ( Secret item){
        this.builder = new SecretBuilder(this, item);
        }
    
            public N endSecretItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToSecretItems(builder.build());
        }
    
}
    public class PersistentVolumeItemsNestedImpl<N> extends PersistentVolumeFluentImpl<PersistentVolumeItemsNested<N>> implements PersistentVolumeItemsNested<N>{

        private final PersistentVolumeBuilder builder;
    
             PersistentVolumeItemsNestedImpl (){
        this.builder = new PersistentVolumeBuilder(this);
        }
             PersistentVolumeItemsNestedImpl ( PersistentVolume item){
        this.builder = new PersistentVolumeBuilder(this, item);
        }
    
            public N endPersistentVolumeItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToPersistentVolumeItems(builder.build());
        }
    
}
    public class BuildItemsNestedImpl<N> extends BuildFluentImpl<BuildItemsNested<N>> implements BuildItemsNested<N>{

        private final BuildBuilder builder;
    
             BuildItemsNestedImpl (){
        this.builder = new BuildBuilder(this);
        }
             BuildItemsNestedImpl ( Build item){
        this.builder = new BuildBuilder(this, item);
        }
    
            public N endBuildItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToBuildItems(builder.build());
        }
    
}
    public class DaemonSetItemsNestedImpl<N> extends DaemonSetFluentImpl<DaemonSetItemsNested<N>> implements DaemonSetItemsNested<N>{

        private final DaemonSetBuilder builder;
    
             DaemonSetItemsNestedImpl (){
        this.builder = new DaemonSetBuilder(this);
        }
             DaemonSetItemsNestedImpl ( DaemonSet item){
        this.builder = new DaemonSetBuilder(this, item);
        }
    
            public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToDaemonSetItems(builder.build());
        }
            public N endDaemonSetItem(){
            return and();
        }
    
}
    public class UserItemsNestedImpl<N> extends UserFluentImpl<UserItemsNested<N>> implements UserItemsNested<N>{

        private final UserBuilder builder;
    
             UserItemsNestedImpl (){
        this.builder = new UserBuilder(this);
        }
             UserItemsNestedImpl ( User item){
        this.builder = new UserBuilder(this, item);
        }
    
            public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToUserItems(builder.build());
        }
            public N endUserItem(){
            return and();
        }
    
}
    public class BuildRequestItemsNestedImpl<N> extends BuildRequestFluentImpl<BuildRequestItemsNested<N>> implements BuildRequestItemsNested<N>{

        private final BuildRequestBuilder builder;
    
             BuildRequestItemsNestedImpl (){
        this.builder = new BuildRequestBuilder(this);
        }
             BuildRequestItemsNestedImpl ( BuildRequest item){
        this.builder = new BuildRequestBuilder(this, item);
        }
    
            public N endBuildRequestItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToBuildRequestItems(builder.build());
        }
    
}
    public class HorizontalPodAutoscalerItemsNestedImpl<N> extends HorizontalPodAutoscalerFluentImpl<HorizontalPodAutoscalerItemsNested<N>> implements HorizontalPodAutoscalerItemsNested<N>{

        private final HorizontalPodAutoscalerBuilder builder;
    
             HorizontalPodAutoscalerItemsNestedImpl (){
        this.builder = new HorizontalPodAutoscalerBuilder(this);
        }
             HorizontalPodAutoscalerItemsNestedImpl ( HorizontalPodAutoscaler item){
        this.builder = new HorizontalPodAutoscalerBuilder(this, item);
        }
    
            public N endHorizontalPodAutoscalerItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToHorizontalPodAutoscalerItems(builder.build());
        }
    
}
    public class LimitRangeItemsNestedImpl<N> extends LimitRangeFluentImpl<LimitRangeItemsNested<N>> implements LimitRangeItemsNested<N>{

        private final LimitRangeBuilder builder;
    
             LimitRangeItemsNestedImpl (){
        this.builder = new LimitRangeBuilder(this);
        }
             LimitRangeItemsNestedImpl ( LimitRange item){
        this.builder = new LimitRangeBuilder(this, item);
        }
    
            public N endLimitRangeItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToLimitRangeItems(builder.build());
        }
    
}
    public class ServiceAccountItemsNestedImpl<N> extends ServiceAccountFluentImpl<ServiceAccountItemsNested<N>> implements ServiceAccountItemsNested<N>{

        private final ServiceAccountBuilder builder;
    
             ServiceAccountItemsNestedImpl (){
        this.builder = new ServiceAccountBuilder(this);
        }
             ServiceAccountItemsNestedImpl ( ServiceAccount item){
        this.builder = new ServiceAccountBuilder(this, item);
        }
    
            public N endServiceAccountItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToServiceAccountItems(builder.build());
        }
    
}
    public class ProjectItemsNestedImpl<N> extends ProjectFluentImpl<ProjectItemsNested<N>> implements ProjectItemsNested<N>{

        private final ProjectBuilder builder;
    
             ProjectItemsNestedImpl (){
        this.builder = new ProjectBuilder(this);
        }
             ProjectItemsNestedImpl ( Project item){
        this.builder = new ProjectBuilder(this, item);
        }
    
            public N endProjectItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToProjectItems(builder.build());
        }
    
}
    public class SecurityContextConstraintsItemsNestedImpl<N> extends SecurityContextConstraintsFluentImpl<SecurityContextConstraintsItemsNested<N>> implements SecurityContextConstraintsItemsNested<N>{

        private final SecurityContextConstraintsBuilder builder;
    
             SecurityContextConstraintsItemsNestedImpl (){
        this.builder = new SecurityContextConstraintsBuilder(this);
        }
             SecurityContextConstraintsItemsNestedImpl ( SecurityContextConstraints item){
        this.builder = new SecurityContextConstraintsBuilder(this, item);
        }
    
            public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToSecurityContextConstraintsItems(builder.build());
        }
            public N endSecurityContextConstraintsItem(){
            return and();
        }
    
}
    public class NamespaceItemsNestedImpl<N> extends NamespaceFluentImpl<NamespaceItemsNested<N>> implements NamespaceItemsNested<N>{

        private final NamespaceBuilder builder;
    
             NamespaceItemsNestedImpl (){
        this.builder = new NamespaceBuilder(this);
        }
             NamespaceItemsNestedImpl ( Namespace item){
        this.builder = new NamespaceBuilder(this, item);
        }
    
            public N endNamespaceItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToNamespaceItems(builder.build());
        }
    
}
    public class ThirdPartyResourceItemsNestedImpl<N> extends ThirdPartyResourceFluentImpl<ThirdPartyResourceItemsNested<N>> implements ThirdPartyResourceItemsNested<N>{

        private final ThirdPartyResourceBuilder builder;
    
             ThirdPartyResourceItemsNestedImpl (){
        this.builder = new ThirdPartyResourceBuilder(this);
        }
             ThirdPartyResourceItemsNestedImpl ( ThirdPartyResource item){
        this.builder = new ThirdPartyResourceBuilder(this, item);
        }
    
            public N endThirdPartyResourceItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToThirdPartyResourceItems(builder.build());
        }
    
}
    public class NodeItemsNestedImpl<N> extends NodeFluentImpl<NodeItemsNested<N>> implements NodeItemsNested<N>{

        private final NodeBuilder builder;
    
             NodeItemsNestedImpl (){
        this.builder = new NodeBuilder(this);
        }
             NodeItemsNestedImpl ( Node item){
        this.builder = new NodeBuilder(this, item);
        }
    
            public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToNodeItems(builder.build());
        }
            public N endNodeItem(){
            return and();
        }
    
}
    public class TemplateItemsNestedImpl<N> extends TemplateFluentImpl<TemplateItemsNested<N>> implements TemplateItemsNested<N>{

        private final TemplateBuilder builder;
    
             TemplateItemsNestedImpl (){
        this.builder = new TemplateBuilder(this);
        }
             TemplateItemsNestedImpl ( Template item){
        this.builder = new TemplateBuilder(this, item);
        }
    
            public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToTemplateItems(builder.build());
        }
            public N endTemplateItem(){
            return and();
        }
    
}
    public class PodItemsNestedImpl<N> extends PodFluentImpl<PodItemsNested<N>> implements PodItemsNested<N>{

        private final PodBuilder builder;
    
             PodItemsNestedImpl (){
        this.builder = new PodBuilder(this);
        }
             PodItemsNestedImpl ( Pod item){
        this.builder = new PodBuilder(this, item);
        }
    
            public N endPodItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToPodItems(builder.build());
        }
    
}
    public class RoleItemsNestedImpl<N> extends RoleFluentImpl<RoleItemsNested<N>> implements RoleItemsNested<N>{

        private final RoleBuilder builder;
    
             RoleItemsNestedImpl (){
        this.builder = new RoleBuilder(this);
        }
             RoleItemsNestedImpl ( Role item){
        this.builder = new RoleBuilder(this, item);
        }
    
            public N endRoleItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToRoleItems(builder.build());
        }
    
}
    public class DeploymentConfigItemsNestedImpl<N> extends DeploymentConfigFluentImpl<DeploymentConfigItemsNested<N>> implements DeploymentConfigItemsNested<N>{

        private final DeploymentConfigBuilder builder;
    
             DeploymentConfigItemsNestedImpl (){
        this.builder = new DeploymentConfigBuilder(this);
        }
             DeploymentConfigItemsNestedImpl ( DeploymentConfig item){
        this.builder = new DeploymentConfigBuilder(this, item);
        }
    
            public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToDeploymentConfigItems(builder.build());
        }
            public N endDeploymentConfigItem(){
            return and();
        }
    
}
    public class ClusterPolicyItemsNestedImpl<N> extends ClusterPolicyFluentImpl<ClusterPolicyItemsNested<N>> implements ClusterPolicyItemsNested<N>{

        private final ClusterPolicyBuilder builder;
    
             ClusterPolicyItemsNestedImpl (){
        this.builder = new ClusterPolicyBuilder(this);
        }
             ClusterPolicyItemsNestedImpl ( ClusterPolicy item){
        this.builder = new ClusterPolicyBuilder(this, item);
        }
    
            public N endClusterPolicyItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToClusterPolicyItems(builder.build());
        }
    
}
    public class IdentityItemsNestedImpl<N> extends IdentityFluentImpl<IdentityItemsNested<N>> implements IdentityItemsNested<N>{

        private final IdentityBuilder builder;
    
             IdentityItemsNestedImpl ( Identity item){
        this.builder = new IdentityBuilder(this, item);
        }
             IdentityItemsNestedImpl (){
        this.builder = new IdentityBuilder(this);
        }
    
            public N endIdentityItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToIdentityItems(builder.build());
        }
    
}
    public class OAuthClientItemsNestedImpl<N> extends OAuthClientFluentImpl<OAuthClientItemsNested<N>> implements OAuthClientItemsNested<N>{

        private final OAuthClientBuilder builder;
    
             OAuthClientItemsNestedImpl ( OAuthClient item){
        this.builder = new OAuthClientBuilder(this, item);
        }
             OAuthClientItemsNestedImpl (){
        this.builder = new OAuthClientBuilder(this);
        }
    
            public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToOAuthClientItems(builder.build());
        }
            public N endOAuthClientItem(){
            return and();
        }
    
}
    public class OAuthClientAuthorizationItemsNestedImpl<N> extends OAuthClientAuthorizationFluentImpl<OAuthClientAuthorizationItemsNested<N>> implements OAuthClientAuthorizationItemsNested<N>{

        private final OAuthClientAuthorizationBuilder builder;
    
             OAuthClientAuthorizationItemsNestedImpl (){
        this.builder = new OAuthClientAuthorizationBuilder(this);
        }
             OAuthClientAuthorizationItemsNestedImpl ( OAuthClientAuthorization item){
        this.builder = new OAuthClientAuthorizationBuilder(this, item);
        }
    
            public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToOAuthClientAuthorizationItems(builder.build());
        }
            public N endOAuthClientAuthorizationItem(){
            return and();
        }
    
}
    public class RoleBindingItemsNestedImpl<N> extends RoleBindingFluentImpl<RoleBindingItemsNested<N>> implements RoleBindingItemsNested<N>{

        private final RoleBindingBuilder builder;
    
             RoleBindingItemsNestedImpl (){
        this.builder = new RoleBindingBuilder(this);
        }
             RoleBindingItemsNestedImpl ( RoleBinding item){
        this.builder = new RoleBindingBuilder(this, item);
        }
    
            public N endRoleBindingItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToRoleBindingItems(builder.build());
        }
    
}
    public class ClusterRoleBindingItemsNestedImpl<N> extends ClusterRoleBindingFluentImpl<ClusterRoleBindingItemsNested<N>> implements ClusterRoleBindingItemsNested<N>{

        private final ClusterRoleBindingBuilder builder;
    
             ClusterRoleBindingItemsNestedImpl (){
        this.builder = new ClusterRoleBindingBuilder(this);
        }
             ClusterRoleBindingItemsNestedImpl ( ClusterRoleBinding item){
        this.builder = new ClusterRoleBindingBuilder(this, item);
        }
    
            public N endClusterRoleBindingItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToClusterRoleBindingItems(builder.build());
        }
    
}
    public class ScaleItemsNestedImpl<N> extends ScaleFluentImpl<ScaleItemsNested<N>> implements ScaleItemsNested<N>{

        private final ScaleBuilder builder;
    
             ScaleItemsNestedImpl (){
        this.builder = new ScaleBuilder(this);
        }
             ScaleItemsNestedImpl ( Scale item){
        this.builder = new ScaleBuilder(this, item);
        }
    
            public N endScaleItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToScaleItems(builder.build());
        }
    
}
    public class BindingItemsNestedImpl<N> extends BindingFluentImpl<BindingItemsNested<N>> implements BindingItemsNested<N>{

        private final BindingBuilder builder;
    
             BindingItemsNestedImpl (){
        this.builder = new BindingBuilder(this);
        }
             BindingItemsNestedImpl ( Binding item){
        this.builder = new BindingBuilder(this, item);
        }
    
            public N endBindingItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToBindingItems(builder.build());
        }
    
}
    public class PolicyBindingItemsNestedImpl<N> extends PolicyBindingFluentImpl<PolicyBindingItemsNested<N>> implements PolicyBindingItemsNested<N>{

        private final PolicyBindingBuilder builder;
    
             PolicyBindingItemsNestedImpl (){
        this.builder = new PolicyBindingBuilder(this);
        }
             PolicyBindingItemsNestedImpl ( PolicyBinding item){
        this.builder = new PolicyBindingBuilder(this, item);
        }
    
            public N endPolicyBindingItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToPolicyBindingItems(builder.build());
        }
    
}
    public class ClusterPolicyBindingItemsNestedImpl<N> extends ClusterPolicyBindingFluentImpl<ClusterPolicyBindingItemsNested<N>> implements ClusterPolicyBindingItemsNested<N>{

        private final ClusterPolicyBindingBuilder builder;
    
             ClusterPolicyBindingItemsNestedImpl (){
        this.builder = new ClusterPolicyBindingBuilder(this);
        }
             ClusterPolicyBindingItemsNestedImpl ( ClusterPolicyBinding item){
        this.builder = new ClusterPolicyBindingBuilder(this, item);
        }
    
            public N endClusterPolicyBindingItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToClusterPolicyBindingItems(builder.build());
        }
    
}
    public class ImageStreamItemsNestedImpl<N> extends ImageStreamFluentImpl<ImageStreamItemsNested<N>> implements ImageStreamItemsNested<N>{

        private final ImageStreamBuilder builder;
    
             ImageStreamItemsNestedImpl (){
        this.builder = new ImageStreamBuilder(this);
        }
             ImageStreamItemsNestedImpl ( ImageStream item){
        this.builder = new ImageStreamBuilder(this, item);
        }
    
            public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToImageStreamItems(builder.build());
        }
            public N endImageStreamItem(){
            return and();
        }
    
}
    public class IngressItemsNestedImpl<N> extends IngressFluentImpl<IngressItemsNested<N>> implements IngressItemsNested<N>{

        private final IngressBuilder builder;
    
             IngressItemsNestedImpl (){
        this.builder = new IngressBuilder(this);
        }
             IngressItemsNestedImpl ( Ingress item){
        this.builder = new IngressBuilder(this, item);
        }
    
            public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToIngressItems(builder.build());
        }
            public N endIngressItem(){
            return and();
        }
    
}
    public class ComponentStatusItemsNestedImpl<N> extends ComponentStatusFluentImpl<ComponentStatusItemsNested<N>> implements ComponentStatusItemsNested<N>{

        private final ComponentStatusBuilder builder;
    
             ComponentStatusItemsNestedImpl (){
        this.builder = new ComponentStatusBuilder(this);
        }
             ComponentStatusItemsNestedImpl ( ComponentStatus item){
        this.builder = new ComponentStatusBuilder(this, item);
        }
    
            public N endComponentStatusItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToComponentStatusItems(builder.build());
        }
    
}
    public class EndpointsItemsNestedImpl<N> extends EndpointsFluentImpl<EndpointsItemsNested<N>> implements EndpointsItemsNested<N>{

        private final EndpointsBuilder builder;
    
             EndpointsItemsNestedImpl (){
        this.builder = new EndpointsBuilder(this);
        }
             EndpointsItemsNestedImpl ( Endpoints item){
        this.builder = new EndpointsBuilder(this, item);
        }
    
            public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToEndpointsItems(builder.build());
        }
            public N endEndpointsItem(){
            return and();
        }
    
}
    public class ProjectRequestItemsNestedImpl<N> extends ProjectRequestFluentImpl<ProjectRequestItemsNested<N>> implements ProjectRequestItemsNested<N>{

        private final ProjectRequestBuilder builder;
    
             ProjectRequestItemsNestedImpl (){
        this.builder = new ProjectRequestBuilder(this);
        }
             ProjectRequestItemsNestedImpl ( ProjectRequest item){
        this.builder = new ProjectRequestBuilder(this, item);
        }
    
            public N endProjectRequestItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToProjectRequestItems(builder.build());
        }
    
}
    public class ResourceQuotaItemsNestedImpl<N> extends ResourceQuotaFluentImpl<ResourceQuotaItemsNested<N>> implements ResourceQuotaItemsNested<N>{

        private final ResourceQuotaBuilder builder;
    
             ResourceQuotaItemsNestedImpl (){
        this.builder = new ResourceQuotaBuilder(this);
        }
             ResourceQuotaItemsNestedImpl ( ResourceQuota item){
        this.builder = new ResourceQuotaBuilder(this, item);
        }
    
            public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToResourceQuotaItems(builder.build());
        }
            public N endResourceQuotaItem(){
            return and();
        }
    
}
    public class ServiceItemsNestedImpl<N> extends ServiceFluentImpl<ServiceItemsNested<N>> implements ServiceItemsNested<N>{

        private final ServiceBuilder builder;
    
             ServiceItemsNestedImpl (){
        this.builder = new ServiceBuilder(this);
        }
             ServiceItemsNestedImpl ( Service item){
        this.builder = new ServiceBuilder(this, item);
        }
    
            public N endServiceItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToServiceItems(builder.build());
        }
    
}
    public class PodTemplateItemsNestedImpl<N> extends PodTemplateFluentImpl<PodTemplateItemsNested<N>> implements PodTemplateItemsNested<N>{

        private final PodTemplateBuilder builder;
    
             PodTemplateItemsNestedImpl (){
        this.builder = new PodTemplateBuilder(this);
        }
             PodTemplateItemsNestedImpl ( PodTemplate item){
        this.builder = new PodTemplateBuilder(this, item);
        }
    
            public N endPodTemplateItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToPodTemplateItems(builder.build());
        }
    
}
    public class PolicyItemsNestedImpl<N> extends PolicyFluentImpl<PolicyItemsNested<N>> implements PolicyItemsNested<N>{

        private final PolicyBuilder builder;
    
             PolicyItemsNestedImpl ( Policy item){
        this.builder = new PolicyBuilder(this, item);
        }
             PolicyItemsNestedImpl (){
        this.builder = new PolicyBuilder(this);
        }
    
            public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToPolicyItems(builder.build());
        }
            public N endPolicyItem(){
            return and();
        }
    
}
    public class ClusterRoleItemsNestedImpl<N> extends ClusterRoleFluentImpl<ClusterRoleItemsNested<N>> implements ClusterRoleItemsNested<N>{

        private final ClusterRoleBuilder builder;
    
             ClusterRoleItemsNestedImpl (){
        this.builder = new ClusterRoleBuilder(this);
        }
             ClusterRoleItemsNestedImpl ( ClusterRole item){
        this.builder = new ClusterRoleBuilder(this, item);
        }
    
            public N endClusterRoleItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToClusterRoleItems(builder.build());
        }
    
}
    public class RouteItemsNestedImpl<N> extends RouteFluentImpl<RouteItemsNested<N>> implements RouteItemsNested<N>{

        private final RouteBuilder builder;
    
             RouteItemsNestedImpl (){
        this.builder = new RouteBuilder(this);
        }
             RouteItemsNestedImpl ( Route item){
        this.builder = new RouteBuilder(this, item);
        }
    
            public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToRouteItems(builder.build());
        }
            public N endRouteItem(){
            return and();
        }
    
}
    public class PersistentVolumeClaimItemsNestedImpl<N> extends PersistentVolumeClaimFluentImpl<PersistentVolumeClaimItemsNested<N>> implements PersistentVolumeClaimItemsNested<N>{

        private final PersistentVolumeClaimBuilder builder;
    
             PersistentVolumeClaimItemsNestedImpl (){
        this.builder = new PersistentVolumeClaimBuilder(this);
        }
             PersistentVolumeClaimItemsNestedImpl ( PersistentVolumeClaim item){
        this.builder = new PersistentVolumeClaimBuilder(this, item);
        }
    
            public N endPersistentVolumeClaimItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToPersistentVolumeClaimItems(builder.build());
        }
    
}
    public class ReplicationControllerItemsNestedImpl<N> extends ReplicationControllerFluentImpl<ReplicationControllerItemsNested<N>> implements ReplicationControllerItemsNested<N>{

        private final ReplicationControllerBuilder builder;
    
             ReplicationControllerItemsNestedImpl (){
        this.builder = new ReplicationControllerBuilder(this);
        }
             ReplicationControllerItemsNestedImpl ( ReplicationController item){
        this.builder = new ReplicationControllerBuilder(this, item);
        }
    
            public N endReplicationControllerItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToReplicationControllerItems(builder.build());
        }
    
}
    public class ImageItemsNestedImpl<N> extends ImageFluentImpl<ImageItemsNested<N>> implements ImageItemsNested<N>{

        private final ImageBuilder builder;
    
             ImageItemsNestedImpl ( Image item){
        this.builder = new ImageBuilder(this, item);
        }
             ImageItemsNestedImpl (){
        this.builder = new ImageBuilder(this);
        }
    
            public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToImageItems(builder.build());
        }
            public N endImageItem(){
            return and();
        }
    
}
    public class GroupItemsNestedImpl<N> extends GroupFluentImpl<GroupItemsNested<N>> implements GroupItemsNested<N>{

        private final GroupBuilder builder;
    
             GroupItemsNestedImpl (){
        this.builder = new GroupBuilder(this);
        }
             GroupItemsNestedImpl ( Group item){
        this.builder = new GroupBuilder(this, item);
        }
    
            public N endGroupItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToGroupItems(builder.build());
        }
    
}
    public class OAuthAuthorizeTokenItemsNestedImpl<N> extends OAuthAuthorizeTokenFluentImpl<OAuthAuthorizeTokenItemsNested<N>> implements OAuthAuthorizeTokenItemsNested<N>{

        private final OAuthAuthorizeTokenBuilder builder;
    
             OAuthAuthorizeTokenItemsNestedImpl (){
        this.builder = new OAuthAuthorizeTokenBuilder(this);
        }
             OAuthAuthorizeTokenItemsNestedImpl ( OAuthAuthorizeToken item){
        this.builder = new OAuthAuthorizeTokenBuilder(this, item);
        }
    
            public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToOAuthAuthorizeTokenItems(builder.build());
        }
            public N endOAuthAuthorizeTokenItem(){
            return and();
        }
    
}
    public class BuildConfigItemsNestedImpl<N> extends BuildConfigFluentImpl<BuildConfigItemsNested<N>> implements BuildConfigItemsNested<N>{

        private final BuildConfigBuilder builder;
    
             BuildConfigItemsNestedImpl (){
        this.builder = new BuildConfigBuilder(this);
        }
             BuildConfigItemsNestedImpl ( BuildConfig item){
        this.builder = new BuildConfigBuilder(this, item);
        }
    
            public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToBuildConfigItems(builder.build());
        }
            public N endBuildConfigItem(){
            return and();
        }
    
}
    public class EventItemsNestedImpl<N> extends EventFluentImpl<EventItemsNested<N>> implements EventItemsNested<N>{

        private final EventBuilder builder;
    
             EventItemsNestedImpl (){
        this.builder = new EventBuilder(this);
        }
             EventItemsNestedImpl ( Event item){
        this.builder = new EventBuilder(this, item);
        }
    
            public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToEventItems(builder.build());
        }
            public N endEventItem(){
            return and();
        }
    
}
    public class MetadataNestedImpl<N> extends ListMetaFluentImpl<MetadataNested<N>> implements MetadataNested<N>{

        private final ListMetaBuilder builder;
    
             MetadataNestedImpl (){
        this.builder = new ListMetaBuilder(this);
        }
             MetadataNestedImpl ( ListMeta item){
        this.builder = new ListMetaBuilder(this, item);
        }
    
            public N and(){
            return (N) BaseKubernetesListFluentImpl.this.withMetadata(builder.build());
        }
            public N endMetadata(){
            return and();
        }
    
}


}
