package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class EndpointSubsetFluentImpl<T extends EndpointSubsetFluent<T>> extends BaseFluent<T> implements EndpointSubsetFluent<T>{

     List<VisitableBuilder<EndpointAddress, ?>> addresses = new ArrayList();     List<VisitableBuilder<EndpointAddress, ?>> notReadyAddresses = new ArrayList();     List<VisitableBuilder<EndpointPort, ?>> ports = new ArrayList();     Map<String, Object> additionalProperties = new HashMap();
public EndpointSubsetFluentImpl(){
    
}
public EndpointSubsetFluentImpl( EndpointSubset instance ){
    this.withAddresses(instance.getAddresses()); this.withNotReadyAddresses(instance.getNotReadyAddresses()); this.withPorts(instance.getPorts()); 
}

    public T addToAddresses( EndpointAddress ...items){
    for (EndpointAddress item : items) {EndpointAddressBuilder builder = new EndpointAddressBuilder(item);_visitables.add(builder);this.addresses.add(builder);} return (T)this;
    }
    public T removeFromAddresses( EndpointAddress ...items){
    for (EndpointAddress item : items) {EndpointAddressBuilder builder = new EndpointAddressBuilder(item);_visitables.remove(builder);this.addresses.remove(builder);} return (T)this;
    }
    public List<EndpointAddress> getAddresses(){
    return build(addresses);
    }
    public T withAddresses( List<EndpointAddress> addresses){
    this.addresses.clear();if (addresses != null) {for (EndpointAddress item : addresses){this.addToAddresses(item);}} return (T) this;
    }
    public T withAddresses( EndpointAddress ...addresses){
    this.addresses.clear(); if (addresses != null) {for (EndpointAddress item :addresses){ this.addToAddresses(item);}} return (T) this;
    }
    public AddressesNested<T> addNewAddresse(){
    return new AddressesNestedImpl<T>();
    }
    public AddressesNested<T> addNewAddresseLike( EndpointAddress item){
    return new AddressesNestedImpl<T>(item);
    }
    public T addToNotReadyAddresses( EndpointAddress ...items){
    for (EndpointAddress item : items) {EndpointAddressBuilder builder = new EndpointAddressBuilder(item);_visitables.add(builder);this.notReadyAddresses.add(builder);} return (T)this;
    }
    public T removeFromNotReadyAddresses( EndpointAddress ...items){
    for (EndpointAddress item : items) {EndpointAddressBuilder builder = new EndpointAddressBuilder(item);_visitables.remove(builder);this.notReadyAddresses.remove(builder);} return (T)this;
    }
    public List<EndpointAddress> getNotReadyAddresses(){
    return build(notReadyAddresses);
    }
    public T withNotReadyAddresses( List<EndpointAddress> notReadyAddresses){
    this.notReadyAddresses.clear();if (notReadyAddresses != null) {for (EndpointAddress item : notReadyAddresses){this.addToNotReadyAddresses(item);}} return (T) this;
    }
    public T withNotReadyAddresses( EndpointAddress ...notReadyAddresses){
    this.notReadyAddresses.clear(); if (notReadyAddresses != null) {for (EndpointAddress item :notReadyAddresses){ this.addToNotReadyAddresses(item);}} return (T) this;
    }
    public NotReadyAddressesNested<T> addNewNotReadyAddresse(){
    return new NotReadyAddressesNestedImpl<T>();
    }
    public NotReadyAddressesNested<T> addNewNotReadyAddresseLike( EndpointAddress item){
    return new NotReadyAddressesNestedImpl<T>(item);
    }
    public T addToPorts( EndpointPort ...items){
    for (EndpointPort item : items) {EndpointPortBuilder builder = new EndpointPortBuilder(item);_visitables.add(builder);this.ports.add(builder);} return (T)this;
    }
    public T removeFromPorts( EndpointPort ...items){
    for (EndpointPort item : items) {EndpointPortBuilder builder = new EndpointPortBuilder(item);_visitables.remove(builder);this.ports.remove(builder);} return (T)this;
    }
    public List<EndpointPort> getPorts(){
    return build(ports);
    }
    public T withPorts( List<EndpointPort> ports){
    this.ports.clear();if (ports != null) {for (EndpointPort item : ports){this.addToPorts(item);}} return (T) this;
    }
    public T withPorts( EndpointPort ...ports){
    this.ports.clear(); if (ports != null) {for (EndpointPort item :ports){ this.addToPorts(item);}} return (T) this;
    }
    public PortsNested<T> addNewPort(){
    return new PortsNestedImpl<T>();
    }
    public PortsNested<T> addNewPortLike( EndpointPort item){
    return new PortsNestedImpl<T>(item);
    }
    public T addNewPort( String name,  Integer port,  String protocol){
    return addToPorts(new EndpointPort(name, port, protocol));
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
EndpointSubsetFluentImpl that = (EndpointSubsetFluentImpl) o;
if (addresses != null ? !addresses.equals(that.addresses) :that.addresses != null) return false;
if (notReadyAddresses != null ? !notReadyAddresses.equals(that.notReadyAddresses) :that.notReadyAddresses != null) return false;
if (ports != null ? !ports.equals(that.ports) :that.ports != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class AddressesNestedImpl<N> extends EndpointAddressFluentImpl<AddressesNested<N>> implements AddressesNested<N>{

        private final EndpointAddressBuilder builder;
    
             AddressesNestedImpl (){
        this.builder = new EndpointAddressBuilder(this);
        }
             AddressesNestedImpl ( EndpointAddress item){
        this.builder = new EndpointAddressBuilder(this, item);
        }
    
            public N and(){
            return (N) EndpointSubsetFluentImpl.this.addToAddresses(builder.build());
        }
            public N endAddresse(){
            return and();
        }
    
}
    public class NotReadyAddressesNestedImpl<N> extends EndpointAddressFluentImpl<NotReadyAddressesNested<N>> implements NotReadyAddressesNested<N>{

        private final EndpointAddressBuilder builder;
    
             NotReadyAddressesNestedImpl (){
        this.builder = new EndpointAddressBuilder(this);
        }
             NotReadyAddressesNestedImpl ( EndpointAddress item){
        this.builder = new EndpointAddressBuilder(this, item);
        }
    
            public N endNotReadyAddresse(){
            return and();
        }
            public N and(){
            return (N) EndpointSubsetFluentImpl.this.addToNotReadyAddresses(builder.build());
        }
    
}
    public class PortsNestedImpl<N> extends EndpointPortFluentImpl<PortsNested<N>> implements PortsNested<N>{

        private final EndpointPortBuilder builder;
    
             PortsNestedImpl (){
        this.builder = new EndpointPortBuilder(this);
        }
             PortsNestedImpl ( EndpointPort item){
        this.builder = new EndpointPortBuilder(this, item);
        }
    
            public N endPort(){
            return and();
        }
            public N and(){
            return (N) EndpointSubsetFluentImpl.this.addToPorts(builder.build());
        }
    
}


}
