package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface DeploymentStrategyFluent<T extends DeploymentStrategyFluent<T>> extends Fluent<T>{


    public CustomDeploymentStrategyParams getCustomParams();    public T withCustomParams( CustomDeploymentStrategyParams customParams);    public CustomParamsNested<T> withNewCustomParams();    public CustomParamsNested<T> withNewCustomParamsLike( CustomDeploymentStrategyParams item);    public CustomParamsNested<T> editCustomParams();    public RecreateDeploymentStrategyParams getRecreateParams();    public T withRecreateParams( RecreateDeploymentStrategyParams recreateParams);    public RecreateParamsNested<T> withNewRecreateParams();    public RecreateParamsNested<T> withNewRecreateParamsLike( RecreateDeploymentStrategyParams item);    public RecreateParamsNested<T> editRecreateParams();    public ResourceRequirements getResources();    public T withResources( ResourceRequirements resources);    public ResourcesNested<T> withNewResources();    public ResourcesNested<T> withNewResourcesLike( ResourceRequirements item);    public ResourcesNested<T> editResources();    public RollingDeploymentStrategyParams getRollingParams();    public T withRollingParams( RollingDeploymentStrategyParams rollingParams);    public RollingParamsNested<T> withNewRollingParams();    public RollingParamsNested<T> withNewRollingParamsLike( RollingDeploymentStrategyParams item);    public RollingParamsNested<T> editRollingParams();    public String getType();    public T withType( String type);    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface CustomParamsNested<N> extends Nested<N>, CustomDeploymentStrategyParamsFluent<CustomParamsNested<N>>{
            public N endCustomParams();            public N and();        
}

    public interface RecreateParamsNested<N> extends Nested<N>, RecreateDeploymentStrategyParamsFluent<RecreateParamsNested<N>>{
            public N and();            public N endRecreateParams();        
}

    public interface ResourcesNested<N> extends Nested<N>, ResourceRequirementsFluent<ResourcesNested<N>>{
            public N and();            public N endResources();        
}

    public interface RollingParamsNested<N> extends Nested<N>, RollingDeploymentStrategyParamsFluent<RollingParamsNested<N>>{
            public N and();            public N endRollingParams();        
}


}
